/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.pas.api;

import com.danrus.pas.managers.PasManager;
import com.danrus.pas.utils.StringUtils;
import java.util.List;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

public class NameInfo {
    private String base;
    private String params;
    private String overlay;
    private int blend;
    private boolean cape;
    private String capeProvider;
    private String capeId;
    private static final String FLAG_SLIM = "S";

    public NameInfo() {
        this("", "");
    }

    public NameInfo(String base) {
        this(base, "");
    }

    public NameInfo(String base, String params) {
        this(base, params, "", 100);
    }

    public NameInfo(String base, String params, String overlay, int blend) {
        this(base, params, overlay, blend, new CapeInfo());
    }

    private NameInfo(String base, String params, String overlay, int blend, CapeInfo cape) {
        this.base = base;
        this.params = NameInfo.normalizeParams(params);
        this.overlay = overlay;
        this.blend = NameInfo.clamp(blend, 0, 100);
        this.cape = cape.enabled;
        this.capeProvider = cape.provider;
        this.capeId = cape.id;
    }

    public static NameInfo parse(class_2561 input) {
        if (input != null) {
            return NameInfo.parse(input.getString());
        }
        return new NameInfo();
    }

    public static NameInfo parse(String input) {
        if (input == null) {
            return new NameInfo();
        }
        String[] divided = input.split("\\|", -1);
        if (divided.length == 0 || divided[0].isEmpty()) {
            return new NameInfo();
        }
        String name = divided[0].trim();
        if (name.matches(".*[<>:\"/\\?*].*")) {
            return new NameInfo();
        }
        if (divided.length < 2) {
            return new NameInfo(name);
        }
        String rawParams = divided[1].trim();
        String overlay = "";
        int blend = 100;
        List<String> textureMatch = StringUtils.matchTexture(rawParams);
        if (!textureMatch.get(0).isEmpty()) {
            overlay = textureMatch.get(0);
            blend = NameInfo.safeParseInt(textureMatch.get(1), 100);
            rawParams = textureMatch.get(2).trim();
        }
        List<String> capeMatch = StringUtils.matchCape(rawParams);
        CapeInfo info = new CapeInfo();
        if (capeMatch.get(0).contains("C")) {
            info = new CapeInfo(true, capeMatch.get(1), capeMatch.get(2));
        }
        rawParams = capeMatch.get(3).trim();
        return new NameInfo(name, rawParams, overlay, blend, info);
    }

    public String compile() {
        StringBuilder out = new StringBuilder();
        out.append(this.base == null ? "" : this.base);
        if (this.params != null && !this.params.isEmpty()) {
            out.append("|").append(this.params);
        }
        if (this.overlay != null && !this.overlay.isEmpty()) {
            if (this.params == null || this.params.isEmpty()) {
                out.append("|");
            }
            out.append("T:").append(this.overlay).append("%").append(this.blend);
        }
        if (this.cape) {
            if ((this.params == null || this.params.isEmpty()) && this.overlay.isEmpty()) {
                out.append("|");
            }
            out.append("C");
            if (!this.capeProvider.isEmpty() && !this.capeId.isEmpty()) {
                out.append(":").append(this.capeProvider).append("%").append(this.capeId);
            }
        }
        return out.toString();
    }

    private static String normalizeParams(String raw) {
        if (raw == null || raw.isEmpty()) {
            return "";
        }
        String p = raw.replaceAll("\\s+", "").toUpperCase();
        List<String> textureMatch = StringUtils.matchTexture(p);
        if (!textureMatch.get(0).isEmpty()) {
            p = textureMatch.get(2).trim().toUpperCase();
        }
        StringBuilder sb = new StringBuilder();
        boolean[] seen = new boolean[256];
        for (int i = 0; i < p.length(); ++i) {
            char ch = p.charAt(i);
            if (ch >= '\u0100' || seen[ch]) continue;
            seen[ch] = true;
            sb.append(ch);
        }
        return sb.toString();
    }

    private static int clamp(int v, int lo, int hi) {
        return Math.max(lo, Math.min(hi, v));
    }

    private static int safeParseInt(String s, int def) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return def;
        }
    }

    public boolean isEmpty() {
        return this.base == null || this.base.isEmpty();
    }

    public String getDesiredProvider() {
        List<String> providers = PasManager.getInstance().getExistingProviders();
        for (String prov : providers) {
            if (!this.params.contains(prov)) continue;
            return prov;
        }
        return "M";
    }

    public boolean wantBeSlim() {
        return this.params.contains(FLAG_SLIM);
    }

    public boolean wantCape() {
        return this.cape;
    }

    public void setSlim(boolean value) {
        this.toggleFlag(FLAG_SLIM, value);
    }

    public void setCape(boolean value) {
        this.cape = value;
    }

    public void setProvider(String literal) {
        List<String> providers = PasManager.getInstance().getExistingProviders();
        Object p = this.params;
        for (String prov : providers) {
            p = ((String)p).replace(prov, "");
        }
        p = (String)p + literal;
        this.params = NameInfo.normalizeParams((String)p);
    }

    private void toggleFlag(String literal, boolean on) {
        Object p = this.params.replace(literal, "");
        if (on) {
            p = (String)p + literal;
        }
        this.params = NameInfo.normalizeParams((String)p);
    }

    public void setName(String newName) {
        this.base = newName == null ? "" : newName;
    }

    public void setOverlay(String textureName) {
        this.overlay = textureName == null ? "" : textureName;
    }

    public void setBlend(int blend) {
        this.blend = NameInfo.clamp(blend, 0, 100);
    }

    public void setCapeId(String capeId) {
        this.capeId = capeId;
    }

    public void setCapeProvider(String capeProvider) {
        this.capeProvider = capeProvider;
    }

    public String base() {
        return this.base;
    }

    public String params() {
        return this.params;
    }

    public String overlay() {
        return this.overlay;
    }

    public int blend() {
        return this.blend;
    }

    public String capeId() {
        return this.capeId;
    }

    public String capeProvider() {
        return this.capeProvider;
    }

    @NotNull
    public String toString() {
        return "NameInfo[" + this.base + ", " + this.params + "]";
    }

    private record CapeInfo(boolean enabled, String provider, String id) {
        private CapeInfo() {
            this(false, "", "");
        }
    }
}

