/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.pas.impl.providers;

import com.danrus.pas.ModExecutor;
import com.danrus.pas.PlayerArmorStandsClient;
import com.danrus.pas.api.DownloadStatus;
import com.danrus.pas.api.data.TextureProvider;
import com.danrus.pas.api.info.NameInfo;
import com.danrus.pas.api.reg.InfoTranslators;
import com.danrus.pas.impl.data.common.AbstractDiskDataProvider;
import com.danrus.pas.impl.features.CapeFeature;
import com.danrus.pas.impl.features.SkinProviderFeature;
import com.danrus.pas.impl.holder.CapeData;
import com.danrus.pas.impl.holder.SkinData;
import com.danrus.pas.managers.OverlayMessageManger;
import com.danrus.pas.managers.PasManager;
import com.danrus.pas.utils.EncodeUtils;
import com.danrus.pas.utils.MojangUtils;
import com.danrus.pas.utils.RestHelper;
import com.danrus.pas.utils.SkinDownloader;
import com.google.gson.Gson;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;

public class MojangProvider
implements TextureProvider {
    private static final MojangProvider INSTANCE = new MojangProvider();
    private static final String SESSION_SERVER_URL = "https://sessionserver.mojang.com/session/minecraft/profile/";
    private final Map<String, CompletableFuture<Void>> activeDownloads = new ConcurrentHashMap<String, CompletableFuture<Void>>();
    private final Gson gson = new Gson();
    private final String literal = "M";

    private MojangProvider() {
    }

    public static MojangProvider getInstance() {
        return INSTANCE;
    }

    @Override
    public String getLiteral() {
        return "M";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(NameInfo info, Consumer<String> onComplete) {
        Map<String, CompletableFuture<Void>> map = this.activeDownloads;
        synchronized (map) {
            CompletableFuture<Void> existing = this.activeDownloads.get(info.base());
            if (existing != null) {
                existing.thenAccept(v -> onComplete.accept(info.base()));
                PlayerArmorStandsClient.LOGGER.info("MojangProvider: Reusing active download for " + info.base());
                return;
            }
        }
        if (!MojangUtils.isNicknameValid(info.base())) {
            OverlayMessageManger.getInstance().showInvalidNameMessage(info.base());
            ModExecutor.execute(() -> this.invalidateAllData(info));
            onComplete.accept(info.base());
            return;
        }
        this.initializeDownload(info);
        CompletableFuture<Void> downloadFuture = this.downloadProfile(info, onComplete);
        Map<String, CompletableFuture<Void>> map2 = this.activeDownloads;
        synchronized (map2) {
            this.activeDownloads.put(info.base(), downloadFuture);
        }
        downloadFuture.whenComplete((v, throwable) -> {
            Map<String, CompletableFuture<Void>> map = this.activeDownloads;
            synchronized (map) {
                this.activeDownloads.remove(info.base());
            }
        });
    }

    private void initializeDownload(NameInfo info) {
        PlayerArmorStandsClient.LOGGER.info("MojangProvider: Downloading textures for " + String.valueOf(info));
        OverlayMessageManger.getInstance().showDownloadMessage(info.base());
        if (info.getFeature(SkinProviderFeature.class).getProvider().equals(this.getLiteral())) {
            SkinData skinData = new SkinData(info);
            skinData.setStatus(DownloadStatus.IN_PROGRESS);
            PasManager.getInstance().getSkinDataManager().store(info, skinData);
        }
        if (info.getFeature(CapeFeature.class).getProvider().equals(this.getLiteral())) {
            CapeData capeData = new CapeData(info);
            capeData.setStatus(DownloadStatus.IN_PROGRESS);
            PasManager.getInstance().getCapeDataManager().store(info, capeData);
        }
    }

    private CompletableFuture<Void> downloadProfile(NameInfo info, Consumer<String> onComplete) {
        return ((CompletableFuture)((CompletableFuture)MojangUtils.getUUID(info).thenCompose(this::downloadTexturedProfile)).thenCompose(texturedProfile -> this.processTexturedProfile((TexturedProfile)texturedProfile, info, onComplete))).exceptionally(throwable -> {
            this.doFail(info);
            PlayerArmorStandsClient.LOGGER.error("MojangProvider: Failed to download for " + String.valueOf(info), throwable);
            return null;
        });
    }

    private CompletableFuture<TexturedProfile> downloadTexturedProfile(String uuid) {
        return RestHelper.get(SESSION_SERVER_URL + uuid).thenApply(response -> {
            Profile profile = (Profile)this.gson.fromJson(response, Profile.class);
            if (!this.isValidProfile(profile)) {
                throw new RuntimeException("Invalid profile");
            }
            String encodedSkin = EncodeUtils.decodeBase64(profile.properties[0].value);
            TexturedProfile texturedProfile = (TexturedProfile)this.gson.fromJson(encodedSkin, TexturedProfile.class);
            if (!this.isValidTexturedProfile(texturedProfile)) {
                throw new RuntimeException("Invalid textured profile");
            }
            return texturedProfile;
        });
    }

    private CompletableFuture<Void> processTexturedProfile(TexturedProfile profile, NameInfo info, Consumer<String> onComplete) {
        CompletableFuture<Void> skinFuture = this.processSkinTexture(profile, info);
        CompletableFuture<Void> capeFuture = this.processCapeTexture(profile, info);
        return CompletableFuture.allOf(skinFuture, capeFuture).thenRun(() -> {
            OverlayMessageManger.getInstance().showSuccessMessage(info.base());
            PlayerArmorStandsClient.LOGGER.info("MojangProvider: Successfully downloaded textures for " + String.valueOf(info));
            onComplete.accept(info.base());
        });
    }

    private CompletableFuture<Void> processSkinTexture(TexturedProfile profile, NameInfo info) {
        if (!info.getFeature(SkinProviderFeature.class).getProvider().equals("M")) {
            return CompletableFuture.completedFuture(null);
        }
        PlayerArmorStandsClient.LOGGER.info("processSkinTexture called for {}", (Object)info);
        if (profile.textures.SKIN == null || profile.textures.SKIN.url == null) {
            SkinData data = new SkinData(info);
            data.setStatus(DownloadStatus.FAILED);
            PasManager.getInstance().getSkinDataManager().store(info, data);
            return CompletableFuture.completedFuture(null);
        }
        ResourceLocation skinLocation = InfoTranslators.getInstance().toResourceLocation(SkinData.class, info);
        String fileName = InfoTranslators.getInstance().toFileName(SkinData.class, info);
        Path filePath = AbstractDiskDataProvider.CACHE_PATH.resolve(fileName + ".png");
        return SkinDownloader.downloadAndRegister(skinLocation, filePath, profile.textures.SKIN.url, true).thenAccept(textureId -> {
            SkinData data = new SkinData(info);
            data.setTexture((ResourceLocation)textureId);
            data.setStatus(DownloadStatus.COMPLETED);
            PasManager.getInstance().getSkinDataManager().store(info, data);
        });
    }

    private CompletableFuture<Void> processCapeTexture(TexturedProfile profile, NameInfo info) {
        if (!info.getFeature(CapeFeature.class).getProvider().equals("M")) {
            return CompletableFuture.completedFuture(null);
        }
        PlayerArmorStandsClient.LOGGER.info("processCapeTexture called for {}", (Object)info);
        if (profile.textures.CAPE == null || profile.textures.CAPE.url == null) {
            CapeData data = new CapeData(info);
            data.setStatus(DownloadStatus.COMPLETED);
            PasManager.getInstance().getCapeDataManager().store(info, data);
            return CompletableFuture.completedFuture(null);
        }
        ResourceLocation capeLocation = InfoTranslators.getInstance().toResourceLocation(CapeData.class, info);
        String fileName = InfoTranslators.getInstance().toFileName(CapeData.class, info);
        Path filePath = AbstractDiskDataProvider.CACHE_PATH.resolve(fileName + ".png");
        return SkinDownloader.downloadAndRegister(capeLocation, filePath, profile.textures.CAPE.url, false).thenAccept(textureId -> {
            CapeData data = new CapeData(info);
            data.setTexture((ResourceLocation)textureId);
            data.setStatus(DownloadStatus.COMPLETED);
            PasManager.getInstance().getCapeDataManager().store(info, data);
        });
    }

    private boolean isValidProfile(Profile profile) {
        return profile != null && profile.id != null && profile.properties != null && profile.properties.length > 0;
    }

    private boolean isValidTexturedProfile(TexturedProfile profile) {
        return profile != null && profile.textures != null;
    }

    private void doFail(NameInfo info) {
        OverlayMessageManger.getInstance().showFailMessage(info.base());
        SkinData skinData = new SkinData(info);
        skinData.setStatus(DownloadStatus.FAILED);
        PasManager.getInstance().getSkinDataManager().store(info, skinData);
        CapeData capeData = new CapeData(info);
        capeData.setStatus(DownloadStatus.FAILED);
        PasManager.getInstance().getCapeDataManager().store(info, capeData);
    }

    private void invalidateAllData(NameInfo info) {
        PasManager.getInstance().getSkinDataManager().invalidateData(info);
        PasManager.getInstance().getCapeDataManager().invalidateData(info);
    }

    static class TexturedProfile {
        public Textures textures;

        TexturedProfile() {
        }

        static class Textures {
            public Texture SKIN;
            public Texture CAPE;

            Textures() {
            }

            static class Texture {
                public String url;

                Texture() {
                }
            }
        }
    }

    static class Profile {
        public String id;
        public String name;
        public ProfileProperty[] properties;

        Profile() {
        }

        static class ProfileProperty {
            public String name;
            public String value;

            ProfileProperty() {
            }
        }
    }
}

