/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.pas.impl.providers.common;

import com.danrus.pas.api.data.DataHolder;
import com.danrus.pas.api.data.DataRepository;
import com.danrus.pas.api.data.TextureProvider;
import com.danrus.pas.api.data.TextureProvidersManager;
import com.danrus.pas.api.info.NameInfo;
import com.danrus.pas.managers.PasManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTextureProviderManager<T extends DataHolder>
implements TextureProvidersManager {
    private final Logger LOGGER = LoggerFactory.getLogger((String)this.getName());
    private boolean initialized = false;
    private PasManager pasManager;
    private final Map<String, List<PrioritizedProvider>> providers = new HashMap<String, List<PrioritizedProvider>>();
    private final List<String> pendingList = new ArrayList<String>();

    public void initialize(PasManager manager) {
        if (!this.initialized) {
            this.pasManager = manager;
            this.initialized = true;
            this.prepareProviders();
        }
    }

    @Override
    public void addProvider(TextureProvider provider) {
        this.addProvider(provider, 0);
    }

    @Override
    public void addProvider(TextureProvider provider, int priority) {
        this.providers.computeIfAbsent(provider.getLiteral(), k -> new ArrayList()).add(new PrioritizedProvider(provider, priority));
        this.providers.get(provider.getLiteral()).sort(Comparator.comparingInt(PrioritizedProvider::priority).reversed());
        if (this.pasManager != null && this.pasManager.getExistingProviders() != null && this.registerAsExistingProvider()) {
            this.pasManager.getExistingProviders().add(provider.getLiteral());
        }
    }

    @Override
    public void download(NameInfo info) {
        String literal;
        if (this.pendingList.contains(info.base())) {
            return;
        }
        if (info.base().isEmpty()) {
            this.LOGGER.warn(this.getClass().getSimpleName() + ": Invalid input " + info.base());
            return;
        }
        boolean loaded = false;
        for (char c : this.getExcludeLiterals().toCharArray()) {
            String literal2 = String.valueOf(c);
            if (!this.getProvider(info).equals(literal2) || !this.tryLoadFromProviders(literal2, info)) continue;
            loaded = true;
            break;
        }
        if (!loaded && !this.getExcludeLiterals().contains(this.getProvider(info)) && this.tryLoadFromProviders(literal = this.getProvider(info), info)) {
            loaded = true;
        }
        if (!loaded && this.tryLoadFromProviders(this.getDefaultLiteral(), info)) {
            loaded = true;
        }
        if (!loaded) {
            this.LOGGER.error(this.getClass().getSimpleName() + ": No provider could load " + info.base() + " with NameInfo: " + String.valueOf(info));
            if (this.pasManager != null) {
                this.getDataManager().invalidateData(info);
            }
        }
    }

    private boolean tryLoadFromProviders(String literal, NameInfo info) {
        return this.tryLoad(this.providers.get(literal), info);
    }

    private boolean tryLoad(List<PrioritizedProvider> providerList, NameInfo info) {
        if (providerList == null || providerList.isEmpty()) {
            return false;
        }
        for (PrioritizedProvider prioritized : providerList) {
            try {
                this.LOGGER.info("Trying to download from {}", (Object)prioritized.provider.getClass().getSimpleName());
                this.pendingList.add(this.getOutputString(info));
                prioritized.provider().load(info, this.pendingList::remove);
                return true;
            }
            catch (Exception e) {
                this.LOGGER.error("Provider {} failed to load {}: {}", new Object[]{prioritized.provider().getClass().getSimpleName(), this.getOutputString(info), e.getMessage()});
            }
        }
        return false;
    }

    protected abstract String getOutputString(NameInfo var1);

    protected abstract void prepareProviders();

    protected abstract String getProvider(NameInfo var1);

    protected abstract String getName();

    protected abstract String getDefaultLiteral();

    protected abstract String getExcludeLiterals();

    protected abstract DataRepository<T> getDataManager();

    protected abstract boolean registerAsExistingProvider();

    private record PrioritizedProvider(TextureProvider provider, int priority) {
    }
}

