package com.danrus.mixin;

import com.danrus.PlayerArmorStands;
import com.danrus.render.ASCapeFeatureRenderer;
import com.danrus.render.PlayerArmorStandModel;
import com.danrus.utils.PASModelData;
import net.minecraft.class_2960;
import net.minecraft.class_5602;
import net.minecraft.class_5617;
import net.minecraft.class_877;
import net.minecraft.class_922;
import net.minecraft.class_9998;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_877.class)
public class ArmorStandEntityRendererMixin {

    //TODO на 1.21.2+ не работает babyModel

    //? if >=1.21.2 {

    @Inject(
            method = "<init>",
            at = @At("RETURN")
    )
    private void init(class_5617.class_5618 context, CallbackInfo ci){
        PlayerArmorStandModel model = new PlayerArmorStandModel(context.method_32167(class_5602.field_27586));
        PlayerArmorStandModel smalModel = new PlayerArmorStandModel(context.method_32167(class_5602.field_53014));
        PlayerArmorStands.model = model;
        PlayerArmorStands.smallModel = smalModel;
        class_877 renderer = (class_877) (Object) this;
        renderer.method_4046(new ASCapeFeatureRenderer(renderer));
        ((class_922)renderer).field_4737 = model;
    }

    @Inject(
        method = "getTexture(Lnet/minecraft/client/render/entity/state/ArmorStandEntityRenderState;)Lnet/minecraft/util/Identifier;",
        at = @At("RETURN"),
        cancellable = true
    )
    private void getTextureMixin(class_9998 armorStandEntityRenderState, CallbackInfoReturnable<class_2960> cir) {
        if (armorStandEntityRenderState.field_53464 == null) {
            return;
        }
        cir.setReturnValue(PASModelData.getByName(armorStandEntityRenderState.field_53464.getString()).texture);
    }
    //?} else {
    /*@Inject(
            method = "<init>",
            at = @At("RETURN")
    )
    private void init(EntityRendererFactory.Context context, CallbackInfo ci){
        PlayerArmorStandModel model = new PlayerArmorStandModel(context.getPart(EntityModelLayers.ARMOR_STAND));
        ArmorStandEntityRenderer renderer = (ArmorStandEntityRenderer) (Object) this;
        renderer.addFeature(new ASCapeFeatureRenderer(renderer));
        renderer.model = model;
    }

    @Inject(
            method = "getTexture(Lnet/minecraft/entity/decoration/ArmorStandEntity;)Lnet/minecraft/util/Identifier;",
            at = @At("RETURN"),
            cancellable = true
    )
    private void getTextureMixin(ArmorStandEntity armorStandEntity, CallbackInfoReturnable<Identifier> cir){
        if (armorStandEntity.getCustomName() == null) {
            return;
        }
        cir.setReturnValue(PASModelData.getByName(armorStandEntity.getCustomName().getString()).texture);
    }
    *///?}
}
