/*
 * Decompiled with CFR 0.152.
 */
package net.juniorwmg.opensmashbats.objects.tool;

import com.google.common.collect.Multimap;
import net.juniorwmg.opensmashbats.Main;
import net.juniorwmg.opensmashbats.config.ConfigManager;
import net.juniorwmg.opensmashbats.init.ItemInit;
import net.juniorwmg.opensmashbats.objects.tool.EnumMaterial;
import net.juniorwmg.opensmashbats.util.delayedEvents.DelayedEventManager;
import net.juniorwmg.opensmashbats.util.interfaces.IDelayedEvent;
import net.juniorwmg.opensmashbats.util.interfaces.IHasModel;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityParrot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;

public class SmashBatTool
extends ItemSword
implements IHasModel {
    private final EnumMaterial enumMaterial;
    private final float weaponDamage;

    public SmashBatTool(String name, EnumMaterial enumMaterial) {
        super(enumMaterial.getMaterial());
        this.enumMaterial = enumMaterial;
        this.weaponDamage = 2.0f + (float)enumMaterial.getAttackDamage();
        this.func_77655_b(name);
        this.setRegistryName(name);
        this.func_77625_d(1);
        this.func_77637_a(CreativeTabs.field_78037_j);
        ItemInit.ITEMS.add((Item)this);
    }

    public String getDelayedEventType() {
        return this.enumMaterial.getDelayedEventType();
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.removeAll((Object)SharedMonsterAttributes.field_111264_e.func_111108_a());
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.weaponDamage, 0));
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Knockback modifier", (double)this.enumMaterial.getGeneralForce(), 0));
        }
        return multimap;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (!attacker.field_70170_p.field_72995_K) {
            boolean targetCanFly;
            boolean allowFlyRide = ConfigManager.allowRidingFlyingMobs;
            boolean bl = targetCanFly = target instanceof EntityFlying || target instanceof EntityBat || target instanceof EntityBlaze || target instanceof EntityParrot;
            if (this.enumMaterial == EnumMaterial.RIDING) {
                if (targetCanFly && !allowFlyRide) {
                    return false;
                }
                if (target.func_184187_bx() != null) {
                    target.func_184210_p();
                } else {
                    attacker.func_184205_a((Entity)target, true);
                }
            } else if (this.enumMaterial == EnumMaterial.BLAST) {
                attacker.field_70170_p.func_72876_a((Entity)attacker, attacker.field_70165_t, attacker.field_70163_u, attacker.field_70161_v, 2.0f, false);
            }
            String delayedEventType = this.getDelayedEventType();
            if (delayedEventType != null) {
                boolean isCritical = this.isCriticalHit(attacker);
                if ("creeper".equals(delayedEventType) && !targetCanFly) {
                    target.func_184185_a(SoundEvents.field_187572_ar, 1.0f, 0.5f);
                }
                double yawRadians = (double)attacker.field_70177_z * Math.PI / 180.0;
                double vecX = -Math.sin(yawRadians) * (double)this.enumMaterial.getGeneralForce() * 0.5;
                double vecY = this.enumMaterial.getUpwardsForce() * this.enumMaterial.getGeneralForce() * (isCritical ? 1.5f : 1.0f);
                double vecZ = Math.cos(yawRadians) * (double)this.enumMaterial.getGeneralForce() * 0.5;
                IDelayedEvent.SmashEntry smashEntry = new IDelayedEvent.SmashEntry(target.func_145782_y(), vecX, vecY, vecZ, delayedEventType, attacker.func_145782_y());
                DelayedEventManager.addDelayedEvent(target.func_145782_y(), smashEntry, delayedEventType);
            }
            this.applyCustomKnockback(target, attacker);
        }
        boolean result = super.func_77644_a(stack, target, attacker);
        stack.func_77972_a(this.enumMaterial.getDurabilityCost() - 1, attacker);
        return result;
    }

    private void applyCustomKnockback(EntityLivingBase target, EntityLivingBase attacker) {
        boolean isCritical = this.isCriticalHit(attacker);
        float bashPower = this.enumMaterial.getGeneralForce();
        float bashUpRatio = this.enumMaterial.getUpwardsForce();
        float horizontalForce = bashPower * 0.5f;
        float verticalForce = bashUpRatio * bashPower;
        if (isCritical) {
            verticalForce *= 1.5f;
        }
        double yawRadians = (double)attacker.field_70177_z * Math.PI / 180.0;
        double vecX = -Math.sin(yawRadians) * (double)horizontalForce;
        double vecZ = Math.cos(yawRadians) * (double)horizontalForce;
        target.func_70024_g(vecX, (double)verticalForce, vecZ);
        target.field_70133_I = true;
        this.playHitSound(attacker, isCritical);
        if (isCritical && attacker instanceof EntityPlayer) {
            ((EntityPlayer)attacker).func_71009_b((Entity)target);
        }
    }

    private boolean isCriticalHit(EntityLivingBase attacker) {
        return attacker.field_70143_R > 0.0f && !attacker.field_70122_E && !attacker.func_70617_f_() && !attacker.func_70090_H() && attacker.func_184187_bx() == null && !attacker.func_70093_af();
    }

    private void playHitSound(EntityLivingBase attacker, boolean isCritical) {
        SoundEvent customSound;
        String soundName = this.enumMaterial.getHitSound();
        SoundEvent sound = SoundEvents.field_187727_dV;
        if (soundName != null && (customSound = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation(soundName))) != null) {
            sound = customSound;
        }
        attacker.field_70170_p.func_184148_a(null, attacker.field_70165_t, attacker.field_70163_u, attacker.field_70161_v, sound, attacker.func_184176_by(), isCritical ? 1.0f : 0.75f, 0.9f + attacker.field_70170_p.field_73012_v.nextFloat() * 0.2f);
    }

    @Override
    public void registerModels() {
        Main.proxy.registerModel((Item)this, 0, "inventory");
    }

    public EnumMaterial getEnumMaterial() {
        return this.enumMaterial;
    }

    public float getWeaponDamage() {
        return this.weaponDamage;
    }
}

