/*
 * Decompiled with CFR 0.152.
 */
package net.juniorwmg.opensmashbats.util.delayedEvents;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.juniorwmg.opensmashbats.util.delayedEvents.DelayedEventCreeper;
import net.juniorwmg.opensmashbats.util.delayedEvents.DelayedEventThunder;
import net.juniorwmg.opensmashbats.util.interfaces.IDelayedEvent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityParrot;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class DelayedEventManager {
    private static final Map<Integer, EventEntry> eventEntryMap = new HashMap<Integer, EventEntry>();
    private static final Map<String, IDelayedEvent> delayedEvents = new HashMap<String, IDelayedEvent>();

    public static void addDelayedEvent(int entityId, IDelayedEvent.SmashEntry smashEntry, String eventType) {
        IDelayedEvent event = delayedEvents.get(eventType);
        if (event != null) {
            eventEntryMap.put(entityId, new EventEntry(smashEntry, event));
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.world.field_72995_K) {
            return;
        }
        World world = event.world;
        Iterator<Map.Entry<Integer, EventEntry>> iterator = eventEntryMap.entrySet().iterator();
        while (iterator.hasNext()) {
            boolean isFlyingType;
            Map.Entry<Integer, EventEntry> entry = iterator.next();
            EventEntry eventEntry = entry.getValue();
            Entity entity = world.func_73045_a(entry.getKey().intValue());
            if (entity == null || entity.field_70128_L) {
                iterator.remove();
                continue;
            }
            boolean bl = isFlyingType = entity instanceof EntityFlying || entity instanceof EntityBat || entity instanceof EntityBlaze || entity instanceof EntityParrot;
            if (isFlyingType) {
                if (eventEntry.ticksAirborne > 10 && Math.abs(entity.field_70181_x) < 0.1) {
                    eventEntry.delayedEvent.onEvent(eventEntry.smashEntry, entity);
                    iterator.remove();
                    continue;
                }
                ++eventEntry.ticksAirborne;
                continue;
            }
            if (!eventEntry.smashEntry.wasAirborne && entity.field_70181_x > 0.1) {
                eventEntry.smashEntry.wasAirborne = true;
                eventEntry.smashEntry.lastMotionY = entity.field_70181_x;
            } else if (eventEntry.smashEntry.wasAirborne) {
                if (entity.field_70181_x < eventEntry.smashEntry.lastMotionY && entity.field_70181_x < 0.0) {
                    eventEntry.delayedEvent.onEvent(eventEntry.smashEntry, entity);
                    iterator.remove();
                    continue;
                }
                eventEntry.smashEntry.lastMotionY = entity.field_70181_x;
            }
            ++eventEntry.ticksAirborne;
            if (eventEntry.ticksAirborne <= 200) continue;
            iterator.remove();
        }
    }

    static {
        delayedEvents.put("creeper", new DelayedEventCreeper());
        delayedEvents.put("thunder", new DelayedEventThunder());
    }

    private static class EventEntry {
        public final IDelayedEvent.SmashEntry smashEntry;
        public final IDelayedEvent delayedEvent;
        public int ticksAirborne;

        public EventEntry(IDelayedEvent.SmashEntry smashEntry, IDelayedEvent delayedEvent) {
            this.smashEntry = smashEntry;
            this.delayedEvent = delayedEvent;
            this.ticksAirborne = 0;
        }
    }
}

