/*
 * Decompiled with CFR 0.152.
 */
package com.reggarf.mods.create_better_motors.content.motors.blocksentity;

import com.mrh0.createaddition.blocks.electric_motor.ElectricMotorBlock;
import com.mrh0.createaddition.blocks.electric_motor.ElectricMotorBlockEntity;
import com.mrh0.createaddition.blocks.tesla_coil.TeslaCoilBlock;
import com.mrh0.createaddition.energy.InternalEnergyStorage;
import com.mrh0.createaddition.sound.CASoundScapes;
import com.mrh0.createaddition.util.Util;
import com.reggarf.mods.create_better_motors.config.CommonConfig;
import com.reggarf.mods.create_better_motors.registry.CBMBlockEntityTypes;
import com.reggarf.mods.create_better_motors.registry.CBMBlocks;
import com.reggarf.mods.create_better_motors.util.StringFormattingTool;
import com.simibubi.create.content.kinetics.motor.KineticScrollValueBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class NioticMotorBlockEntity
extends ElectricMotorBlockEntity {
    protected float motorSpeed;
    protected ScrollValueBehaviour generatedSpeed;
    protected final InternalEnergyStorage energy;
    private final IEnergyStorage capability;
    private boolean cc_update_rpm = false;
    private float cc_new_rpm = 32.0f;
    private boolean active = false;
    boolean first = true;

    public NioticMotorBlockEntity(BlockEntityType<? extends ElectricMotorBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.energy = new InternalEnergyStorage(((Integer)CommonConfig.NIOTIC_MOTOR.CAPACITY.get()).intValue(), ((Integer)CommonConfig.NIOTIC_MOTOR.MAX_INPUT.get()).intValue(), 0);
        this.capability = this.energy;
        this.setLazyTickRate(20);
    }

    public static void registerCapabilitiesniotic(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)CBMBlockEntityTypes.NIOTIC_MOTOR.get(), (be, context) -> be.capability);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        CenteredSideValueBoxTransform slot = new CenteredSideValueBoxTransform((motor, side) -> motor.getValue((Property)ElectricMotorBlock.FACING) == side.getOpposite());
        this.generatedSpeed = new KineticScrollValueBehaviour((Component)CreateLang.translateDirect((String)"generic.speed", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)slot);
        this.generatedSpeed.between(-((Integer)CommonConfig.NIOTIC_MOTOR.RPM_RANGE.get()).intValue(), ((Integer)CommonConfig.NIOTIC_MOTOR.RPM_RANGE.get()).intValue());
        this.generatedSpeed.value = 16;
        this.generatedSpeed.withCallback(i -> this.updateGeneratedRotation((int)i));
        behaviours.add((BlockEntityBehaviour)this.generatedSpeed);
    }

    public float calculateAddedStressCapacity() {
        float capacity;
        this.lastCapacityProvided = capacity = (float)((Integer)CommonConfig.NIOTIC_MOTOR.MAX_STRESS.get()).intValue() / 256.0f;
        return capacity;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        CreateLang.translate((String)"tooltip.create_better_motors.energy_stored", (Object[])new Object[0]).style(ChatFormatting.WHITE).forGoggles(tooltip);
        CreateLang.translate((String)"tooltip.create_better_motors.energy_storage", (Object[])new Object[]{StringFormattingTool.formatLong(this.energy.getEnergyStored()), StringFormattingTool.formatLong(this.energy.getMaxEnergyStored())}).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
        CreateLang.translate((String)"tooltip.create_better_motors.using", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        CreateLang.translate((String)"tooltip.create_better_motors.energy_per_tick", (Object[])new Object[]{" " + Util.format((int)NioticMotorBlockEntity.getEnergyConsumptionRate(this.generatedSpeed.getValue()))}).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        return true;
    }

    public void updateGeneratedRotation(int rpm) {
        this.motorSpeed = rpm;
        super.updateGeneratedRotation();
    }

    public void initialize() {
        super.initialize();
        if (!this.hasSource() || this.getGeneratedSpeed() > this.getTheoreticalSpeed()) {
            this.updateGeneratedRotation();
        }
    }

    public float getGeneratedSpeed() {
        if (!CBMBlocks.NIOTIC_MOTOR.has(this.getBlockState())) {
            return 0.0f;
        }
        return NioticMotorBlockEntity.convertToDirection((float)(this.active ? this.motorSpeed : 0.0f), (Direction)((Direction)this.getBlockState().getValue((Property)ElectricMotorBlock.FACING)));
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        this.energy.read(tag);
        this.active = tag.getBoolean("active");
    }

    public void writeSafe(CompoundTag tag, HolderLookup.Provider registries) {
        super.writeSafe(tag, registries);
        this.energy.write(tag);
        tag.putBoolean("active", this.active);
    }

    public void lazyTick() {
        super.lazyTick();
    }

    public static int getEnergyConsumptionRate(float rpm) {
        return Math.abs(rpm) > 0.0f ? (int)Math.max((double)((Integer)CommonConfig.NIOTIC_MOTOR.FE_RPM.get()).intValue() * ((double)Math.abs(rpm) / 256.0), (double)((Integer)CommonConfig.NIOTIC_MOTOR.MIN_CONSUMPTION.get()).intValue()) : 0;
    }

    public void tick() {
        super.tick();
        if (this.first) {
            this.motorSpeed = this.generatedSpeed.getValue();
            this.updateGeneratedRotation();
            this.first = false;
        }
        if (this.cc_update_rpm) {
            this.generatedSpeed.setValue(Math.round(this.cc_new_rpm));
            this.motorSpeed = this.cc_new_rpm;
            this.cc_update_rpm = false;
            this.updateGeneratedRotation();
        }
        if (this.level.isClientSide()) {
            return;
        }
        int con = NioticMotorBlockEntity.getEnergyConsumptionRate(this.motorSpeed);
        if (!this.active) {
            if (this.energy.getEnergyStored() > con * 2 && !((Boolean)this.getBlockState().getValue((Property)ElectricMotorBlock.POWERED)).booleanValue()) {
                this.active = true;
                this.updateGeneratedRotation();
            }
        } else {
            int ext = this.energy.internalConsumeEnergy(con);
            if (ext < con || ((Boolean)this.getBlockState().getValue((Property)ElectricMotorBlock.POWERED)).booleanValue()) {
                this.active = false;
                this.updateGeneratedRotation();
            }
        }
    }

    public void tickAudio() {
        super.tickAudio();
        if (!this.active) {
            return;
        }
        if (((Boolean)CommonConfig.NIOTIC_MOTOR.AUDIO_ENABLED.get()).booleanValue()) {
            CASoundScapes.play((CASoundScapes.AmbienceGroup)CASoundScapes.AmbienceGroup.DYNAMO, (BlockPos)this.worldPosition, (float)1.0f);
        }
    }

    public boolean setRPM(float rpm) {
        this.cc_new_rpm = rpm = Math.max(Math.min(rpm, (float)((Integer)CommonConfig.NIOTIC_MOTOR.RPM_RANGE.get()).intValue()), (float)(-((Integer)CommonConfig.NIOTIC_MOTOR.RPM_RANGE.get()).intValue()));
        this.cc_update_rpm = true;
        return true;
    }

    public float getRPM() {
        return this.motorSpeed;
    }

    public int getGeneratedStress() {
        return (int)this.calculateAddedStressCapacity();
    }

    public int getEnergyConsumption() {
        return NioticMotorBlockEntity.getEnergyConsumptionRate(this.motorSpeed);
    }

    public boolean isPoweredState() {
        return (Boolean)this.getBlockState().getValue((Property)TeslaCoilBlock.POWERED);
    }
}

