/*
 * Decompiled with CFR 0.152.
 */
package com.reggarf.mods.create_better_motors.content.alternator.blocks;

import com.mrh0.createaddition.shapes.CAShapes;
import com.reggarf.mods.create_better_motors.config.CommonConfig;
import com.reggarf.mods.create_better_motors.content.alternator.blocksentity.AndesiteAlternatorBlockEntity;
import com.reggarf.mods.create_better_motors.content.alternator.blocksentity.CopperAlternatorBlockEntity;
import com.reggarf.mods.create_better_motors.registry.CBMBlockEntityTypes;
import com.reggarf.mods.create_better_motors.util.StringFormattingTool;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.createmod.catnip.math.VoxelShaper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CopperAlternatorBlock
extends DirectionalKineticBlock
implements IBE<CopperAlternatorBlockEntity>,
IRotate {
    public static final VoxelShaper ALTERNATOR_SHAPE = CAShapes.shape((double)0.0, (double)1.5, (double)0.0, (double)16.0, (double)12.5, (double)16.0).forDirectional();

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return ALTERNATOR_SHAPE.get((Direction)state.getValue((Property)FACING));
    }

    public CopperAlternatorBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockEntityType<? extends CopperAlternatorBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CBMBlockEntityTypes.COPPER_ALTERNATOR.get();
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return CBMBlockEntityTypes.COPPER_ALTERNATOR.create(pos, state);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)CreateLang.translate((String)"create_better_motors.large_connector.tooltip.heavy", (Object[])new Object[0]).style(ChatFormatting.AQUA).component());
        } else {
            tooltip.add((Component)CreateLang.translate((String)"tooltip.create_better_motors.generates", (Object[])new Object[0]).style(ChatFormatting.GRAY).component());
            tooltip.add((Component)CreateLang.text((String)" ").add(CreateLang.number((double)((double)((Integer)CommonConfig.COPPER_ALTERNATOR_FE_RPM.get()).intValue() * (Double)CommonConfig.COPPER_ALTERNATOR_EFFICIENCY.get())).text(" ").translate("tooltip.create_better_motors.energy_per_tick", new Object[0]).style(ChatFormatting.AQUA)).component());
            tooltip.add((Component)CreateLang.translate((String)"tooltip.create_better_motors.stores", (Object[])new Object[0]).style(ChatFormatting.GRAY).component());
            tooltip.add((Component)CreateLang.text((String)" ").translate("tooltip.create_better_motors.energy", new Object[]{StringFormattingTool.formatLong(((Integer)CommonConfig.COPPER_ALTERNATOR_CAPACITY.get()).intValue())}).style(ChatFormatting.AQUA).component());
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction preferred = this.getPreferredFacing(context);
        if (context.getPlayer() != null && context.getPlayer().isShiftKeyDown() || preferred == null) {
            return super.getStateForPlacement(context);
        }
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)preferred);
    }

    public boolean hideStressImpact() {
        return false;
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face == state.getValue((Property)FACING);
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.getValue((Property)FACING)).getAxis();
    }

    public Class<CopperAlternatorBlockEntity> getBlockEntityClass() {
        return CopperAlternatorBlockEntity.class;
    }

    public IRotate.SpeedLevel getMinimumRequiredSpeedLevel() {
        return IRotate.SpeedLevel.MEDIUM;
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockEntity tileentity;
        BlockEntity blockEntity = tileentity = state.hasBlockEntity() ? worldIn.getBlockEntity(pos) : null;
        if (tileentity != null && tileentity instanceof AndesiteAlternatorBlockEntity) {
            ((AndesiteAlternatorBlockEntity)tileentity).updateCache();
        }
    }
}

