/*
 * Decompiled with CFR 0.152.
 */
package com.reggarf.mods.create_better_motors.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod.EventBusSubscriber(modid="create_better_motors", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CommonConfig {
    private static final ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
    public static ForgeConfigSpec COMMON_CONFIG;
    public static final String CATAGORY_MESSAGES = "Messages";
    public static final String CATAGORY_WIRES = "wires";
    public static final String CATAGORY_ACCUMULATOR = "accumulator";
    public static final String CATAGORY_STARTER_MOTOR = "starter_motor";
    public static final String CATAGORY_BASIC_MOTOR = "basic_motor";
    public static final String CATAGORY_HARDENED_MOTOR = "hardened_motor";
    public static final String CATAGORY_BLAZING_MOTOR = "blazing_motor";
    public static final String CATAGORY_NIOTIC_MOTOR = "niotic_motor";
    public static final String CATAGORY_SPIRITED_MOTOR = "spirited_motor";
    public static final String CATAGORY_NITRO_MOTOR = "nitro_motor";
    public static final String CATAGORY_ANDESITE_ALTERNATOR = "andesite_alternator";
    public static final String CATAGORY_COPPER_ALTERNATOR = "copper_alternator";
    public static final String CATAGORY_BRASS_ALTERNATOR = "brass_alternator";
    public static ForgeConfigSpec.BooleanValue MESSAGES_ENABLED;
    public static ForgeConfigSpec.IntValue HEAVY_CONNECTOR_MAX_INPUT;
    public static ForgeConfigSpec.IntValue HEAVY_CONNECTOR_MAX_OUTPUT;
    public static ForgeConfigSpec.IntValue HEAVY_CONNECTOR_MAX_LENGTH;
    public static ForgeConfigSpec.IntValue ACCUMULATOR_MAX_INPUT;
    public static ForgeConfigSpec.IntValue ACCUMULATOR_MAX_OUTPUT;
    public static MotorConfig STARTER_MOTOR;
    public static MotorConfig BASIC_MOTOR;
    public static MotorConfig HARDENED_MOTOR;
    public static MotorConfig BLAZING_MOTOR;
    public static MotorConfig NIOTIC_MOTOR;
    public static MotorConfig SPIRITED_MOTOR;
    public static MotorConfig NITRO_MOTOR;
    public static AlternatorConfig ANDESITE_ALTERNATOR;
    public static AlternatorConfig COPPER_ALTERNATOR;
    public static AlternatorConfig BRASS_ALTERNATOR;

    private static MotorConfig motor(ForgeConfigSpec.Builder builder, String category, int rpmRange, int minConsumption, int maxInput, int capacity, int feRpm, int maxStress) {
        builder.comment(category).push(category);
        MotorConfig config = new MotorConfig();
        config.RPM_RANGE = builder.comment("Motor RPM range").defineInRange("rpm_range", rpmRange, 1, Integer.MAX_VALUE);
        config.MIN_CONSUMPTION = builder.comment("Minimum FE/t consumption").defineInRange("min_consumption", minConsumption, 0, Integer.MAX_VALUE);
        config.MAX_INPUT = builder.comment("Max FE/t input").defineInRange("max_input", maxInput, 0, Integer.MAX_VALUE);
        config.CAPACITY = builder.comment("Internal FE capacity").defineInRange("capacity", capacity, 0, Integer.MAX_VALUE);
        config.FE_RPM = builder.comment("FE/t at 256 RPM").defineInRange("fe_at_max_rpm", feRpm, 0, Integer.MAX_VALUE);
        config.MAX_STRESS = builder.comment("Max stress in SU at 256 RPM").defineInRange("max_stress", maxStress, 0, Integer.MAX_VALUE);
        config.AUDIO_ENABLED = builder.comment("Enable motor audio").define("audio_enabled", true);
        builder.pop();
        return config;
    }

    private static AlternatorConfig alternator(ForgeConfigSpec.Builder builder, String category, int maxOutput, int capacity, double efficiency, int feRpm, int maxStress) {
        builder.comment(category).push(category);
        AlternatorConfig config = new AlternatorConfig();
        config.MAX_OUTPUT = builder.comment("Alternator max FE/t output").defineInRange("max_output", maxOutput, 0, Integer.MAX_VALUE);
        config.CAPACITY = builder.comment("Alternator FE capacity").defineInRange("capacity", capacity, 0, Integer.MAX_VALUE);
        config.EFFICIENCY = builder.comment("Efficiency (0.0 - 1.0)").defineInRange("efficiency", efficiency, 0.01, 1.0);
        config.FE_RPM = builder.comment("FE/t at 256 RPM").defineInRange("fe_at_max_rpm", feRpm, 0, Integer.MAX_VALUE);
        config.MAX_STRESS = builder.comment("Max stress at 256 RPM").defineInRange("max_stress", maxStress, 0, Integer.MAX_VALUE);
        config.AUDIO_ENABLED = builder.comment("Enable alternator audio").define("audio_enabled", true);
        builder.pop();
        return config;
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading event) {
        CommonConfig.loadConfig(COMMON_CONFIG, FMLPaths.CONFIGDIR.get().resolve("create_better_motors-common.toml"));
    }

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        spec.correct((CommentedConfig)configData);
    }

    static {
        builder.comment("General configuration for Create: Better Motors");
        builder.comment(CATAGORY_MESSAGES).push(CATAGORY_MESSAGES);
        MESSAGES_ENABLED = builder.comment("Enable or disable update messages.").define("messages_enabled", true);
        builder.pop();
        builder.comment("Accumulator").push(CATAGORY_ACCUMULATOR);
        ACCUMULATOR_MAX_INPUT = builder.comment("Max input in FE/t").defineInRange("max_input", 800000, 0, Integer.MAX_VALUE);
        ACCUMULATOR_MAX_OUTPUT = builder.comment("Max output in FE/t").defineInRange("max_output", 800000, 0, Integer.MAX_VALUE);
        builder.pop();
        builder.comment("Wires").push(CATAGORY_WIRES);
        HEAVY_CONNECTOR_MAX_INPUT = builder.comment("Heavy Connector max input in FE/t").defineInRange("max_input", 90000, 0, Integer.MAX_VALUE);
        HEAVY_CONNECTOR_MAX_OUTPUT = builder.comment("Heavy Connector max output in FE/t").defineInRange("max_output", 90000, 0, Integer.MAX_VALUE);
        HEAVY_CONNECTOR_MAX_LENGTH = builder.comment("Heavy Connector max length in blocks").defineInRange("max_length", 48, 0, 256);
        builder.pop();
        STARTER_MOTOR = CommonConfig.motor(builder, CATAGORY_STARTER_MOTOR, 256, 8, 80000, 100000, 960, 35768);
        BASIC_MOTOR = CommonConfig.motor(builder, CATAGORY_BASIC_MOTOR, 256, 8, 80000, 100000, 1920, 75768);
        HARDENED_MOTOR = CommonConfig.motor(builder, CATAGORY_HARDENED_MOTOR, 256, 8, 80000, 100000, 3840, 161536);
        BLAZING_MOTOR = CommonConfig.motor(builder, CATAGORY_BLAZING_MOTOR, 256, 8, 80000, 500000, 7680, 253072);
        NIOTIC_MOTOR = CommonConfig.motor(builder, CATAGORY_NIOTIC_MOTOR, 256, 8, 80000, 600000, 19360, 710144);
        SPIRITED_MOTOR = CommonConfig.motor(builder, CATAGORY_SPIRITED_MOTOR, 256, 8, 80000, 700000, 41720, 1298288);
        NITRO_MOTOR = CommonConfig.motor(builder, CATAGORY_NITRO_MOTOR, 256, 8, 85000, 800000, 72440, 2499576);
        ANDESITE_ALTERNATOR = CommonConfig.alternator(builder, CATAGORY_ANDESITE_ALTERNATOR, 5000, 5000, 0.85, 1260, 35768);
        COPPER_ALTERNATOR = CommonConfig.alternator(builder, CATAGORY_COPPER_ALTERNATOR, 5000, 5000, 0.9, 2400, 75384);
        BRASS_ALTERNATOR = CommonConfig.alternator(builder, CATAGORY_BRASS_ALTERNATOR, 10000, 10000, 0.9, 4240, 159708);
        COMMON_CONFIG = builder.build();
    }

    public static class MotorConfig {
        public ForgeConfigSpec.IntValue RPM_RANGE;
        public ForgeConfigSpec.IntValue MIN_CONSUMPTION;
        public ForgeConfigSpec.IntValue MAX_INPUT;
        public ForgeConfigSpec.IntValue CAPACITY;
        public ForgeConfigSpec.IntValue FE_RPM;
        public ForgeConfigSpec.IntValue MAX_STRESS;
        public ForgeConfigSpec.BooleanValue AUDIO_ENABLED;
    }

    public static class AlternatorConfig {
        public ForgeConfigSpec.IntValue MAX_OUTPUT;
        public ForgeConfigSpec.IntValue CAPACITY;
        public ForgeConfigSpec.DoubleValue EFFICIENCY;
        public ForgeConfigSpec.IntValue FE_RPM;
        public ForgeConfigSpec.IntValue MAX_STRESS;
        public ForgeConfigSpec.BooleanValue AUDIO_ENABLED;
    }
}

