/*
 * Decompiled with CFR 0.152.
 */
package betteradvancements.neoforge.config;

import betteradvancements.common.advancements.BetterDisplayInfo;
import betteradvancements.common.gui.BetterAdvancementTab;
import betteradvancements.common.gui.BetterAdvancementTabType;
import betteradvancements.common.gui.BetterAdvancementsScreen;
import betteradvancements.common.gui.BetterAdvancementsScreenButton;
import betteradvancements.common.util.ColorHelper;
import betteradvancements.common.util.CriteriaDetail;
import betteradvancements.common.util.CriterionGrid;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ConfigValues {
    public static ModConfigSpec.ConfigValue<String> defaultUncompletedIconColor;
    public static ModConfigSpec.ConfigValue<String> defaultUncompletedTitleColor;
    public static ModConfigSpec.ConfigValue<String> defaultCompletedIconColor;
    public static ModConfigSpec.ConfigValue<String> defaultCompletedTitleColor;
    public static ModConfigSpec.BooleanValue doFade;
    public static ModConfigSpec.BooleanValue showDebugCoordinates;
    public static ModConfigSpec.BooleanValue orderTabsAlphabetically;
    public static ModConfigSpec.IntValue uiScaling;
    public static ModConfigSpec.DoubleValue defaultZoom;
    public static ModConfigSpec.ConfigValue<String> detailLevel;
    public static ModConfigSpec.BooleanValue requiresShift;
    public static ModConfigSpec.BooleanValue addToInventory;
    public static ModConfigSpec.BooleanValue defaultDrawDirectLines;
    public static ModConfigSpec.BooleanValue defaultHideLines;
    public static ModConfigSpec.ConfigValue<String> defaultCompletedLineColor;
    public static ModConfigSpec.ConfigValue<String> defaultUncompletedLineColor;
    public static ModConfigSpec.BooleanValue onlyUseAboveAdvancementTabs;

    public static ModConfigSpec build() {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        defaultUncompletedIconColor = builder.define("defaultUncompletedIconColor", (Object)"#FFFFFF");
        defaultUncompletedTitleColor = builder.define("defaultUncompletedTitleColor", (Object)"#0489C1");
        defaultCompletedIconColor = builder.define("defaultCompletedIconColor", (Object)"#DBA213");
        defaultCompletedTitleColor = builder.define("defaultCompletedTitleColor", (Object)"#DBA213");
        doFade = builder.define("doAdvancementsBackgroundFade", true);
        showDebugCoordinates = builder.define("showDebugCoordinates", false);
        orderTabsAlphabetically = builder.define("orderTabsAlphabetically", false);
        uiScaling = builder.comment("Values below 50% might give odd results, use on own risk ;)").defineInRange("uiScaling", 100, 1, 100);
        defaultZoom = builder.comment("UI zoom steps are 0.1").defineInRange("defaultZoom", 1.0, (double)0.4f, 2.0);
        detailLevel = builder.comment(CriteriaDetail.comments()).defineInList("criteriaDetail", (Object)CriteriaDetail.DEFAULT.getName(), CriteriaDetail.names());
        requiresShift = builder.define("criteriaDetailRequiresShift", false);
        addToInventory = builder.define("addInventoryButton", false);
        defaultDrawDirectLines = builder.define("defaultDrawDirectLines", false);
        defaultHideLines = builder.define("defaultHideLines", false);
        defaultCompletedLineColor = builder.define("defaultCompletedLineColor", (Object)"#FFFFFF");
        defaultUncompletedLineColor = builder.define("defaultUncompletedLineColor", (Object)"#FFFFFF");
        onlyUseAboveAdvancementTabs = builder.define("onlyUseAboveAdvancementTabs", false);
        return builder.build();
    }

    public static void pushChanges() {
        BetterDisplayInfo.defaultUncompletedIconColor = ColorHelper.RGB((String)defaultUncompletedIconColor.get());
        BetterDisplayInfo.defaultUncompletedTitleColor = ColorHelper.RGB((String)defaultUncompletedTitleColor.get());
        BetterDisplayInfo.defaultCompletedIconColor = ColorHelper.RGB((String)defaultCompletedIconColor.get());
        BetterDisplayInfo.defaultCompletedTitleColor = ColorHelper.RGB((String)defaultCompletedTitleColor.get());
        BetterAdvancementTab.doFade = (Boolean)doFade.get();
        BetterAdvancementsScreen.showDebugCoordinates = (Boolean)showDebugCoordinates.get();
        BetterAdvancementsScreen.orderTabsAlphabetically = (Boolean)orderTabsAlphabetically.get();
        BetterAdvancementsScreen.uiScaling = (Integer)uiScaling.get();
        BetterAdvancementsScreen.zoom = Math.round((Double)defaultZoom.get());
        CriterionGrid.detailLevel = CriteriaDetail.fromName((String)detailLevel.get());
        CriterionGrid.requiresShift = (Boolean)requiresShift.get();
        BetterAdvancementsScreenButton.addToInventory = (Boolean)addToInventory.get();
        BetterDisplayInfo.defaultDrawDirectLines = (Boolean)defaultDrawDirectLines.get();
        BetterDisplayInfo.defaultHideLines = (Boolean)defaultHideLines.get();
        BetterDisplayInfo.defaultCompletedLineColor = ColorHelper.RGB((String)defaultCompletedLineColor.get());
        BetterDisplayInfo.defaultUncompletedLineColor = ColorHelper.RGB((String)defaultUncompletedLineColor.get());
        BetterAdvancementTabType.onlyUseAbove = (Boolean)onlyUseAboveAdvancementTabs.get();
    }
}

