/*
 * Decompiled with CFR 0.152.
 */
package betteradvancements.common.gui;

import betteradvancements.common.gui.BetterAdvancementTab;
import betteradvancements.common.gui.BetterAdvancementTabType;
import betteradvancements.common.gui.BetterAdvancementWidget;
import betteradvancements.common.platform.Services;
import betteradvancements.common.reference.Resources;
import betteradvancements.common.util.RenderUtil;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.multiplayer.ClientAdvancements;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundSeenAdvancementsPacket;
import net.minecraft.util.FormattedCharSequence;

public class BetterAdvancementsScreen
extends Screen
implements ClientAdvancements.Listener {
    private static final Component VERY_SAD_LABEL = Component.translatable((String)"advancements.sad_label");
    private static final Component NO_ADVANCEMENTS_LABEL = Component.translatable((String)"advancements.empty");
    private static final Component TITLE = Component.translatable((String)"gui.advancements");
    private static final int WIDTH = 252;
    private static final int HEIGHT = 140;
    private static final int CORNER_SIZE = 30;
    private static final int SIDE = 30;
    private static final int TOP = 40;
    private static final int BOTTOM = 30;
    private static final int PADDING = 9;
    public static final float MIN_ZOOM = 0.4f;
    public static final float MAX_ZOOM = 1.6f;
    public static final float ZOOM_STEP = 0.1f;
    private final ClientAdvancements clientAdvancements;
    private final Map<AdvancementHolder, BetterAdvancementTab> tabs = Maps.newLinkedHashMap();
    private BetterAdvancementTab selectedTab;
    private static int tabPage;
    private static int maxPages;
    public static float zoom;
    private boolean isScrolling;
    protected int internalWidth;
    protected int internalHeight;
    public static int uiScaling;
    public static boolean showDebugCoordinates;
    public static boolean orderTabsAlphabetically;
    private BetterAdvancementWidget advConnectedToMouse = null;

    public BetterAdvancementsScreen(ClientAdvancements clientAdvancements) {
        super(GameNarrator.NO_TITLE);
        this.clientAdvancements = clientAdvancements;
    }

    protected void init() {
        this.internalHeight = this.height * uiScaling / 100;
        this.internalWidth = this.width * uiScaling / 100;
        this.tabs.clear();
        this.selectedTab = null;
        this.clientAdvancements.setListener((ClientAdvancements.Listener)this);
        if (this.selectedTab == null && !this.tabs.isEmpty()) {
            BetterAdvancementTab advancementTab = this.tabs.values().iterator().next();
            this.clientAdvancements.setSelectedTab(advancementTab.getRootNode().holder(), true);
        } else {
            this.clientAdvancements.setSelectedTab(this.selectedTab == null ? null : this.selectedTab.getRootNode().holder(), true);
        }
        int left = 30 + (this.width - this.internalWidth) / 2;
        int top = 40 + (this.height - this.internalHeight) / 2;
        int right = this.internalWidth - 30 + (this.width - this.internalWidth) / 2;
        int bottom = this.internalHeight - 30 + (this.height - this.internalHeight) / 2;
        int width = right - left;
        int height = bottom - top;
        int maxTabs = BetterAdvancementTabType.getMaxTabs(width, height);
        if (this.tabs.size() > maxTabs) {
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"<"), b -> {
                tabPage = Math.max(tabPage - 1, 0);
            }).pos(left, bottom + 4).size(20, 20).build());
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)">"), b -> {
                tabPage = Math.min(tabPage + 1, maxPages);
            }).pos(right - 20, bottom + 4).size(20, 20).build());
            maxPages = this.tabs.size() / maxTabs;
            tabPage = Math.min(tabPage, maxPages);
        }
    }

    public void onClose() {
        this.clientAdvancements.setListener(null);
        ClientPacketListener clientpacketlistener = this.minecraft.getConnection();
        if (clientpacketlistener != null) {
            clientpacketlistener.send((Packet)ServerboundSeenAdvancementsPacket.closedScreen());
        }
        super.onClose();
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean isDoubleClick) {
        if (event.modifiers() == 0) {
            int left = 30 + (this.width - this.internalWidth) / 2;
            int top = 40 + (this.height - this.internalHeight) / 2;
            int right = this.internalWidth - 30 + (this.width - this.internalWidth) / 2;
            int bottom = this.internalHeight - 30 + (this.height - this.internalHeight) / 2;
            int width = right - left;
            int height = bottom - top;
            int maxTabs = BetterAdvancementTabType.getMaxTabs(width, height);
            int skip = tabPage * maxTabs;
            for (BetterAdvancementTab tab : this.tabs.values().stream().skip(skip).limit(maxTabs).toList()) {
                if (!tab.isMouseOver(left, top, this.internalWidth - 60, this.internalHeight - top - 30, event.x(), event.y())) continue;
                this.clientAdvancements.setSelectedTab(tab.getRootNode().holder(), true);
                break;
            }
        }
        return super.mouseClicked(event, isDoubleClick);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.selectedTab != null) {
            if (this.minecraft.hasControlDown()) {
                zoom += scrollY > 0.0 ? 0.1f : -0.1f;
                zoom = Math.max(0.4f, Math.min(zoom, 1.6f));
            } else {
                this.selectedTab.scroll(scrollX * 16.0, scrollY * 16.0, this.width, this.height);
            }
            return true;
        }
        return false;
    }

    public boolean keyPressed(KeyEvent event) {
        if (this.minecraft.options.keyAdvancements.matches(event)) {
            this.minecraft.setScreen(null);
            this.minecraft.mouseHandler.grabMouse();
            return true;
        }
        return super.keyPressed(event);
    }

    public boolean mouseDragged(MouseButtonEvent event, double mouseDeltaX, double mouseDeltaY) {
        int left = 30 + (this.width - this.internalWidth) / 2;
        int top = 40 + (this.height - this.internalHeight) / 2;
        if (event.button() != 0) {
            this.isScrolling = false;
            return false;
        }
        if (!this.isScrolling) {
            if (this.advConnectedToMouse == null) {
                boolean inGui;
                boolean bl = inGui = event.x() < (double)(left + this.internalWidth - 60 - 9) && event.x() > (double)(left + 9) && event.y() < (double)(top + this.internalHeight - 40 + 1) && event.y() > (double)(top + 18);
                if (this.selectedTab != null && inGui) {
                    for (BetterAdvancementWidget betterAdvancementEntryScreen : this.selectedTab.widgets.values()) {
                        if (!betterAdvancementEntryScreen.isMouseOver(this.selectedTab.scrollX, this.selectedTab.scrollY, event.x() - (double)left - 9.0, event.y() - (double)top - 18.0, zoom) || !betterAdvancementEntryScreen.betterDisplayInfo.allowDragging()) continue;
                        this.advConnectedToMouse = betterAdvancementEntryScreen;
                        break;
                    }
                }
            } else {
                this.advConnectedToMouse.x = (int)Math.round((double)this.advConnectedToMouse.x + mouseDeltaX);
                this.advConnectedToMouse.y = (int)Math.round((double)this.advConnectedToMouse.y + mouseDeltaY);
            }
        } else {
            if (this.advConnectedToMouse != null) {
                Services.PLATFORM.getEventHelper().postAdvancementMovementEvent(this.advConnectedToMouse);
            }
            this.advConnectedToMouse = null;
        }
        if (this.advConnectedToMouse == null) {
            if (!this.isScrolling) {
                this.isScrolling = true;
            } else if (this.selectedTab != null) {
                this.selectedTab.scroll(mouseDeltaX, mouseDeltaY, this.internalWidth - 60 - 27, this.internalHeight - 40 - 30 - 27);
            }
        }
        return true;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int left = 30 + (this.width - this.internalWidth) / 2;
        int top = 40 + (this.height - this.internalHeight) / 2;
        int right = this.internalWidth - 30 + (this.width - this.internalWidth) / 2;
        int bottom = this.internalHeight - 30 + (this.height - this.internalHeight) / 2;
        int width = right - left;
        int height = bottom - top;
        int maxTabs = BetterAdvancementTabType.getMaxTabs(width, height);
        int skip = tabPage * maxTabs;
        if (maxPages != 0) {
            MutableComponent page = Component.literal((String)String.format("%d / %d", tabPage + 1, maxPages + 1));
            int textWidth = this.font.width((FormattedText)page);
            guiGraphics.drawString(this.font, page.getVisualOrderText(), left + (this.internalWidth - textWidth) / 2 - textWidth, bottom + 8, -1);
            super.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
        guiGraphics.nextStratum();
        this.renderInside(guiGraphics, mouseX, mouseY, left, top, right, bottom, maxTabs, skip);
        guiGraphics.nextStratum();
        this.renderWindow(guiGraphics, left, top, right, bottom, maxTabs, skip);
        if (this.advConnectedToMouse == null) {
            this.renderToolTips(guiGraphics, mouseX, mouseY, left, top, right, bottom, maxTabs, skip);
        }
        if (this.advConnectedToMouse != null) {
            for (BetterAdvancementWidget betterAdvancementEntryScreen : this.selectedTab.widgets.values()) {
                if (betterAdvancementEntryScreen == this.advConnectedToMouse) continue;
                int x1 = betterAdvancementEntryScreen.x + left + 9 + this.selectedTab.scrollX + 3;
                int x2 = this.advConnectedToMouse.x + left + 9 + this.selectedTab.scrollX + 3;
                int y1 = betterAdvancementEntryScreen.y + top + 18 + this.selectedTab.scrollY;
                int y2 = this.advConnectedToMouse.y + top + 18 + this.selectedTab.scrollY;
                int centerX1 = betterAdvancementEntryScreen.x + left + 9 + this.selectedTab.scrollX + 3 + 13;
                int centerX2 = this.advConnectedToMouse.x + left + 9 + this.selectedTab.scrollX + 3 + 13;
                int centerY1 = betterAdvancementEntryScreen.y + top + 18 + this.selectedTab.scrollY + 13;
                int centerY2 = this.advConnectedToMouse.y + top + 18 + this.selectedTab.scrollY + 13;
                double degrees = Math.toDegrees(Math.atan2(centerX1 - centerX2, centerY1 - centerY2));
                if (degrees < 0.0) {
                    degrees += 360.0;
                }
                if (betterAdvancementEntryScreen.x == this.advConnectedToMouse.x) {
                    if (y1 > y2) {
                        RenderUtil.drawRect(guiGraphics, x1, y1 + 26 - 1, x2, y2, 1.0f, 65280);
                        RenderUtil.drawRect(guiGraphics, x1 + 26 - 1, y1 + 26 - 1, x2, y1 + 26 - 1, 1.0f, 65280);
                        RenderUtil.drawRect(guiGraphics, x1 + 26 - 1, y1, x2, y1, 1.0f, 65280);
                        RenderUtil.drawRect(guiGraphics, x1 + 26 - 1, y2 + 26 - 1, x2, y2 + 26 - 1, 1.0f, 65280);
                        RenderUtil.drawRect(guiGraphics, x1 + 26 - 1, y2, x2, y2, 1.0f, 65280);
                        RenderUtil.drawRect(guiGraphics, x1 + 26 - 1, y1 + 26 - 1, x2 + 26 - 1, y2, 1.0f, 65280);
                    } else {
                        RenderUtil.drawRect(guiGraphics, x1, y2 + 26 - 1, x2, y1, 1.0f, 65280);
                        RenderUtil.drawRect(guiGraphics, x1 + 26 - 1, y2 + 26 - 1, x2, y2 + 26 - 1, 1.0f, 65280);
                        RenderUtil.drawRect(guiGraphics, x1 + 26 - 1, y2, x2, y2, 1.0f, 65280);
                        RenderUtil.drawRect(guiGraphics, x1 + 26 - 1, y1 + 26 - 1, x2, y1 + 26 - 1, 1.0f, 65280);
                        RenderUtil.drawRect(guiGraphics, x1 + 26 - 1, y1, x2, y1, 1.0f, 65280);
                        RenderUtil.drawRect(guiGraphics, x1 + 26 - 1, y2 + 26 - 1, x2 + 26 - 1, y1, 1.0f, 65280);
                    }
                }
                if (betterAdvancementEntryScreen.y == this.advConnectedToMouse.y) {
                    if (x1 > x2) {
                        RenderUtil.drawRect(guiGraphics, x2, y1, x1 + 26 - 1, y2, 1.0f, 65280);
                        RenderUtil.drawRect(guiGraphics, x1, y1, x1, y2 + 26 - 1, 1.0f, 65280);
                        RenderUtil.drawRect(guiGraphics, x1 + 26 - 1, y1, x1 + 26 - 1, y2 + 26 - 1, 1.0f, 65280);
                        RenderUtil.drawRect(guiGraphics, x2, y1, x2, y2 + 26 - 1, 1.0f, 65280);
                        RenderUtil.drawRect(guiGraphics, x2 + 26 - 1, y1, x2 + 26 - 1, y2 + 26 - 1, 1.0f, 65280);
                        RenderUtil.drawRect(guiGraphics, x2, y1 + 26 - 1, x1 + 26 - 1, y2 + 26 - 1, 1.0f, 65280);
                    } else {
                        RenderUtil.drawRect(guiGraphics, x2 + 26 - 1, y1, x1, y2, 1.0f, 65280);
                        RenderUtil.drawRect(guiGraphics, x2, y1, x2, y2 + 26 - 1, 1.0f, 65280);
                        RenderUtil.drawRect(guiGraphics, x2 + 26 - 1, y1, x2 + 26 - 1, y2 + 26 - 1, 1.0f, 65280);
                        RenderUtil.drawRect(guiGraphics, x1, y1, x1, y2 + 26 - 1, 1.0f, 65280);
                        RenderUtil.drawRect(guiGraphics, x1 + 26 - 1, y1, x1 + 26 - 1, y2 + 26 - 1, 1.0f, 65280);
                        RenderUtil.drawRect(guiGraphics, x2 + 26 - 1, y1 + 26 - 1, x1, y2 + 26 - 1, 1.0f, 65280);
                    }
                }
                if (degrees != 45.0 && degrees != 135.0 && degrees != 225.0 && degrees != 315.0) continue;
                RenderUtil.drawRect(guiGraphics, x1, y1, x1 + 26 - 1, y1, 1.0f, 65280);
                RenderUtil.drawRect(guiGraphics, x1, y1 + 26 - 1, x1 + 26 - 1, y1 + 26 - 1, 1.0f, 65280);
                RenderUtil.drawRect(guiGraphics, x1, y1, x1, y1 + 26 - 1, 1.0f, 65280);
                RenderUtil.drawRect(guiGraphics, x1 + 26 - 1, y1, x1 + 26 - 1, y1 + 26 - 1, 1.0f, 65280);
                RenderUtil.drawRect(guiGraphics, x2, y2, x2 + 26 - 1, y2, 1.0f, 65280);
                RenderUtil.drawRect(guiGraphics, x2, y2 + 26 - 1, x2 + 26 - 1, y2 + 26 - 1, 1.0f, 65280);
                RenderUtil.drawRect(guiGraphics, x2, y2, x2, y2 + 26 - 1, 1.0f, 65280);
                RenderUtil.drawRect(guiGraphics, x2 + 26 - 1, y2, x2 + 26 - 1, y2 + 26 - 1, 1.0f, 65280);
                if (degrees == 45.0 || degrees == 225.0) {
                    RenderUtil.drawRect(guiGraphics, x1, y1 + 26 - 1, x2, y2 + 26 - 1, 1.0f, 65280);
                    RenderUtil.drawRect(guiGraphics, x1 + 26 - 1, y1, x2 + 26 - 1, y2, 1.0f, 65280);
                    continue;
                }
                if (degrees != 135.0 && degrees != 315.0) continue;
                RenderUtil.drawRect(guiGraphics, x1, y1, x2, y2, 1.0f, 65280);
                RenderUtil.drawRect(guiGraphics, x1 + 26 - 1, y1 + 26 - 1, x2 + 26 - 1, y2 + 26 - 1, 1.0f, 65280);
            }
        }
        if (showDebugCoordinates && this.selectedTab != null && mouseX < this.internalWidth - 30 - 9 && mouseX > 39 && mouseY < this.internalHeight - top + 1 && mouseY > top + 18) {
            if (this.advConnectedToMouse != null) {
                int currentX = this.advConnectedToMouse.x + left + 9 + this.selectedTab.scrollX + 3 + 1;
                int n = this.advConnectedToMouse.y + top + 18 + this.selectedTab.scrollY;
                Objects.requireNonNull(this.font);
                int currentY = n - 9 + 1;
                guiGraphics.drawString(this.font, this.advConnectedToMouse.x + "," + this.advConnectedToMouse.y, currentX, currentY, 0);
            } else {
                int xMouse = mouseX - left - 9;
                int yMouse = mouseY - top - 18;
                int currentX = xMouse - this.selectedTab.scrollX - 3 - 1;
                int currentY = yMouse - this.selectedTab.scrollY - 1;
                String string = currentX + "," + currentY;
                Objects.requireNonNull(this.font);
                guiGraphics.drawString(this.font, string, mouseX, mouseY - 9, 0);
            }
        }
    }

    private void renderInside(GuiGraphics guiGraphics, int mouseX, int mouseY, int left, int top, int right, int bottom, int maxTabs, int skip) {
        BetterAdvancementTab betterAdvancementTab = this.selectedTab;
        int boxLeft = left + 9;
        int boxTop = top + 18;
        int boxRight = right - 9;
        int boxBottom = bottom - 9;
        int width = boxRight - boxLeft;
        int height = boxBottom - boxTop;
        if (betterAdvancementTab == null) {
            guiGraphics.fill(boxLeft, boxTop, boxRight, boxBottom, -16777216);
            int n = boxLeft + (width - this.font.width((FormattedText)NO_ADVANCEMENTS_LABEL)) / 2;
            int n2 = boxTop + height / 2;
            Objects.requireNonNull(this.font);
            guiGraphics.drawString(this.font, NO_ADVANCEMENTS_LABEL, n, n2 - 9, -1);
            int n3 = boxLeft + (width - this.font.width((FormattedText)VERY_SAD_LABEL)) / 2;
            int n4 = boxTop + height / 2;
            Objects.requireNonNull(this.font);
            guiGraphics.drawString(this.font, VERY_SAD_LABEL, n3, n4 + 9, -1);
        } else {
            betterAdvancementTab.drawContents(guiGraphics, boxLeft, boxTop, width, height, zoom);
        }
    }

    public void renderWindow(GuiGraphics guiGraphics, int left, int top, int right, int bottom, int maxTabs, int skip) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, Resources.Gui.WINDOW, left, top, 0.0f, 0.0f, 30, 30, 256, 256);
        RenderUtil.renderRepeating(Resources.Gui.WINDOW, guiGraphics, left + 30, top, this.internalWidth - 30 - 60 - 30, 30, 30, 0, 192, 30);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, Resources.Gui.WINDOW, right - 30, top, 222.0f, 0.0f, 30, 30, 256, 256);
        RenderUtil.renderRepeating(Resources.Gui.WINDOW, guiGraphics, left, top + 30, 30, bottom - top - 60, 0, 30, 30, 80);
        RenderUtil.renderRepeating(Resources.Gui.WINDOW, guiGraphics, right - 30, top + 30, 30, bottom - top - 60, 222, 30, 30, 80);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, Resources.Gui.WINDOW, left, bottom - 30, 0.0f, 110.0f, 30, 30, 256, 256);
        RenderUtil.renderRepeating(Resources.Gui.WINDOW, guiGraphics, left + 30, bottom - 30, this.internalWidth - 30 - 60 - 30, 30, 30, 110, 192, 30);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, Resources.Gui.WINDOW, right - 30, bottom - 30, 222.0f, 110.0f, 30, 30, 256, 256);
        int width = right - left;
        int height = bottom - top;
        if (this.tabs.size() > 1) {
            for (BetterAdvancementTab tab : this.tabs.values().stream().skip(skip).limit(maxTabs).toList()) {
                tab.drawTab(guiGraphics, left, top, width, height, tab == this.selectedTab);
            }
            for (BetterAdvancementTab tab : this.tabs.values().stream().skip(skip).limit(maxTabs).toList()) {
                tab.drawIcon(guiGraphics, left, top, width, height);
            }
        }
        FormattedCharSequence windowTitle = TITLE.getVisualOrderText();
        if (this.selectedTab != null) {
            windowTitle = FormattedCharSequence.composite((FormattedCharSequence[])new FormattedCharSequence[]{windowTitle, Component.literal((String)" - ").getVisualOrderText(), this.selectedTab.getTitle().getVisualOrderText()});
        }
        guiGraphics.drawString(this.font, windowTitle, left + 8, top + 6, 0x404040, false);
    }

    private void renderToolTips(GuiGraphics guiGraphics, int mouseX, int mouseY, int left, int top, int right, int bottom, int maxTabs, int skip) {
        if (this.selectedTab != null) {
            guiGraphics.pose().pushMatrix();
            guiGraphics.pose().translate((float)(left + 9), (float)(top + 18));
            this.selectedTab.drawToolTips(guiGraphics, mouseX - left - 9, mouseY - top - 18, left, top, right - left - 18, bottom - top - 27, zoom);
            guiGraphics.pose().popMatrix();
        }
        int width = right - left;
        int height = bottom - top;
        if (this.tabs.size() > 1) {
            for (BetterAdvancementTab tab : this.tabs.values().stream().skip(skip).limit(maxTabs).toList()) {
                if (!tab.isMouseOver(left, top, width, height, mouseX, mouseY)) continue;
                guiGraphics.setTooltipForNextFrame(this.font, tab.getTitle(), mouseX, mouseY);
            }
        }
    }

    public void onAddAdvancementRoot(AdvancementNode advancement) {
        BetterAdvancementTab betterAdvancementTabGui = BetterAdvancementTab.create(this.minecraft, this, this.tabs.size(), advancement, this.internalWidth - 60, this.internalHeight - 40 - 30);
        if (betterAdvancementTabGui != null) {
            this.tabs.put(advancement.holder(), betterAdvancementTabGui);
        }
    }

    public void onRemoveAdvancementRoot(AdvancementNode advancement) {
    }

    public void onAddAdvancementTask(AdvancementNode advancement) {
        BetterAdvancementTab betterAdvancementTabGui = this.getTab(advancement);
        if (betterAdvancementTabGui != null) {
            betterAdvancementTabGui.addAdvancement(advancement);
        }
    }

    public void onRemoveAdvancementTask(AdvancementNode advancement) {
    }

    public void onUpdateAdvancementProgress(AdvancementNode advancement, AdvancementProgress advancementProgress) {
        BetterAdvancementWidget betterAdvancementEntryScreen = this.getAdvancementWidget(advancement);
        if (betterAdvancementEntryScreen != null) {
            betterAdvancementEntryScreen.getAdvancementProgress(advancementProgress);
        }
    }

    public void onSelectedTabChanged(AdvancementHolder advancement) {
        if (this.selectedTab != null) {
            this.selectedTab.storeScroll();
        }
        this.selectedTab = this.tabs.get(advancement);
        if (this.selectedTab != null) {
            this.selectedTab.loadScroll();
        }
    }

    public void onAdvancementsCleared() {
        this.tabs.clear();
        this.selectedTab = null;
    }

    public BetterAdvancementWidget getAdvancementWidget(AdvancementNode advancement) {
        BetterAdvancementTab betterAdvancementTab = this.getTab(advancement);
        return betterAdvancementTab == null ? null : betterAdvancementTab.getWidget(advancement.holder());
    }

    private BetterAdvancementTab getTab(AdvancementNode advancement) {
        AdvancementNode advancementNode = advancement.root();
        return this.tabs.get(advancementNode.holder());
    }

    static {
        zoom = 1.0f;
        uiScaling = 100;
        showDebugCoordinates = false;
        orderTabsAlphabetically = false;
    }
}

