/*
 * Decompiled with CFR 0.152.
 */
package net.brightnessplus;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1041;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;

public class BrightnessPlus
implements ClientModInitializer {
    private static final Gson GSON = new Gson();
    private static final class_304.class_11900 BRIGHTNESS_CATEGORY = class_304.class_11900.method_74698((class_2960)class_2960.method_60655((String)"brightness-plus", (String)"main"));
    public static double minBrightness = -1.0;
    public static double maxBrightness = 12.0;
    public static double brightnessSliderInterval = 0.05;
    private static double step = 0.1;
    private static final double DEFAULT_MINECRAFT_BRIGHTNESS = 0.0;
    private static final double BRIGHTNESS_1200_PERCENT = 12.0;
    private static boolean isToggledOn = false;
    public static ArrayList<Double> brightnesses;
    private static int brightnessIndex;
    private static int lastBrightnessIndex;
    private static class_304 TOGGLE_BIND;
    private static class_304 RAISE_BIND;
    private static class_304 LOWER_BIND;
    public static class_310 client;

    public void onInitializeClient() {
        System.out.println("[BrightnessPlus] ===== MOD INITIALIZATION STARTED =====");
        System.out.println("[BrightnessPlus] onInitializeClient() method called");
        System.out.println("[BrightnessPlus] Registering keybindings");
        TOGGLE_BIND = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.brightness-plus.toggle", class_3675.class_307.field_1668, 66, BRIGHTNESS_CATEGORY));
        RAISE_BIND = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.brightness-plus.raise", class_3675.class_307.field_1668, 61, BRIGHTNESS_CATEGORY));
        LOWER_BIND = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.brightness-plus.lower", class_3675.class_307.field_1668, 45, BRIGHTNESS_CATEGORY));
        ClientTickEvents.END_CLIENT_TICK.register(this::onEndTick);
        System.out.println("[BrightnessPlus] Loading config...");
        this.loadConfig();
        System.out.println("[BrightnessPlus] Getting MinecraftClient instance...");
        client = class_310.method_1551();
        System.out.println("[BrightnessPlus] ===== MOD INITIALIZATION COMPLETED =====");
    }

    public static int numBrightnesses() {
        return brightnesses.size();
    }

    public static int getBrightnessIndex() {
        return brightnessIndex;
    }

    public static void setBrightnessIndex(int index) {
        brightnessIndex = index;
        BrightnessPlus.client.field_1690.method_42473().method_41748((Object)BrightnessPlus.getBrightness());
    }

    public static double getBrightness() {
        return brightnesses.get(brightnessIndex);
    }

    public static double getBrightness(int index) {
        return brightnesses.get(index);
    }

    public static void changeBrightness(double brightness) {
        brightnesses.set(BrightnessPlus.getBrightnessIndex(), brightness);
        BrightnessPlus.client.field_1690.method_42473().method_41748((Object)BrightnessPlus.getBrightness());
        BrightnessPlus.client.field_1690.method_1640();
    }

    public static void changeBrightness(int index, double brightness) {
        if (index == brightnessIndex) {
            BrightnessPlus.changeBrightness(brightness);
        } else {
            brightnesses.set(index, brightness);
        }
    }

    private void loadConfig() {
        try {
            JsonObject config = (JsonObject)GSON.fromJson(new String(Files.readAllBytes(BrightnessPlus.getConfigPath())), JsonObject.class);
            this.asDouble(config.get("min"), min -> {
                minBrightness = min;
            });
            this.asDouble(config.get("max"), max -> {
                maxBrightness = max;
            });
            this.asDouble(config.get("step"), step -> {
                BrightnessPlus.step = step;
            });
            brightnesses = new ArrayList();
            this.asInt(config.get("selected"), selected -> {
                brightnessIndex = selected - 1;
            });
            brightnessIndex = Math.max(0, Math.min(BrightnessPlus.numBrightnesses() - 1, brightnessIndex));
            if (config.has("last")) {
                this.asInt(config.get("last"), last -> {
                    lastBrightnessIndex = last - 1;
                });
                lastBrightnessIndex = Math.max(0, Math.min(BrightnessPlus.numBrightnesses() - 1, lastBrightnessIndex));
            } else {
                lastBrightnessIndex = 0;
            }
        }
        catch (JsonSyntaxException | IOException ex) {
            BrightnessPlus.logException((Exception)ex, "Failed to load BrightnessPlus config");
        }
        if (brightnesses == null || brightnesses.size() < 2) {
            brightnesses = new ArrayList();
            brightnesses.add(1.0);
            brightnesses.add(maxBrightness);
            brightnessIndex = 0;
            lastBrightnessIndex = 0;
        }
    }

    public static void saveConfig() {
        JsonObject config = new JsonObject();
        config.addProperty("min", (Number)minBrightness);
        config.addProperty("max", (Number)maxBrightness);
        config.addProperty("step", (Number)step);
        config.addProperty("selected", (Number)(brightnessIndex + 1));
        config.addProperty("last", (Number)(lastBrightnessIndex + 1));
        for (int i = 0; i < brightnesses.size(); ++i) {
            config.addProperty(String.valueOf(i + 1), (Number)brightnesses.get(i));
        }
        try {
            Files.write(BrightnessPlus.getConfigPath(), GSON.toJson((JsonElement)config).getBytes(), new OpenOption[0]);
        }
        catch (IOException ex) {
            BrightnessPlus.logException(ex, "Failed to save BrightnessPlus config");
        }
    }

    private static Path getConfigPath() {
        return FabricLoader.getInstance().getConfigDir().resolve("brightnessplus.json");
    }

    private void asDouble(JsonElement element, DoubleConsumer onSuccess) {
        if (element != null && element.isJsonPrimitive() && ((JsonPrimitive)element).isNumber()) {
            onSuccess.accept(element.getAsDouble());
        }
    }

    private void asInt(JsonElement element, IntConsumer onSuccess) {
        if (element != null && element.isJsonPrimitive() && ((JsonPrimitive)element).isNumber()) {
            onSuccess.accept(element.getAsInt());
        }
    }

    private void showOverlay(class_310 client) {
        client.field_1705.method_1758((class_2561)class_2561.method_43469((String)"overlay.brightness-plus.change", (Object[])new Object[]{Math.round(BrightnessPlus.getBrightness() * 100.0)}).method_27694(s -> s.method_10977(class_124.field_1060)), false);
    }

    private void onEndTick(class_310 client) {
        double brightness;
        boolean ctrl;
        boolean shift;
        while (TOGGLE_BIND.method_1436()) {
            System.out.println("[BrightnessPlus] DEBUG: Toggle key pressed!");
            if (!isToggledOn) {
                System.out.println("[BrightnessPlus] DEBUG: Setting brightness to 1200% (12.0)");
                System.out.println("[BrightnessPlus] DEBUG: Current gamma before: " + String.valueOf(client.field_1690.method_42473().method_41753()));
                brightnesses.set(BrightnessPlus.getBrightnessIndex(), 12.0);
                client.field_1690.method_42473().method_41748((Object)12.0);
                client.field_1690.method_1640();
                isToggledOn = true;
                System.out.println("[BrightnessPlus] DEBUG: Gamma after: " + String.valueOf(client.field_1690.method_42473().method_41753()));
            } else {
                System.out.println("[BrightnessPlus] DEBUG: Setting brightness to default (0.0)");
                System.out.println("[BrightnessPlus] DEBUG: Current gamma before: " + String.valueOf(client.field_1690.method_42473().method_41753()));
                brightnesses.set(BrightnessPlus.getBrightnessIndex(), 0.0);
                client.field_1690.method_42473().method_41748((Object)0.0);
                client.field_1690.method_1640();
                isToggledOn = false;
                System.out.println("[BrightnessPlus] DEBUG: Gamma after: " + String.valueOf(client.field_1690.method_42473().method_41753()));
            }
            this.showOverlay(client);
            BrightnessPlus.saveConfig();
        }
        while (RAISE_BIND.method_1436()) {
            System.out.println("[BrightnessPlus] DEBUG: Raise key pressed!");
            shift = class_3675.method_15987((class_1041)client.method_22683(), (int)340) || class_3675.method_15987((class_1041)client.method_22683(), (int)344);
            ctrl = class_3675.method_15987((class_1041)client.method_22683(), (int)341) || class_3675.method_15987((class_1041)client.method_22683(), (int)345);
            double increment = step;
            if (shift) {
                increment *= 5.0;
            }
            if (ctrl) {
                increment *= 0.2;
            }
            brightness = Math.max(minBrightness, Math.min(maxBrightness, BrightnessPlus.getBrightness() + increment));
            System.out.println("[BrightnessPlus] DEBUG: Raising brightness to: " + brightness);
            BrightnessPlus.changeBrightness(brightness);
            this.showOverlay(client);
            BrightnessPlus.saveConfig();
        }
        while (LOWER_BIND.method_1436()) {
            System.out.println("[BrightnessPlus] DEBUG: Lower key pressed!");
            shift = class_3675.method_15987((class_1041)client.method_22683(), (int)340) || class_3675.method_15987((class_1041)client.method_22683(), (int)344);
            ctrl = class_3675.method_15987((class_1041)client.method_22683(), (int)341) || class_3675.method_15987((class_1041)client.method_22683(), (int)345);
            double decrement = step;
            if (shift) {
                decrement *= 5.0;
            }
            if (ctrl) {
                decrement *= 0.2;
            }
            brightness = Math.max(minBrightness, Math.min(maxBrightness, BrightnessPlus.getBrightness() - decrement));
            System.out.println("[BrightnessPlus] DEBUG: Lowering brightness to: " + brightness);
            BrightnessPlus.changeBrightness(brightness);
            this.showOverlay(client);
            BrightnessPlus.saveConfig();
        }
        double targetGamma = isToggledOn ? BrightnessPlus.getBrightness() : 0.0;
        double currentGamma = (Double)client.field_1690.method_42473().method_41753();
        if (Math.abs(currentGamma - targetGamma) > 1.0E-6) {
            client.field_1690.method_42473().method_41748((Object)targetGamma);
        }
    }

    public static void logException(Exception ex, String message) {
        System.err.printf("[BrightnessPlus] %s (%s: %s)", message, ex.getClass().getSimpleName(), ex.getLocalizedMessage());
    }

    public static boolean isFullbrightEnabled() {
        return isToggledOn;
    }

    static {
        brightnessIndex = 0;
        lastBrightnessIndex = 0;
    }
}

