/*
 * Decompiled with CFR 0.152.
 */
package com.sushiy.tektopiaaddons;

import com.sushiy.tektopiaaddons.EntityAIMoveToBlockCopy;
import com.sushiy.tektopiaaddons.ITradeableStructure;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.BlockPos;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.tangotek.tektopia.entities.EntityMerchant;
import net.tangotek.tektopia.entities.EntityVillageNavigator;
import net.tangotek.tektopia.structures.VillageStructure;
import net.tangotek.tektopia.structures.VillageStructureType;

public class EntityAITradeAtDeliveryChest
extends EntityAIMoveToBlockCopy {
    protected final EntityMerchant merchant;
    protected VillageStructure merchantStall;
    TileEntityChest merchantStallChest;
    private boolean active = false;
    private ItemStack itemCarryingCopy;
    MerchantRecipe currentTradeDeal = null;
    int targetTradeSlot = -1;
    int targetResultSlot = -1;
    int tradingLengthTicks = 50;
    int totalConsecutiveTrades = 4;
    boolean openedChest = false;
    int tradingTime = -1;

    public EntityAITradeAtDeliveryChest(EntityMerchant entityIn) {
        super((EntityVillageNavigator)entityIn);
        this.merchant = entityIn;
    }

    @Override
    protected BlockPos getDestinationBlock() {
        if (this.merchant == null || this.merchant.getVillage() == null) {
            return null;
        }
        List validStalls = this.merchant.getVillage().getStructures(VillageStructureType.MERCHANT_STALL).stream().filter(x -> ((ITradeableStructure)x).tektopiaAddons$getDeliveryChestPos() != null).collect(Collectors.toList());
        Collections.shuffle(validStalls);
        if (!validStalls.isEmpty()) {
            this.merchantStall = (VillageStructure)validStalls.get(0);
            return ((ITradeableStructure)this.merchantStall).tektopiaAddons$getDeliveryChestPos();
        }
        return null;
    }

    @Override
    protected void onArrival() {
        super.onArrival();
        this.startDelivery();
        this.openChest();
    }

    @Override
    public boolean func_75253_b() {
        return this.active;
    }

    private void startDelivery() {
        this.tradingTime = this.totalConsecutiveTrades * this.tradingLengthTicks;
        ITradeableStructure tradeable = (ITradeableStructure)this.merchantStall;
        this.merchantStall.occupySpecialBlock(tradeable.tektopiaAddons$getDeliveryChestPos());
    }

    @Override
    public void func_75246_d() {
        super.func_75246_d();
        if (this.tradingTime > 0) {
            --this.tradingTime;
            if (this.tradingTime % this.tradingLengthTicks == 0) {
                this.PerformTrade();
            }
        } else if (this.tradingTime == 0) {
            this.stopDelivery();
        }
    }

    private void openChest() {
        EntityPlayer p;
        TileEntityChest tileEntityChest = this.getChest();
        this.openedChest = true;
        if (tileEntityChest != null && (p = this.merchant.field_70170_p.func_190525_a((double)this.destinationPos.func_177958_n(), (double)this.destinationPos.func_177956_o(), (double)this.destinationPos.func_177952_p(), -1.0, EntitySelectors.field_180132_d)) != null) {
            tileEntityChest.func_174889_b(p);
        }
    }

    private void closeChest() {
        TileEntityChest tileEntityChest = this.getChest();
        if (tileEntityChest != null && this.openedChest) {
            this.openedChest = false;
            EntityPlayer p = this.merchant.field_70170_p.func_190525_a((double)this.destinationPos.func_177958_n(), (double)this.destinationPos.func_177956_o(), (double)this.destinationPos.func_177952_p(), -1.0, EntitySelectors.field_180132_d);
            if (p != null) {
                tileEntityChest.func_174886_c(p);
            }
        }
    }

    TileEntityChest getChest() {
        if (this.merchantStall == null) {
            this.getDestinationBlock();
        }
        if (this.merchantStallChest == null && this.merchantStall != null) {
            ITradeableStructure tradeable = (ITradeableStructure)this.merchantStall;
            this.merchantStallChest = tradeable.tektopiaAddons$getDeliveryChest();
        }
        return this.merchantStallChest;
    }

    public void PerformTrade() {
        ItemStack inChest = this.getChest().func_70301_a(this.targetTradeSlot);
        boolean hasTraded = false;
        if (this.currentTradeDeal != null) {
            this.itemCarryingCopy = this.currentTradeDeal.func_77394_a().func_77946_l();
            this.merchant.equipActionItem(this.itemCarryingCopy);
            int tradeCount = inChest.func_190916_E() / this.currentTradeDeal.func_77394_a().func_190916_E();
            for (int x = 0; x < tradeCount && !this.currentTradeDeal.func_82784_g(); ++x) {
                this.currentTradeDeal.func_77399_f();
                ItemStack fromChest = this.getChest().func_70304_b(this.targetTradeSlot);
                fromChest.func_190920_e(fromChest.func_190916_E() - this.currentTradeDeal.func_77394_a().func_190916_E());
                this.getChest().func_70299_a(this.targetTradeSlot, fromChest);
                ItemStack resultStack = this.getChest().func_70304_b(this.targetResultSlot);
                if (!resultStack.func_190926_b()) {
                    resultStack.func_190920_e(resultStack.func_190916_E() + this.currentTradeDeal.func_77397_d().func_190916_E());
                } else {
                    resultStack = this.currentTradeDeal.func_77397_d();
                }
                this.getChest().func_70299_a(this.targetResultSlot, resultStack);
                hasTraded = true;
            }
        }
        if (hasTraded) {
            this.merchant.field_70757_a = -this.merchant.func_70627_aG();
            this.merchant.func_184185_a(SoundEvents.field_187915_go, 1.0f, this.merchant.func_70631_g_() ? (this.merchant.func_70681_au().nextFloat() - this.merchant.func_70681_au().nextFloat()) * 0.2f + 1.5f : (this.merchant.func_70681_au().nextFloat() - this.merchant.func_70681_au().nextFloat()) * 0.2f + 1.0f);
        }
        this.currentTradeDeal = this.GetValidTradeDeal();
        if (this.currentTradeDeal != null) {
            this.stopDelivery();
        }
    }

    protected int getFirstFreeOrMatchingChestSlot(TileEntityChest chest, ItemStack stack) {
        for (int i = 0; i < chest.func_70302_i_(); ++i) {
            int stackUntilMax;
            ItemStack is = chest.func_70301_a(i);
            if (is.func_190926_b()) {
                return i;
            }
            if (!ItemStack.func_179545_c((ItemStack)is, (ItemStack)stack) || (stackUntilMax = is.func_77976_d() - is.func_190916_E()) <= stack.func_190916_E()) continue;
            return i;
        }
        return -1;
    }

    MerchantRecipe GetValidTradeDeal() {
        MerchantRecipeList recipes = this.merchant.func_70934_b(null);
        if (recipes == null) {
            return null;
        }
        for (MerchantRecipe tradeDeal : recipes) {
            if (tradeDeal.func_82784_g()) continue;
            for (int j = 0; j < this.getChest().func_70302_i_(); ++j) {
                int resultSlot;
                ItemStack stack = this.getChest().func_70301_a(j);
                if (stack.func_190926_b() || !ItemStack.func_179545_c((ItemStack)tradeDeal.func_77394_a(), (ItemStack)stack) || (resultSlot = this.getFirstFreeOrMatchingChestSlot(this.getChest(), tradeDeal.func_77397_d())) == -1) continue;
                this.targetTradeSlot = j;
                this.targetResultSlot = resultSlot;
                return tradeDeal;
            }
        }
        return null;
    }

    protected MerchantRecipe getTradeDeal(ItemStack itemStack) {
        for (MerchantRecipe recipe : this.merchant.func_70934_b(null)) {
            if (!ItemStack.func_179545_c((ItemStack)recipe.func_77394_a(), (ItemStack)itemStack)) continue;
            return recipe;
        }
        return null;
    }

    private void stopDelivery() {
        this.active = false;
        this.closeChest();
    }

    public boolean func_75252_g() {
        return this.tradingTime > 30 || this.tradingTime <= 0;
    }

    @Override
    protected void onStuck() {
        this.stopDelivery();
        super.onStuck();
    }

    @Override
    protected BlockPos findWalkPos() {
        BlockPos result = super.findWalkPos();
        if (result == null) {
            BlockPos pos = this.destinationPos;
            BlockPos testPos = pos.func_177985_f(2);
            if (this.isWalkable(testPos, this.navigator)) {
                return testPos;
            }
            testPos = pos.func_177965_g(2);
            if (this.isWalkable(testPos, this.navigator)) {
                return testPos;
            }
            testPos = pos.func_177964_d(2);
            if (this.isWalkable(testPos, this.navigator)) {
                return testPos;
            }
            testPos = pos.func_177970_e(2);
            if (this.isWalkable(testPos, this.navigator)) {
                return testPos;
            }
        }
        return result;
    }

    @Override
    public boolean func_75250_a() {
        if (this.merchant.isAITick() && this.merchant.hasVillage()) {
            if (this.getChest() == null) {
                return false;
            }
            this.currentTradeDeal = this.GetValidTradeDeal();
            if (this.currentTradeDeal != null) {
                return super.func_75250_a();
            }
        }
        return false;
    }

    @Override
    public void func_75249_e() {
        this.active = true;
        this.tradingTime = -1;
        this.merchant.setStall(1);
        this.itemCarryingCopy = this.currentTradeDeal.func_77394_a().func_77946_l();
        if (this.itemCarryingCopy != null) {
            this.merchant.equipActionItem(this.itemCarryingCopy);
        }
        super.func_75249_e();
    }

    @Override
    protected void updateMovementMode() {
        this.merchant.setMovementMode(this.merchant.getDefaultMovement());
    }

    @Override
    public void func_75251_c() {
        this.tradingTime = -1;
        this.currentTradeDeal = null;
        this.targetResultSlot = -1;
        this.targetTradeSlot = -1;
        this.stopDelivery();
        super.func_75251_c();
        if (this.itemCarryingCopy != null) {
            this.merchant.unequipActionItem(this.itemCarryingCopy);
            this.itemCarryingCopy = null;
            this.merchant.setStoragePriority();
        }
    }
}

