/*
 * Decompiled with CFR 0.152.
 */
package com.sushiy.tektopiaaddons;

import com.leviathanstudio.craftstudio.common.animation.AnimationHandler;
import com.sushiy.tektopiaaddons.EntityAIAttackRangedBow2;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.tangotek.tektopia.ItemTagType;
import net.tangotek.tektopia.ModItems;
import net.tangotek.tektopia.ModSoundEvents;
import net.tangotek.tektopia.ProfessionType;
import net.tangotek.tektopia.TekVillager;
import net.tangotek.tektopia.Village;
import net.tangotek.tektopia.VillagerRole;
import net.tangotek.tektopia.entities.EntityCaptainAura;
import net.tangotek.tektopia.entities.EntityVillagerTek;
import net.tangotek.tektopia.entities.ai.EntityAIEatGoldenApple;
import net.tangotek.tektopia.entities.ai.EntityAIMeleeTarget;
import net.tangotek.tektopia.entities.ai.EntityAIPatrolGuardPost;
import net.tangotek.tektopia.entities.ai.EntityAIPatrolVillage;
import net.tangotek.tektopia.entities.ai.EntityAIPickUpItem;
import net.tangotek.tektopia.entities.ai.EntityAIProtectVillage;
import net.tangotek.tektopia.storage.ItemDesire;
import net.tangotek.tektopia.storage.UpgradeEquipment;
import net.tangotek.tektopia.structures.VillageStructure;
import net.tangotek.tektopia.structures.VillageStructureBarracks;
import net.tangotek.tektopia.structures.VillageStructureType;

public class EntityArcher
extends EntityVillagerTek
implements IRangedAttackMob {
    protected static AnimationHandler animHandler = TekVillager.getNewAnimationHandler(EntityArcher.class);
    private static final DataParameter<Boolean> SALUTE = EntityDataManager.func_187226_a(EntityArcher.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> EAT_GOLDEN_APPLE = EntityDataManager.func_187226_a(EntityArcher.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> PICKUP_EMERALDS = EntityDataManager.func_187226_a(EntityArcher.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> EQUIP_LEATHER_ARMOR;
    private static final DataParameter<Boolean> PRACTICE_BOW;
    protected int courageChance = 1;
    protected int wantsPractice = 0;

    public EntityArcher(World worldIn, ProfessionType profType, int roleMask) {
        super(worldIn, ProfessionType.GUARD, VillagerRole.VILLAGER.value | VillagerRole.DEFENDER.value);
    }

    protected int getBowSkillChance() {
        return this.func_70638_az() instanceof EntityArmorStand ? 4 : 1;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        Runnable onHit = () -> {
            this.tryAddSkill(ProfessionType.GUARD, this.getBowSkillChance());
            if (this.isHostile().test((Object)this.func_70638_az())) {
                if (this.courageChance > 0 && this.func_70681_au().nextInt(this.courageChance) == 0) {
                    EntityCaptainAura aura = new EntityCaptainAura(this.func_130014_f_(), this.getX(), this.getY(), this.getZ());
                    aura.func_184483_a(3.0f);
                    aura.func_184485_d(10);
                    aura.func_184486_b(40);
                    aura.func_184487_c((float)this.getSkillLerp(ProfessionType.GUARD, 1, 6) / 10.0f);
                    this.field_70170_p.func_72838_d((Entity)aura);
                    this.playSound(ModSoundEvents.courageAura);
                    this.courageChance += 6;
                } else {
                    this.courageChance = Math.max(this.courageChance - 1, 1);
                }
            }
        };
        this.getDesireSet().addItemDesire(new ItemDesire(Items.field_151153_ao, 1, 1, 1, (Predicate)null));
        this.getDesireSet().addItemDesire((ItemDesire)new UpgradeEquipment("Weapon", EntityArcher.getBestWeapon(this), EntityEquipmentSlot.MAINHAND, (Predicate)null));
        this.addTask(49, (EntityAIBase)new EntityAIEatGoldenApple((EntityVillagerTek)this));
        this.addTask(49, (EntityAIBase)new EntityAIMeleeTarget((EntityVillagerTek)this, p -> EntityArcher.getWeapon(this), EntityVillagerTek.VillagerThought.SWORD, p -> !p.isSleepingTime(), onHit, ProfessionType.GUARD));
        this.addTask(49, new EntityAIAttackRangedBow2<EntityArcher>(this, 1.0, 20, 15.0f));
        ArrayList<EntityAIPickUpItem.PickUpData> pickUpCounts = new ArrayList<EntityAIPickUpItem.PickUpData>();
        pickUpCounts.add(new EntityAIPickUpItem.PickUpData(new ItemStack(Items.field_151166_bC, 1, 0), 60, "pickup_emeralds"));
        this.addTask(50, (EntityAIBase)new EntityAIPickUpItem((EntityVillagerTek)this, pickUpCounts, 1));
        this.addTask(50, (EntityAIBase)new EntityAIPatrolGuardPost((EntityVillagerTek)this, p -> this.hasVillage() && p.isWorkTime() && EntityArcher.hasWeapon(this), 8, 60));
        this.addTask(50, (EntityAIBase)new EntityAIPatrolVillage((EntityVillagerTek)this, p -> EntityArcher.hasWeapon(this)));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIProtectVillage((EntityVillagerTek)this, p -> !p.isSleeping()));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityZombie.class, true));
    }

    public static Function<ItemStack, Integer> getBestWeapon(EntityArcher archer) {
        return p -> {
            if (p.func_77973_b() instanceof ItemBow) {
                ItemBow bow = (ItemBow)p.func_77973_b();
                if (p.func_77948_v() && !archer.isAIFilterEnabled("equip_enchanted_sword")) {
                    return -1;
                }
                int score = 1;
                score = (int)((float)score + EnchantmentHelper.func_152377_a((ItemStack)p, (EnumCreatureAttribute)EnumCreatureAttribute.UNDEFINED));
                ++score;
                score *= 10;
                if (ModItems.isTaggedItem((ItemStack)p, (ItemTagType)ItemTagType.VILLAGER)) {
                    ++score;
                }
                return score;
            }
            return -1;
        };
    }

    public static boolean hasWeapon(EntityVillagerTek villager) {
        return !EntityArcher.getWeapon(villager).func_190926_b();
    }

    protected static ItemStack getWeapon(EntityVillagerTek villager) {
        return villager.func_184582_a(EntityEquipmentSlot.MAINHAND);
    }

    public void func_70604_c(@Nullable EntityLivingBase livingBase) {
        double distRevenge;
        double distTarget;
        super.func_70604_c(livingBase);
        if (livingBase != null && this.func_70638_az() != null && this.func_70638_az() != livingBase && !(livingBase instanceof EntityPlayer) && (distTarget = this.func_70068_e((Entity)this.func_70638_az())) > (distRevenge = this.func_70068_e((Entity)livingBase)) * 2.0) {
            this.func_70624_b(livingBase);
        }
    }

    public void func_70624_b(@Nullable EntityLivingBase target) {
        super.func_70624_b(target);
        if (this.hasVillage() && !(target instanceof EntityArmorStand)) {
            this.getVillage().addActiveDefender((EntityVillagerTek)this);
        }
    }

    protected void randomizeGoals() {
        super.randomizeGoals();
        this.wantsPractice = 0;
        if (this.func_70681_au().nextInt(2) == 0) {
            this.wantsPractice = this.func_70681_au().nextInt(10) + 15;
        }
    }

    public void attachToVillage(Village v) {
        super.attachToVillage(v);
        this.sleepOffset = v.getNextGuardSleepOffset();
    }

    public int wantsPractice() {
        return this.getSkill(ProfessionType.GUARD) < this.getIntelligence() ? this.wantsPractice : 0;
    }

    protected void bedCheck() {
        VillageStructure struct;
        if (this.hasVillage() && this.homeFrame != null && !((struct = this.village.getStructureFromFrame(this.homeFrame)) instanceof VillageStructureBarracks)) {
            List barracks = this.village.getStructures(VillageStructureType.BARRACKS);
            Stream var10000 = barracks.stream();
            VillageStructureBarracks.class.getClass();
        }
        super.bedCheck();
    }

    public void onStopSleep() {
        super.onStopSleep();
        this.equipBestGear();
    }

    public void func_70636_d() {
        super.func_70636_d();
    }

    protected boolean canVillagerPickupItem(Item itemIn) {
        return false;
    }

    public com.google.common.base.Predicate<Entity> isSuitableTarget() {
        return e -> super.isHostile().test(e) || e instanceof EntityArmorStand;
    }

    public boolean isFleeFrom(Entity e) {
        ItemStack equipped = this.func_184582_a(EntityEquipmentSlot.MAINHAND);
        return equipped == ItemStack.field_190927_a ? super.isFleeFrom(e) : false;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        EntityArrow entityarrow = this.getArrow(distanceFactor);
        if (this.func_184614_ca().func_77973_b() instanceof ItemBow) {
            entityarrow = ((ItemBow)this.func_184614_ca().func_77973_b()).customizeArrow(entityarrow);
        }
        double d0 = target.field_70165_t - this.field_70165_t;
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - entityarrow.field_70163_u;
        double d2 = target.field_70161_v - this.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        entityarrow.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
        this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)entityarrow);
    }

    protected EntityArrow getArrow(float p_190726_1_) {
        EntityTippedArrow entitytippedarrow = new EntityTippedArrow(this.field_70170_p, (EntityLivingBase)this);
        entitytippedarrow.func_190547_a((EntityLivingBase)this, p_190726_1_);
        return entitytippedarrow;
    }

    public void func_184724_a(boolean swingingArms) {
    }

    public AnimationHandler getAnimationHandler() {
        return animHandler;
    }

    static {
        PRACTICE_BOW = EntityDataManager.func_187226_a(EntityArcher.class, (DataSerializer)DataSerializers.field_187198_h);
        EQUIP_LEATHER_ARMOR = EntityDataManager.func_187226_a(EntityArcher.class, (DataSerializer)DataSerializers.field_187198_h);
        int[] var10000 = new int[4];
        Block var10003 = Blocks.field_150346_d;
        var10000[0] = Block.func_176210_f((IBlockState)Blocks.field_150346_d.func_176223_P());
        var10003 = Blocks.field_150346_d;
        var10000[1] = Block.func_176210_f((IBlockState)Blocks.field_150346_d.func_176223_P());
        var10003 = Blocks.field_150348_b;
        var10000[2] = Block.func_176210_f((IBlockState)Blocks.field_150348_b.func_176223_P());
        var10003 = Blocks.field_150347_e;
        var10000[3] = Block.func_176210_f((IBlockState)Blocks.field_150347_e.func_176223_P());
        animHandler.addAnim("tektopia", "villager_chop", "guard_m", true);
        animHandler.addAnim("tektopia", "villager_salute", "guard_m", true);
        animHandler.addAnim("tektopia", "villager_craft", "guard_m", false);
        EntityVillagerTek.setupAnimations((AnimationHandler)animHandler, (String)"guard_m");
    }
}

