/*
 * Decompiled with CFR 0.152.
 */
package com.sushiy.tektopiaaddons;

import com.google.common.collect.Maps;
import com.leviathanstudio.craftstudio.client.animation.ClientAnimationHandler;
import com.leviathanstudio.craftstudio.client.model.CSModelBox;
import com.leviathanstudio.craftstudio.client.model.CSModelRenderer;
import com.leviathanstudio.craftstudio.client.model.ModelCraftStudio;
import com.leviathanstudio.craftstudio.common.animation.IAnimated;
import com.sushiy.tektopiaaddons.TektopiaAddons;
import com.sushiy.tektopiaaddons.magistuarmory6.PatternHandlerWrapper;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.common.Loader;
import net.tangotek.tektopia.entities.EntityGuard;
import net.tangotek.tektopia.entities.EntityVillagerTek;

public class LayerVillagerArmorFixed
implements LayerRenderer<EntityLivingBase> {
    private final RenderLivingBase<?> renderer;
    protected static final ResourceLocation ENCHANTED_ITEM_GLINT_RES = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    private static final Map<String, ResourceLocation> ARMOR_TEXTURE_RES_MAP = Maps.newHashMap();
    private float alpha = 1.0f;
    private float colorR = 1.0f;
    private float colorG = 1.0f;
    private float colorB = 1.0f;
    protected ModelCraftStudio modelHead;
    protected ModelCraftStudio modelChest;
    protected ModelCraftStudio modelLegs;
    protected ModelCraftStudio modelFeet;
    protected ModelCraftStudio modelSurcoat;
    boolean noMagistuarmory6 = false;
    private PatternHandlerWrapper p = null;
    private final TileEntityBanner banner = new TileEntityBanner();

    public LayerVillagerArmorFixed(RenderLivingBase<?> rendererIn) {
        this.renderer = rendererIn;
        this.modelHead = new ModelCraftStudio("tektopiaaddons", "armor_head", 64, 32);
        this.modelChest = new ModelCraftStudio("tektopiaaddons", "armor_chest", 64, 32);
        this.modelLegs = new ModelCraftStudio("tektopiaaddons", "armor_leg", 64, 32);
        this.modelFeet = new ModelCraftStudio("tektopiaaddons", "armor_feet", 64, 32);
        this.modelSurcoat = new ModelCraftStudio("tektopiaaddons", "armor_surcoat", 64, 32);
        this.FixArmTexturing();
        if (Loader.isModLoaded((String)"magistuarmory")) {
            try {
                Class<?> clazz = Class.forName("com.magistuarmory.client.renderer.PatternsHandler");
            }
            catch (ClassNotFoundException e) {
                this.noMagistuarmory6 = true;
                TektopiaAddons.LOGGER.info("tektopiaaddons detected magistuarmory version without patternhandler");
                return;
            }
            this.p = new PatternHandlerWrapper();
        }
    }

    private void FixArmTexturing() {
        int texcoordV2;
        int texcoordU2;
        int texcoordU1;
        int texcoordV22;
        int texcoordV1;
        float textureWidth = 64.0f;
        float textureHeight = 32.0f;
        float f = 0.0f / textureWidth;
        float f1 = 0.0f / textureHeight;
        float modelScale = 0.0625f;
        CSModelRenderer rightUpperArm = null;
        CSModelRenderer leftUpperArm = null;
        CSModelRenderer rightLowerArm = null;
        CSModelRenderer leftLowerArm = null;
        for (CSModelRenderer block : this.modelChest.getParentBlocks()) {
            rightUpperArm = this.FindSubmodelWithName("ArmorChestIronArmRight", block);
            leftUpperArm = this.FindSubmodelWithName("ArmorChestIronArmLeft", block);
            rightLowerArm = this.FindSubmodelWithName("ArmorChestIronArmRightLower", block);
            leftLowerArm = this.FindSubmodelWithName("ArmorChestIronArmLeftLower", block);
        }
        if (leftUpperArm != null) {
            int texcoordU12 = 40;
            int texcoordU22 = 44;
            texcoordV1 = 16;
            texcoordV22 = 20;
            CSModelBox leftUpperArmBox = (CSModelBox)leftUpperArm.getCubeCSList().get(0);
            leftUpperArmBox.getQuadList()[2].field_78239_a[0].field_78241_b = (float)texcoordU22 / textureWidth - f;
            leftUpperArmBox.getQuadList()[2].field_78239_a[0].field_78242_c = (float)texcoordV1 / textureHeight + f1;
            leftUpperArmBox.getQuadList()[2].field_78239_a[1].field_78241_b = (float)texcoordU12 / textureWidth + f;
            leftUpperArmBox.getQuadList()[2].field_78239_a[1].field_78242_c = (float)texcoordV1 / textureHeight + f1;
            leftUpperArmBox.getQuadList()[2].field_78239_a[2].field_78241_b = (float)texcoordU12 / textureWidth + f;
            leftUpperArmBox.getQuadList()[2].field_78239_a[2].field_78242_c = (float)texcoordV22 / textureHeight - f1;
            leftUpperArmBox.getQuadList()[2].field_78239_a[3].field_78241_b = (float)texcoordU22 / textureWidth - f;
            leftUpperArmBox.getQuadList()[2].field_78239_a[3].field_78242_c = (float)texcoordV22 / textureHeight - f1;
        }
        if (rightUpperArm != null) {
            int texcoordU13 = 40;
            int texcoordU23 = 44;
            texcoordV1 = 16;
            texcoordV22 = 20;
            CSModelBox rightUpperArmBox = (CSModelBox)rightUpperArm.getCubeCSList().get(0);
            rightUpperArmBox.getQuadList()[2].field_78239_a[0].field_78241_b = (float)texcoordU23 / textureWidth - f;
            rightUpperArmBox.getQuadList()[2].field_78239_a[0].field_78242_c = (float)texcoordV1 / textureHeight + f1;
            rightUpperArmBox.getQuadList()[2].field_78239_a[1].field_78241_b = (float)texcoordU13 / textureWidth + f;
            rightUpperArmBox.getQuadList()[2].field_78239_a[1].field_78242_c = (float)texcoordV1 / textureHeight + f1;
            rightUpperArmBox.getQuadList()[2].field_78239_a[2].field_78241_b = (float)texcoordU13 / textureWidth + f;
            rightUpperArmBox.getQuadList()[2].field_78239_a[2].field_78242_c = (float)texcoordV22 / textureHeight - f1;
            rightUpperArmBox.getQuadList()[2].field_78239_a[3].field_78241_b = (float)texcoordU23 / textureWidth - f;
            rightUpperArmBox.getQuadList()[2].field_78239_a[3].field_78242_c = (float)texcoordV22 / textureHeight - f1;
        }
        if (rightLowerArm != null) {
            int id = 3;
            CSModelBox rightLowerArmBox = (CSModelBox)rightLowerArm.getCubeCSList().get(0);
            texcoordU1 = 48;
            texcoordU2 = 52;
            int texcoordV12 = 16;
            texcoordV2 = 20;
            rightLowerArmBox.getQuadList()[2].field_78239_a[0].field_78241_b = (float)texcoordU2 / textureWidth - f;
            rightLowerArmBox.getQuadList()[2].field_78239_a[0].field_78242_c = (float)texcoordV12 / textureHeight + f1;
            rightLowerArmBox.getQuadList()[2].field_78239_a[1].field_78241_b = (float)texcoordU1 / textureWidth + f;
            rightLowerArmBox.getQuadList()[2].field_78239_a[1].field_78242_c = (float)texcoordV12 / textureHeight + f1;
            rightLowerArmBox.getQuadList()[2].field_78239_a[2].field_78241_b = (float)texcoordU1 / textureWidth + f;
            rightLowerArmBox.getQuadList()[2].field_78239_a[2].field_78242_c = (float)texcoordV2 / textureHeight - f1;
            rightLowerArmBox.getQuadList()[2].field_78239_a[3].field_78241_b = (float)texcoordU2 / textureWidth - f;
            rightLowerArmBox.getQuadList()[2].field_78239_a[3].field_78242_c = (float)texcoordV2 / textureHeight - f1;
            texcoordU1 = 40;
            texcoordU2 = 44;
            texcoordV12 = 16;
            texcoordV2 = 20;
            rightLowerArmBox.getQuadList()[3].field_78239_a[0].field_78241_b = (float)texcoordU2 / textureWidth - f;
            rightLowerArmBox.getQuadList()[3].field_78239_a[0].field_78242_c = (float)texcoordV12 / textureHeight + f1;
            rightLowerArmBox.getQuadList()[3].field_78239_a[1].field_78241_b = (float)texcoordU1 / textureWidth + f;
            rightLowerArmBox.getQuadList()[3].field_78239_a[1].field_78242_c = (float)texcoordV12 / textureHeight + f1;
            rightLowerArmBox.getQuadList()[3].field_78239_a[2].field_78241_b = (float)texcoordU1 / textureWidth + f;
            rightLowerArmBox.getQuadList()[3].field_78239_a[2].field_78242_c = (float)texcoordV2 / textureHeight - f1;
            rightLowerArmBox.getQuadList()[3].field_78239_a[3].field_78241_b = (float)texcoordU2 / textureWidth - f;
            rightLowerArmBox.getQuadList()[3].field_78239_a[3].field_78242_c = (float)texcoordV2 / textureHeight - f1;
        } else {
            TektopiaAddons.LOGGER.info("tektopiaaddons Not Found right lower Arm for UV modification");
        }
        if (leftLowerArm != null) {
            int id = 2;
            CSModelBox leftLowerArmBox = (CSModelBox)leftLowerArm.getCubeCSList().get(0);
            texcoordU1 = 48;
            texcoordU2 = 52;
            int texcoordV13 = 16;
            texcoordV2 = 20;
            leftLowerArmBox.getQuadList()[2].field_78239_a[0].field_78241_b = (float)texcoordU2 / textureWidth - f;
            leftLowerArmBox.getQuadList()[2].field_78239_a[0].field_78242_c = (float)texcoordV13 / textureHeight + f1;
            leftLowerArmBox.getQuadList()[2].field_78239_a[1].field_78241_b = (float)texcoordU1 / textureWidth + f;
            leftLowerArmBox.getQuadList()[2].field_78239_a[1].field_78242_c = (float)texcoordV13 / textureHeight + f1;
            leftLowerArmBox.getQuadList()[2].field_78239_a[2].field_78241_b = (float)texcoordU1 / textureWidth + f;
            leftLowerArmBox.getQuadList()[2].field_78239_a[2].field_78242_c = (float)texcoordV2 / textureHeight - f1;
            leftLowerArmBox.getQuadList()[2].field_78239_a[3].field_78241_b = (float)texcoordU2 / textureWidth - f;
            leftLowerArmBox.getQuadList()[2].field_78239_a[3].field_78242_c = (float)texcoordV2 / textureHeight - f1;
            texcoordU1 = 40;
            texcoordU2 = 44;
            texcoordV13 = 16;
            texcoordV2 = 20;
            leftLowerArmBox.getQuadList()[3].field_78239_a[0].field_78241_b = (float)texcoordU2 / textureWidth - f;
            leftLowerArmBox.getQuadList()[3].field_78239_a[0].field_78242_c = (float)texcoordV13 / textureHeight + f1;
            leftLowerArmBox.getQuadList()[3].field_78239_a[1].field_78241_b = (float)texcoordU1 / textureWidth + f;
            leftLowerArmBox.getQuadList()[3].field_78239_a[1].field_78242_c = (float)texcoordV13 / textureHeight + f1;
            leftLowerArmBox.getQuadList()[3].field_78239_a[2].field_78241_b = (float)texcoordU1 / textureWidth + f;
            leftLowerArmBox.getQuadList()[3].field_78239_a[2].field_78242_c = (float)texcoordV2 / textureHeight - f1;
            leftLowerArmBox.getQuadList()[3].field_78239_a[3].field_78241_b = (float)texcoordU2 / textureWidth - f;
            leftLowerArmBox.getQuadList()[3].field_78239_a[3].field_78242_c = (float)texcoordV2 / textureHeight - f1;
        } else {
            TektopiaAddons.LOGGER.info("tektopiaaddons Not Found left lower Arm for UV modification");
        }
    }

    public CSModelRenderer FindSubmodelWithName(String name, CSModelRenderer block) {
        CSModelRenderer result = null;
        if (block.field_78802_n.equals(name)) {
            result = block;
        } else if (block.field_78805_m != null) {
            for (ModelRenderer child : block.field_78805_m) {
                if (child instanceof CSModelRenderer) {
                    result = this.FindSubmodelWithName(name, (CSModelRenderer)child);
                }
                if (result == null) continue;
                break;
            }
        }
        return result;
    }

    public void func_177141_a(EntityLivingBase entityVillager, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        EntityVillagerTek tekVillager;
        boolean showArmor = true;
        try {
            tekVillager = (EntityVillagerTek)entityVillager;
            showArmor = !((EntityVillagerTek)entityVillager).isSleeping();
        }
        catch (ClassCastException e) {
            throw new RuntimeException(e);
        }
        if (showArmor) {
            this.renderArmorSlot(this.modelHead, (EntityGuard)tekVillager, EntityEquipmentSlot.HEAD, ageInTicks);
            this.renderArmorSlot(this.modelChest, (EntityGuard)tekVillager, EntityEquipmentSlot.CHEST, ageInTicks);
            this.renderArmorSlot(this.modelLegs, (EntityGuard)tekVillager, EntityEquipmentSlot.LEGS, ageInTicks);
            this.renderArmorSlot(this.modelFeet, (EntityGuard)tekVillager, EntityEquipmentSlot.FEET, ageInTicks);
            this.RenderEpicKnightSurcoat(this.modelSurcoat, (EntityGuard)tekVillager, ageInTicks);
        }
    }

    void RenderEpicKnightSurcoat(ModelCraftStudio model, EntityGuard entityGuard, float ageInTicks) {
        if (!Loader.isModLoaded((String)"magistuarmory") || this.noMagistuarmory6) {
            return;
        }
        ItemStack itemStack = entityGuard.func_184582_a(EntityEquipmentSlot.CHEST);
        if (itemStack.func_190926_b()) {
            return;
        }
        if (itemStack.func_77973_b() instanceof ItemArmor) {
            ItemArmor itemArmor = (ItemArmor)itemStack.func_77973_b();
            if (itemStack.func_179543_a("BlockEntityTag") != null) {
                model.func_178686_a(this.renderer.func_177087_b());
                ClientAnimationHandler.performAnimationInModel((List)model.getParentBlocks(), (IAnimated)entityGuard);
                this.banner.func_175112_a(itemStack, true);
                this.renderer.func_110776_a(this.p.getBannerPattern(this.banner.func_175116_e(), this.banner.func_175114_c(), this.banner.func_175110_d()));
                model.render();
            }
        }
    }

    private void renderArmorSlot(ModelCraftStudio model, EntityGuard entityGuard, EntityEquipmentSlot slot, float ageInTicks) {
        ItemArmor itemArmor;
        ItemStack itemStack = entityGuard.func_184582_a(slot);
        if (itemStack.func_190926_b()) {
            return;
        }
        if (itemStack.func_77973_b() instanceof ItemArmor && (itemArmor = (ItemArmor)itemStack.func_77973_b()).func_185083_B_() == slot) {
            model.func_178686_a(this.renderer.func_177087_b());
            ClientAnimationHandler.performAnimationInModel((List)model.getParentBlocks(), (IAnimated)entityGuard);
            this.renderer.func_110776_a(this.getArmorResource((Entity)entityGuard, itemStack, slot, null));
            if (itemArmor.hasOverlay(itemStack)) {
                int i = itemArmor.func_82814_b(itemStack);
                float f = (float)(i >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(i & 0xFF) / 255.0f;
                GlStateManager.func_179131_c((float)(this.colorR * f), (float)(this.colorG * f1), (float)(this.colorB * f2), (float)this.alpha);
                model.render();
                this.renderer.func_110776_a(this.getArmorResource((Entity)entityGuard, itemStack, slot, "overlay"));
            }
            GlStateManager.func_179131_c((float)this.colorR, (float)this.colorG, (float)this.colorB, (float)this.alpha);
            model.render();
            if (itemStack.func_77962_s()) {
                LayerVillagerArmorFixed.renderEnchantedGlint(this.renderer, (EntityLivingBase)entityGuard, model, ageInTicks);
            }
        }
    }

    public static void renderEnchantedGlint(RenderLivingBase<?> renderer, EntityLivingBase entity, ModelCraftStudio model, float ageInTicks) {
        float f = (float)entity.field_70173_aa + ageInTicks;
        renderer.func_110776_a(ENCHANTED_ITEM_GLINT_RES);
        Minecraft.func_71410_x().field_71460_t.func_191514_d(true);
        GlStateManager.func_179147_l();
        GlStateManager.func_179143_c((int)514);
        GlStateManager.func_179132_a((boolean)false);
        float f1 = 0.5f;
        GlStateManager.func_179131_c((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        for (int i = 0; i < 2; ++i) {
            GlStateManager.func_179140_f();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            float f2 = 0.76f;
            GlStateManager.func_179131_c((float)0.38f, (float)0.19f, (float)0.608f, (float)1.0f);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179096_D();
            float f3 = 0.33333334f;
            GlStateManager.func_179152_a((float)0.33333334f, (float)0.33333334f, (float)0.33333334f);
            GlStateManager.func_179114_b((float)(30.0f - (float)i * 60.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)(f * (0.001f + (float)i * 0.003f) * 20.0f), (float)0.0f);
            GlStateManager.func_179128_n((int)5888);
            model.render();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        }
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179096_D();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179145_e();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179084_k();
        Minecraft.func_71410_x().field_71460_t.func_191514_d(false);
    }

    protected ModelBiped getArmorModelHook(EntityLivingBase entity, ItemStack itemStack, EntityEquipmentSlot slot, ModelBiped model) {
        return ForgeHooksClient.getArmorModel((EntityLivingBase)entity, (ItemStack)itemStack, (EntityEquipmentSlot)slot, (ModelBiped)model);
    }

    public boolean func_177142_b() {
        return false;
    }

    private ResourceLocation getDefaultArmorResource(EntityEquipmentSlot slot) {
        if (this.isLegSlot(slot)) {
            return new ResourceLocation("tektopiaaddons", "textures/entity/chainmail_layer_2.png");
        }
        return new ResourceLocation("tektopiaaddons", "textures/entity/chainmail_layer_1.png");
    }

    private ResourceLocation getDefaultArmorResourceHead() {
        return new ResourceLocation("tektopiaaddons", "textures/entity/knight_layer_1.png");
    }

    public ResourceLocation getArmorResource(Entity entity, ItemStack stack, EntityEquipmentSlot slot, String type) {
        ItemArmor item = (ItemArmor)stack.func_77973_b();
        String texture = item.func_82812_d().func_179242_c();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, this.isLegSlot(slot) ? 2 : 1, type == null ? "" : String.format("_%s", type));
        ResourceLocation resourcelocation = ARMOR_TEXTURE_RES_MAP.get(s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EntityEquipmentSlot)slot, (String)type));
        if (resourcelocation == null) {
            TektopiaAddons.LOGGER.info("tektopiaaddons register armor texture " + s1);
            resourcelocation = new ResourceLocation(s1);
            ARMOR_TEXTURE_RES_MAP.put(s1, resourcelocation);
        }
        return resourcelocation;
    }

    private boolean isLegSlot(EntityEquipmentSlot slotIn) {
        return slotIn == EntityEquipmentSlot.LEGS;
    }
}

