/*
 * Decompiled with CFR 0.152.
 */
package com.sushiy.tektopiaaddons;

import com.leviathanstudio.craftstudio.client.registry.CSRegistryHelper;
import com.leviathanstudio.craftstudio.client.registry.CraftStudioLoader;
import com.leviathanstudio.craftstudio.client.util.EnumRenderType;
import com.leviathanstudio.craftstudio.client.util.EnumResourceType;
import com.sushiy.tektopiaaddons.ConfigHandler;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockOre;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemSeedFood;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="tektopiaaddons", name="Tekotpia Addons", version="1.4.5")
public class TektopiaAddons {
    public static final String MODID = "tektopiaaddons";
    public static final String NAME = "Tekotpia Addons";
    public static final String VERSION = "1.4.5";
    public static final Logger LOGGER = LogManager.getLogger((String)"tektopiaaddons");
    public static File config;
    public static HashSet<Item> seedItems;
    public static HashSet<Item> cropItems;
    public static HashSet<BlockCrops> cropBlocks;
    public static HashSet<ItemFood> standardFoodItems;
    public static HashMap<Item, FoodStats> configFoodItems;
    public static HashSet<Item> oreItems;
    public static HashSet<Item> dustItems;
    public static HashSet<Item> gemItems;
    public static HashSet<Item> ingotItems;
    public static HashSet<Block> stoneBlocks;
    public static HashSet<BlockOre> oreBlocks;
    public static HashMap<Block, Integer> oreWeights;
    public static int totalOreWeight;
    public static HashMap<Item, Integer> smithIngotPriority;
    public static HashMap<ItemStack, ItemStack> reverseIngotFurnaceList;

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent preinit) {
        ConfigHandler.registerConfig(preinit);
        OreDictionary.registerOre((String)"cropBeetroot", (Item)Items.field_185164_cV);
    }

    @Mod.EventHandler
    public void postinit(FMLPostInitializationEvent postinit) {
        LOGGER.info("tektopiaaddons Creating item lists");
        Collection items = ForgeRegistries.ITEMS.getValuesCollection();
        LOGGER.info("tektopiaaddons Found " + items.size() + " items");
        seedItems = new HashSet();
        cropItems = new HashSet();
        cropBlocks = new HashSet();
        standardFoodItems = new HashSet();
        oreBlocks = new HashSet();
        oreItems = new HashSet();
        dustItems = new HashSet();
        gemItems = new HashSet();
        ingotItems = new HashSet();
        stoneBlocks = new HashSet();
        oreWeights = new HashMap();
        smithIngotPriority = new HashMap();
        reverseIngotFurnaceList = new HashMap();
        configFoodItems = new HashMap();
        for (String string : ConfigHandler.MODDED_FOOD_CUSTOM_STATS) {
            String string2 = string.replace(" ", "");
            String[] split = string2.split(",");
            if (split.length != 3) {
                LOGGER.info("tektopiaaddons Config food item " + split[0] + "not setup correctly");
                continue;
            }
            String[] item = Item.func_111206_d((String)split[0]);
            if (item != null) {
                configFoodItems.put((Item)item, new FoodStats(Integer.parseInt(split[1]), Integer.parseInt(split[2])));
                continue;
            }
            LOGGER.info("tektopiaaddons Config food item " + split[0] + "does not exist");
        }
        Random rand = new Random();
        for (Item item : items) {
            ItemStack itemStack = new ItemStack(item);
            if (itemStack.func_190926_b()) continue;
            if (Arrays.stream(OreDictionary.getOreIDs((ItemStack)itemStack)).anyMatch(x -> OreDictionary.getOreName((int)x).startsWith("crop"))) {
                cropItems.add(item);
                LOGGER.info("Found Crop: " + item.getRegistryName());
            }
            if (item instanceof ItemSeeds) {
                seedItems.add(item);
                Block b = ((ItemSeeds)item).getPlant(null, null).func_177230_c();
                if (b instanceof BlockCrops) {
                    cropBlocks.add((BlockCrops)b);
                }
            } else if (item instanceof ItemSeedFood) {
                seedItems.add(item);
                cropBlocks.add((BlockCrops)((ItemSeedFood)item).getPlant(null, null).func_177230_c());
            }
            if (item instanceof ItemFood && !configFoodItems.containsKey(item)) {
                standardFoodItems.add((ItemFood)item);
            }
            if (Arrays.stream(OreDictionary.getOreIDs((ItemStack)itemStack)).anyMatch(x -> OreDictionary.getOreName((int)x).startsWith("ore"))) {
                Block block = Block.func_149634_a((Item)item);
                if (block.getRegistryName().func_110623_a().contains("fossil")) continue;
                if (block.func_180660_a(block.func_176223_P(), rand, 0) == item) {
                    oreItems.add(item);
                }
            }
            if (Arrays.stream(OreDictionary.getOreIDs((ItemStack)itemStack)).anyMatch(x -> OreDictionary.getOreName((int)x).startsWith("dust"))) {
                dustItems.add(item);
            }
            if (Arrays.stream(OreDictionary.getOreIDs((ItemStack)itemStack)).anyMatch(x -> OreDictionary.getOreName((int)x).startsWith("gem"))) {
                gemItems.add(item);
            }
            if (!Arrays.stream(OreDictionary.getOreIDs((ItemStack)itemStack)).anyMatch(x -> OreDictionary.getOreName((int)x).startsWith("ingot") && !OreDictionary.getOreName((int)x).startsWith("ingotBrick"))) continue;
            ingotItems.add(item);
        }
        LOGGER.info("Found " + seedItems.size() + " seeds");
        LOGGER.info("Found " + cropItems.size() + " crops");
        LOGGER.info("Found " + standardFoodItems.size() + " foods");
        LOGGER.info("Found " + oreItems.size() + " ores");
        LOGGER.info("Found " + dustItems.size() + " dusts");
        LOGGER.info("Found " + gemItems.size() + " gems");
        LOGGER.info("Found " + ingotItems.size() + " ingots");
        Collection blocks = ForgeRegistries.BLOCKS.getValuesCollection();
        for (Block block : blocks) {
            ItemStack stack = new ItemStack(block);
            if (stack.func_190926_b()) continue;
            if (block instanceof BlockOre && Arrays.stream(OreDictionary.getOreIDs((ItemStack)stack)).anyMatch(x -> OreDictionary.getOreName((int)x).startsWith("ore"))) {
                oreBlocks.add((BlockOre)block);
            }
            if (!Arrays.stream(OreDictionary.getOreIDs((ItemStack)stack)).anyMatch(x -> OreDictionary.getOreName((int)x).startsWith("stone")) && !Arrays.stream(OreDictionary.getOreIDs((ItemStack)stack)).anyMatch(x -> OreDictionary.getOreName((int)x).contains("cobble"))) continue;
            stoneBlocks.add(block);
        }
        LOGGER.info("Found " + oreBlocks.size() + " oreBlocks");
        LOGGER.info("Found " + stoneBlocks.size() + " stones");
        totalOreWeight = 0;
        for (BlockOre blockOre : oreBlocks) {
            int[] ids = OreDictionary.getOreIDs((ItemStack)new ItemStack(Item.func_150898_a((Block)blockOre)));
            for (String s : ConfigHandler.MODDED_ORE_REGROW_CHANCE) {
                String[] split = s.split(":");
                if (Arrays.stream(ids).anyMatch(x -> OreDictionary.getOreName((int)x).contains(split[0]))) {
                    int i = Integer.parseInt(split[1]);
                    oreWeights.put((Block)blockOre, i);
                    totalOreWeight += i;
                    continue;
                }
                oreWeights.put((Block)blockOre, 10);
                totalOreWeight += 10;
            }
        }
        HashMap<String, Integer> priorityStringMap = new HashMap<String, Integer>();
        for (String s : ConfigHandler.MODDED_METAL_SMITH_PRIORITY) {
            String[] split = s.split(":");
            if (split.length != 2) continue;
            try {
                String INPUT = split[0].toLowerCase();
                String metal = INPUT.substring(0, 1).toUpperCase() + INPUT.substring(1);
                priorityStringMap.put(metal, Integer.valueOf(split[1]));
            }
            catch (NumberFormatException e) {
                LOGGER.info("tektopiaaddonssmithing metal priority config has bad entry: {}", (Object)s);
            }
        }
        for (Item ingot : ingotItems) {
            int id = OreDictionary.getOreIDs((ItemStack)new ItemStack(ingot))[0];
            for (String metal : ConfigHandler.MODDED_METAL_SMITH_PRIORITY) {
                if (!OreDictionary.getOreName((int)id).endsWith(metal)) continue;
                smithIngotPriority.put(ingot, (Integer)priorityStringMap.get(metal));
            }
        }
        if (Loader.isModLoaded((String)"magistuarmory")) {
            String string = FMLCommonHandler.instance().findContainerFor((Object)"magistuarmory").getVersion();
            LOGGER.info("magistuarmory " + string + " detected");
        }
    }

    @CraftStudioLoader
    public static void loadStuff() {
        try {
            CSRegistryHelper registry = new CSRegistryHelper(MODID);
            registry.register(EnumResourceType.MODEL, EnumRenderType.ENTITY, "guard_body");
            registry.register(EnumResourceType.MODEL, EnumRenderType.ENTITY, "armor_head");
            registry.register(EnumResourceType.MODEL, EnumRenderType.ENTITY, "armor_chest");
            registry.register(EnumResourceType.MODEL, EnumRenderType.ENTITY, "armor_leg");
            registry.register(EnumResourceType.MODEL, EnumRenderType.ENTITY, "armor_feet");
            registry.register(EnumResourceType.MODEL, EnumRenderType.ENTITY, "armor_surcoat");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isOreBlock(Block block) {
        return block instanceof BlockOre && oreBlocks.contains((BlockOre)block);
    }

    public static boolean isCropBlock(Block block) {
        return block instanceof BlockCrops && cropBlocks.contains((BlockCrops)block);
    }

    public static String getPlantAIFilterName(Block block) {
        String result = "plant_tile.";
        if (block.getRegistryName().func_110624_b().equals("minecraft")) {
            if ((result = result + block.getRegistryName().func_110623_a()).equals("plant_tile.wheat")) {
                result = "plant_tile.crops";
            }
        } else {
            result = result + "modded";
        }
        return result;
    }

    public static String getHarvestAIFilterName(Block block) {
        String result = "harvest_tile.";
        if (block.getRegistryName().func_110624_b().equals("minecraft")) {
            if ((result = result + block.getRegistryName().func_110623_a()).equals("harvest_tile.wheat")) {
                result = "harvest_tile.crops";
            }
        } else {
            result = result + "modded";
        }
        return result;
    }

    public static class FoodStats {
        public int hunger;
        public int happiness;

        public FoodStats(int _hunger, int _happiness) {
            this.hunger = _hunger;
            this.happiness = _happiness;
        }
    }
}

