/*
 * Decompiled with CFR 0.152.
 */
package com.sushiy.tektopiaaddons.mixin;

import com.sushiy.tektopiaaddons.TektopiaAddons;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.tangotek.tektopia.entities.EntityFarmer;
import net.tangotek.tektopia.entities.EntityVillageNavigator;
import net.tangotek.tektopia.entities.EntityVillagerTek;
import net.tangotek.tektopia.entities.ai.EntityAIMoveToBlock;
import net.tangotek.tektopia.entities.ai.EntityAIPlantFarm;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={EntityAIPlantFarm.class})
public abstract class EntityAiPlantFarmMixin
extends EntityAIMoveToBlock {
    @Shadow(remap=false)
    private IBlockState plantState = null;
    @Shadow(remap=false)
    @Final
    protected EntityVillagerTek villager;

    public EntityAiPlantFarmMixin(EntityVillageNavigator v) {
        super(v);
    }

    @Shadow(remap=false)
    private Predicate<BlockPos> isPlantable() {
        return null;
    }

    protected BlockPos getDestinationBlock() {
        BlockPos farmPos = this.villager.getVillage().requestFarmland(this.isPlantable());
        if (farmPos != null) {
            String aiFilter;
            BlockPos cropPos = farmPos.func_177984_a();
            this.plantState = this.checkNearbyCrops(cropPos);
            if (this.plantState != null && this.villager.isAIFilterEnabled(aiFilter = TektopiaAddons.getPlantAIFilterName(this.plantState.func_177230_c()))) {
                Item seedItem = EntityFarmer.getSeed((IBlockState)this.plantState);
                Predicate<ItemStack> seedPred = i -> i.func_77973_b() == seedItem;
                if (this.villager.getInventory().getItemCount(seedPred) >= 1) {
                    return cropPos;
                }
                this.villager.setItemThought(seedItem);
            }
        }
        return null;
    }

    private IBlockState checkNearbyCrops(BlockPos pos) {
        Object bestState = null;
        HashMap<Block, Integer> blocks = new HashMap<Block, Integer>();
        Block west = this.villager.field_70170_p.func_180495_p(pos.func_177976_e()).func_177230_c();
        Block east = this.villager.field_70170_p.func_180495_p(pos.func_177974_f()).func_177230_c();
        Block north = this.villager.field_70170_p.func_180495_p(pos.func_177978_c()).func_177230_c();
        Block south = this.villager.field_70170_p.func_180495_p(pos.func_177968_d()).func_177230_c();
        if (TektopiaAddons.isCropBlock(west)) {
            blocks.merge(west, 1, Integer::sum);
        }
        if (TektopiaAddons.isCropBlock(east)) {
            blocks.merge(east, 1, Integer::sum);
        }
        if (TektopiaAddons.isCropBlock(north)) {
            blocks.merge(north, 1, Integer::sum);
        }
        if (TektopiaAddons.isCropBlock(south)) {
            blocks.merge(south, 1, Integer::sum);
        }
        Map.Entry maxEntry = null;
        for (Map.Entry entry : blocks.entrySet()) {
            if (maxEntry != null && ((Integer)entry.getValue()).compareTo((Integer)maxEntry.getValue()) <= 0) continue;
            maxEntry = entry;
        }
        if (maxEntry != null) {
            return ((Block)maxEntry.getKey()).func_176223_P();
        }
        return null;
    }
}

