/*
 * Decompiled with CFR 0.152.
 */
package com.sushiy.tektopiaaddons.mixin;

import com.sushiy.tektopiaaddons.TektopiaAddons;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.world.World;
import net.tangotek.tektopia.ProfessionType;
import net.tangotek.tektopia.entities.EntityBlacksmith;
import net.tangotek.tektopia.entities.EntityVillagerTek;
import net.tangotek.tektopia.entities.crafting.Recipe;
import net.tangotek.tektopia.storage.ItemDesire;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityBlacksmith.class})
public abstract class EntityBlacksmithMixin
extends EntityVillagerTek {
    @Shadow(remap=false)
    private static List<Recipe> craftSetAnvil;
    @Mutable
    @Unique
    @Final
    private static DataParameter<Boolean> SMELT_MODDED;

    public EntityBlacksmithMixin(World worldIn, ProfessionType profType, int roleMask) {
        super(worldIn, profType, roleMask);
    }

    @Shadow(remap=false)
    protected abstract boolean canVillagerPickupItem(ItemStack var1);

    @Inject(method={"entityInit"}, at={@At(value="TAIL")})
    protected void entityInit(CallbackInfo ci) {
        this.registerAIFilter("smelt_modded", SMELT_MODDED);
    }

    @Inject(method={"<clinit>"}, at={@At(value="TAIL")})
    private static void staticBlock(CallbackInfo ci) {
        SMELT_MODDED = EntityDataManager.func_187226_a(EntityBlacksmith.class, (DataSerializer)DataSerializers.field_187198_h);
    }

    @Inject(method={"initEntityAI"}, at={@At(value="TAIL")})
    protected void initEntityAI(CallbackInfo ci) {
        for (ItemStack input : FurnaceRecipes.func_77602_a().func_77599_b().keySet()) {
            ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(input);
            if (result.func_190926_b() || !TektopiaAddons.oreItems.contains(input.func_77973_b()) && !TektopiaAddons.ingotItems.contains(input.func_77973_b())) continue;
            this.getDesireSet().addItemDesire(new ItemDesire(input.func_77973_b(), 0, 8, 16, x -> x.isAIFilterEnabled("smelt_modded")));
            TektopiaAddons.LOGGER.info("tektopiaaddons added itemdesire for blacksmith " + input.func_77973_b().getRegistryName() + "->" + result.func_77973_b().getRegistryName());
        }
    }

    @Overwrite(remap=false)
    private static Function<ItemStack, Integer> bestSmeltable(EntityVillagerTek villager) {
        return p -> {
            if (villager.isAIFilterEnabled("smelt_modded") && FurnaceRecipes.func_77602_a().func_77599_b().containsKey(p)) {
                ItemStack stack = FurnaceRecipes.func_77602_a().func_151395_a(p);
                if (!stack.func_190926_b() && (TektopiaAddons.oreItems.contains(p.func_77973_b()) || TektopiaAddons.ingotItems.contains(p.func_77973_b()))) {
                    if (TektopiaAddons.smithIngotPriority.containsKey(stack.func_77973_b())) {
                        return TektopiaAddons.smithIngotPriority.get(stack.func_77973_b());
                    }
                    return 1;
                }
                return 0;
            }
            if (p.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150366_p) && villager.isAIFilterEnabled("smelt_iron")) {
                return 3;
            }
            return p.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150366_p) && villager.isAIFilterEnabled("smelt_gold") ? 2 : 0;
        };
    }

    @Overwrite(remap=false)
    protected Predicate<ItemStack> isDeliverable() {
        return p -> craftSetAnvil.stream().anyMatch(e -> ItemStack.func_179545_c((ItemStack)e.getProduct(), (ItemStack)p) || TektopiaAddons.ingotItems.contains(p.func_77973_b()));
    }
}

