/*
 * Decompiled with CFR 0.152.
 */
package com.sushiy.tektopiaaddons.mixin;

import com.sushiy.tektopiaaddons.TektopiaAddons;
import java.util.function.Predicate;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSeedFood;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.tangotek.tektopia.ProfessionType;
import net.tangotek.tektopia.entities.EntityFarmer;
import net.tangotek.tektopia.entities.EntityVillagerTek;
import net.tangotek.tektopia.storage.ItemDesire;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityFarmer.class})
public abstract class EntityFarmerMixin
extends EntityVillagerTek {
    @Mutable
    @Unique
    @Final
    private static DataParameter<Boolean> HARVEST_MODDED;
    @Mutable
    @Unique
    @Final
    private static DataParameter<Boolean> PLANT_MODDED;
    @Shadow(remap=false)
    @Final
    private static DataParameter<Boolean> GATHER_CANE;

    public EntityFarmerMixin(World worldIn, ProfessionType profType, int roleMask) {
        super(worldIn, profType, roleMask);
    }

    @Inject(method={"entityInit"}, at={@At(value="TAIL")})
    protected void entityInit(CallbackInfo ci) {
        this.registerAIFilter("harvest_tile.modded", HARVEST_MODDED);
        this.registerAIFilter("plant_tile.modded", PLANT_MODDED);
    }

    @Inject(method={"initEntityAI"}, at={@At(value="TAIL")})
    protected void initEntityAI(CallbackInfo ci) {
        for (Item item : TektopiaAddons.seedItems) {
            if (ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item).func_110624_b().equals("minecraft")) continue;
            this.getDesireSet().addItemDesire(new ItemDesire(item, 1, 8, 16, p -> p.isAIFilterEnabled("plant_tile.modded")));
        }
        for (Item item : TektopiaAddons.cropItems) {
            if (ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item).func_110624_b().equals("minecraft")) continue;
            if (item instanceof ItemSeedFood) {
                this.getDesireSet().addItemDesire(new ItemDesire(item, 1, 5, 12, p -> p.isAIFilterEnabled("harvest_tile.modded")));
                continue;
            }
            this.getDesireSet().addItemDesire(new ItemDesire(item, 0, 0, 12, p -> p.isAIFilterEnabled("harvest_tile.modded")));
        }
    }

    @Inject(method={"<clinit>"}, at={@At(value="TAIL")})
    private static void staticBlock(CallbackInfo ci) {
        HARVEST_MODDED = EntityDataManager.func_187226_a(EntityFarmer.class, (DataSerializer)DataSerializers.field_187198_h);
        PLANT_MODDED = EntityDataManager.func_187226_a(EntityFarmer.class, (DataSerializer)DataSerializers.field_187198_h);
    }

    @Overwrite(remap=false)
    protected ItemStack modifyPickUpStack(ItemStack itemStack) {
        if (itemStack.func_77973_b() instanceof ItemSeeds && itemStack.func_190916_E() > 1) {
            itemStack.func_190920_e(1);
        } else if (itemStack.func_77973_b() instanceof ItemSeedFood) {
            int skill = this.getSkill(this.getProfessionType());
            if (itemStack.func_190916_E() >= 2 && this.func_70681_au().nextInt(100) > skill) {
                itemStack.func_190920_e(itemStack.func_190916_E() - 1);
            }
        }
        return itemStack;
    }

    @Overwrite(remap=false)
    public static Item getSeed(IBlockState blockState) {
        if (blockState.func_177230_c() instanceof BlockCrops) {
            BlockCrops b = (BlockCrops)blockState.func_177230_c();
            return b.func_185473_a(null, null, blockState).func_77973_b();
        }
        return Items.field_190931_a;
    }

    @Overwrite(remap=false)
    public Predicate<ItemStack> isSeed() {
        return p -> p.func_77973_b() instanceof ItemSeeds || p.func_77973_b() instanceof ItemSeedFood || TektopiaAddons.seedItems.contains(p.func_77973_b());
    }

    @Overwrite(remap=false)
    public Predicate<ItemStack> isHarvestItem() {
        return p -> p.func_77973_b() instanceof ItemSeedFood || TektopiaAddons.cropItems.contains(p.func_77973_b()) || super.isHarvestItem().test(p);
    }
}

