/*
 * Decompiled with CFR 0.152.
 */
package com.sushiy.tektopiaaddons.mixin;

import java.util.Arrays;
import java.util.function.Function;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.tangotek.tektopia.ItemTagType;
import net.tangotek.tektopia.ModItems;
import net.tangotek.tektopia.ProfessionType;
import net.tangotek.tektopia.entities.EntityGuard;
import net.tangotek.tektopia.entities.EntityVillagerTek;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityGuard.class})
public abstract class EntityGuardMixin
extends EntityVillagerTek {
    @Mutable
    @Unique
    @Final
    private static DataParameter<Boolean> EQUIP_AUTOCHANGE_ARMOR;
    @Unique
    @Mutable
    @Final
    private static DataParameter<Boolean> EQUIP_AUTOCHANGE_WEAPON;

    public EntityGuardMixin(World worldIn, ProfessionType profType, int roleMask) {
        super(worldIn, profType, roleMask);
    }

    @Inject(method={"entityInit"}, at={@At(value="TAIL")})
    protected void entityInit(CallbackInfo ci) {
        this.registerAIFilter("equip_autochange.armor", EQUIP_AUTOCHANGE_ARMOR);
        this.registerAIFilter("equip_autochange.weapon", EQUIP_AUTOCHANGE_WEAPON);
    }

    @Inject(method={"<clinit>"}, at={@At(value="TAIL")})
    private static void staticBlock(CallbackInfo ci) {
        EQUIP_AUTOCHANGE_ARMOR = EntityDataManager.func_187226_a(EntityGuard.class, (DataSerializer)DataSerializers.field_187198_h);
        EQUIP_AUTOCHANGE_WEAPON = EntityDataManager.func_187226_a(EntityGuard.class, (DataSerializer)DataSerializers.field_187198_h);
    }

    @Overwrite(remap=false)
    public void equipBestGear() {
        EntityGuard guard = (EntityGuard)this;
        if (this.isAIFilterEnabled("equip_autochange.armor")) {
            this.equipBestGear(EntityEquipmentSlot.CHEST, EntityGuardMixin.getBestArmor(guard, EntityEquipmentSlot.CHEST));
            this.equipBestGear(EntityEquipmentSlot.LEGS, EntityGuardMixin.getBestArmor(guard, EntityEquipmentSlot.LEGS));
            this.equipBestGear(EntityEquipmentSlot.FEET, EntityGuardMixin.getBestArmor(guard, EntityEquipmentSlot.FEET));
            this.equipBestGear(EntityEquipmentSlot.HEAD, EntityGuardMixin.getBestArmor(guard, EntityEquipmentSlot.HEAD));
        }
        if (this.isAIFilterEnabled("equip_autochange.weapon")) {
            this.equipBestGear(EntityEquipmentSlot.MAINHAND, EntityGuardMixin.getBestWeapon(guard));
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        EntityGuard guard = (EntityGuard)this;
        if (itemStack.func_77973_b() instanceof ItemArmor) {
            ItemArmor armor = (ItemArmor)itemStack.func_77973_b();
            ItemStack equippedArmor = guard.func_184582_a(armor.func_185083_B_());
            player.func_184611_a(hand, ItemStack.field_190927_a);
            this.func_184201_a(armor.func_185083_B_(), itemStack);
            if (!equippedArmor.func_190926_b()) {
                player.func_184611_a(hand, equippedArmor);
            }
            this.setAIFilter("equip_autochange.armor", false);
            return true;
        }
        if (itemStack.func_77973_b() instanceof ItemSword) {
            ItemSword newWeapon = (ItemSword)itemStack.func_77973_b();
            ItemStack oldWeapon = guard.func_184614_ca();
            player.func_184611_a(hand, ItemStack.field_190927_a);
            this.func_184611_a(EnumHand.MAIN_HAND, itemStack);
            if (!oldWeapon.func_190926_b()) {
                player.func_184611_a(hand, oldWeapon);
            }
            this.setAIFilter("equip_autochange.weapon", false);
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    @Overwrite(remap=false)
    public static Function<ItemStack, Integer> getBestWeapon(EntityGuard guard) {
        return p -> {
            if (!guard.isAIFilterEnabled("equip_autochange.weapon")) {
                return p == guard.func_184614_ca() ? 100 : -1;
            }
            if (p.func_77973_b() instanceof ItemSword) {
                ItemSword sword = (ItemSword)p.func_77973_b();
                if (p.func_77948_v() && !guard.isAIFilterEnabled("equip_enchanted_sword")) {
                    return -1;
                }
                if (sword.func_150932_j().equals(Item.ToolMaterial.DIAMOND.name()) && !guard.isAIFilterEnabled("equip_diamond_sword")) {
                    return -1;
                }
                if (sword.func_150932_j().equals(Item.ToolMaterial.IRON.name()) && !guard.isAIFilterEnabled("equip_iron_sword")) {
                    return -1;
                }
                int score = (int)sword.func_150931_i();
                score = (int)((float)score + EnchantmentHelper.func_152377_a((ItemStack)p, (EnumCreatureAttribute)EnumCreatureAttribute.UNDEFINED));
                ++score;
                score *= 10;
                if (ModItems.isTaggedItem((ItemStack)p, (ItemTagType)ItemTagType.VILLAGER)) {
                    ++score;
                }
                return score;
            }
            return -1;
        };
    }

    @Overwrite(remap=false)
    public static Function<ItemStack, Integer> getBestArmor(EntityGuard guard, EntityEquipmentSlot slot) {
        return p -> {
            if (!guard.isAIFilterEnabled("equip_autochange.armor")) {
                return p == guard.func_184582_a(slot) ? 100 : -1;
            }
            if (p.func_77973_b() instanceof ItemArmor) {
                ItemArmor armor = (ItemArmor)p.func_77973_b();
                if (armor.field_77881_a == slot) {
                    if (p.func_77948_v() && !guard.isAIFilterEnabled("equip_enchanted_armor")) {
                        return -1;
                    }
                    if (armor.func_82812_d() == ItemArmor.ArmorMaterial.DIAMOND && !guard.isAIFilterEnabled("equip_diamond_armor")) {
                        return -1;
                    }
                    if (armor.func_82812_d() == ItemArmor.ArmorMaterial.IRON && !guard.isAIFilterEnabled("equip_iron_armor")) {
                        return -1;
                    }
                    if (armor.func_82812_d() == ItemArmor.ArmorMaterial.LEATHER && !guard.isAIFilterEnabled("equip_leather_armor")) {
                        return -1;
                    }
                    int score = armor.func_82812_d().func_78044_b(armor.field_77881_a);
                    return score += EnchantmentHelper.func_77508_a(Arrays.asList(p), (DamageSource)DamageSource.field_76377_j);
                }
            }
            return -1;
        };
    }
}

