/*
 * Decompiled with CFR 0.152.
 */
package com.sushiy.tektopiaaddons.mixin;

import com.sushiy.tektopiaaddons.TektopiaAddons;
import java.util.Arrays;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.tangotek.tektopia.ProfessionType;
import net.tangotek.tektopia.entities.EntityMiner;
import net.tangotek.tektopia.entities.EntityVillagerTek;
import net.tangotek.tektopia.storage.ItemDesire;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityMiner.class})
public abstract class EntityMinerMixin
extends EntityVillagerTek {
    @Mutable
    @Unique
    @Final
    private static DataParameter<Boolean> MINE_STONE;

    public EntityMinerMixin(World worldIn, ProfessionType profType, int roleMask) {
        super(worldIn, profType, roleMask);
    }

    @Unique
    public Predicate<ItemStack> tektopiaAddons$isStoneItem() {
        return p -> TektopiaAddons.stoneBlocks.contains(Block.func_149634_a((Item)p.func_77973_b()));
    }

    @Overwrite(remap=false)
    public Predicate<ItemStack> isHarvestItem() {
        return p -> Arrays.stream(OreDictionary.getOreIDs((ItemStack)p)).anyMatch(x -> OreDictionary.getOreName((int)x).startsWith("ore")) || Arrays.stream(OreDictionary.getOreIDs((ItemStack)p)).anyMatch(y -> OreDictionary.getOreName((int)y).startsWith("gem")) || Arrays.stream(OreDictionary.getOreIDs((ItemStack)p)).anyMatch(z -> OreDictionary.getOreName((int)z).startsWith("dust")) || this.tektopiaAddons$isStoneItem().test((ItemStack)p) || super.isHarvestItem().test(p);
    }

    @Inject(method={"entityInit"}, at={@At(value="TAIL")}, remap=false)
    protected void entityInit(CallbackInfo ci) {
        this.registerAIFilter("mining.stone", MINE_STONE);
    }

    @Inject(method={"initEntityAI"}, at={@At(value="TAIL")}, remap=false)
    protected void initEntityAI(CallbackInfo ci) {
        for (Item item : TektopiaAddons.oreItems) {
            if (ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item).func_110624_b().equals("minecraft")) continue;
            this.getDesireSet().addItemDesire(new ItemDesire(item, 0, 0, 8, (Predicate)null));
        }
        for (Item item : TektopiaAddons.dustItems) {
            if (ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item).func_110624_b().equals("minecraft")) continue;
            this.getDesireSet().addItemDesire(new ItemDesire(item, 0, 0, 16, (Predicate)null));
        }
        for (Item item : TektopiaAddons.gemItems) {
            if (ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item).func_110624_b().equals("minecraft")) continue;
            this.getDesireSet().addItemDesire(new ItemDesire(item, 0, 0, 5, (Predicate)null));
        }
        for (Block block : TektopiaAddons.stoneBlocks) {
            this.getDesireSet().addItemDesire(new ItemDesire(Item.func_150898_a((Block)block), 1, 10, 64, (Predicate)null));
        }
    }

    @Inject(method={"<clinit>"}, at={@At(value="TAIL")})
    private static void staticBlock(CallbackInfo ci) {
        MINE_STONE = EntityDataManager.func_187226_a(EntityMiner.class, (DataSerializer)DataSerializers.field_187198_h);
    }
}

