/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.client.gui.widget.button;

import com.github.tartaricacid.touhoulittlemaid.util.TipsHelper;
import com.github.wallev.maidsoulkitchen.api.task.cook.ICookTask;
import com.github.wallev.maidsoulkitchen.client.gui.widget.button.NormalTooltipButton;
import com.github.wallev.maidsoulkitchen.entity.data.inner.task.cook.v1.KitchenData;
import com.github.wallev.maidsoulkitchen.task.cook.common.task.CookTaskManager;
import com.github.wallev.maidsoulkitchen.vhelper.client.chat.VComponent;
import com.github.wallev.maidsoulkitchen.vhelper.client.resources.VResourceLocation;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TaskInfoButton
extends NormalTooltipButton {
    private static final ResourceLocation TEXTURE = VResourceLocation.create("maidsoulkitchen", "textures/gui/cook_guide.png");
    private final ICookTask<?, ?> cookTask;
    private final boolean isIdle;

    public TaskInfoButton(int pX, int pY, int pWidth, int pHeight, ICookTask<?, ?> cookTask, KitchenData kitchenData, Button.OnPress pOnPress) {
        super(pX, pY, pWidth, pHeight, (Component)cookTask.getName(), TaskInfoButton.getDesc(cookTask), pOnPress);
        this.cookTask = cookTask;
        this.isIdle = kitchenData.getCookName().equals((Object)CookTaskManager.getIdleTask().getUid());
    }

    public static List<Component> getDesc(ICookTask<?, ?> task) {
        ArrayList<Component> components = new ArrayList<Component>();
        components.add((Component)VComponent.translatable("gui.maidsoulkitchen.widget.cook_guide.task.desc", task.getName()));
        String typeString = task.getRecipeTypeId();
        components.add(CommonComponents.f_263701_);
        components.add((Component)VComponent.translatable("gui.maidsoulkitchen.widget.cook_guide.task.recipe_type", typeString).m_130940_(ChatFormatting.DARK_GRAY));
        return components;
    }

    protected void m_87963_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        Minecraft mc = Minecraft.m_91087_();
        pGuiGraphics.m_280218_(TEXTURE, this.m_252754_(), this.m_252907_(), 179, 2, this.f_93618_, this.f_93619_);
        pGuiGraphics.m_280480_(this.cookTask.getIcon(), this.m_252754_() + 2, this.m_252907_() + 2);
        List splitTexts = mc.f_91062_.m_92923_((FormattedText)this.cookTask.getName(), 42);
        if (!splitTexts.isEmpty()) {
            pGuiGraphics.m_280649_(mc.f_91062_, (FormattedCharSequence)splitTexts.get(0), this.m_252754_() + 22, this.m_252907_() + 5, 0xFFFFFF, false);
        }
        if (this.isIdle) {
            TipsHelper.renderTips((GuiGraphics)pGuiGraphics, (Button)this, (Component)Component.m_237115_((String)"gui.maidsoulkitchen.widget.cook_guide.task.choose_cook_type"));
        }
    }

    protected void renderScrollingTaskString(GuiGraphics pGuiGraphics, Font pFont, int x, int y, int pWidth, int pColor) {
        Component component = this.m_6035_();
        Objects.requireNonNull(pFont);
        TaskInfoButton.m_280138_((GuiGraphics)pGuiGraphics, (Font)pFont, (Component)component, (int)x, (int)y, (int)(x + pWidth), (int)(y + 9), (int)pColor);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }
}

