/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.compat.msm.common.craft.util;

import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskClassAnalyzer;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskInfo;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import studio.fantasyit.maid_storage_manager.craft.action.ActionOption;
import studio.fantasyit.maid_storage_manager.craft.action.ActionOptionSet;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;

@TaskClassAnalyzer(value=TaskInfo.MSM_CORE)
public record FailCraftGuideStepData(List<CraftGuideStepData> steps) {
    public static final Codec<FailCraftGuideStepData> CODEC = RecordCodecBuilder.create((T ins) -> ins.group((App)CraftGuideStepData.CODEC.listOf().fieldOf("fail_steps").forGetter(FailCraftGuideStepData::steps)).apply((Applicative)ins, FailCraftGuideStepData::new));

    public FailCraftGuideStepData(CraftGuideStepData ... steps) {
        this(Arrays.stream(steps).toList());
    }

    public FailCraftGuideStepData(List<CraftGuideStepData> steps) {
        this.steps = steps;
        this.checkAndMakeOptionalSteps();
    }

    private void checkAndMakeOptionalSteps() {
        for (CraftGuideStepData step : this.steps) {
            ActionOption optionalAction = ActionOption.OPTIONAL;
            if (step.actionType.options().stream().noneMatch(o -> o.equals((Object)optionalAction))) continue;
            step.getOptionSelection(optionalAction).ifPresentOrElse(existOptional -> {
                if (!existOptional.booleanValue()) {
                    ActionOptionSet.with((ActionOption)optionalAction, (Object)true).applyTo(step);
                }
            }, () -> ActionOptionSet.with((ActionOption)optionalAction, (Object)true).applyTo(step));
        }
    }

    public CompoundTag toCompoundTag() {
        return CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this).result().map(tag -> (CompoundTag)tag).orElseGet(CompoundTag::new);
    }

    public static CompoundTag toCompoundTag(FailCraftGuideStepData failCraftGuideStepData) {
        return failCraftGuideStepData.toCompoundTag();
    }

    public static CompoundTag toCompoundTag(List<CraftGuideStepData> steps) {
        return FailCraftGuideStepData.toCompoundTag(new FailCraftGuideStepData(steps));
    }

    public static CompoundTag toCompoundTag(CraftGuideStepData ... steps) {
        return FailCraftGuideStepData.toCompoundTag(new FailCraftGuideStepData(steps));
    }

    public static FailCraftGuideStepData toFailSteps(CompoundTag compoundTag) {
        return CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)compoundTag).result().orElse(new FailCraftGuideStepData(new CraftGuideStepData[0]));
    }

    public static FailCraftGuideStepData create(List<CraftGuideStepData> steps) {
        return new FailCraftGuideStepData(steps);
    }

    public static FailCraftGuideStepData create(CraftGuideStepData ... steps) {
        return new FailCraftGuideStepData(steps);
    }
}

