/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.compat.msm.tea_aroma.util;

import cn.foggyhillside.tea_aroma.blocks.states.KettleLiquid;
import cn.foggyhillside.tea_aroma.items.KettleItem;
import cn.foggyhillside.tea_aroma.registry.ModTags;
import com.github.wallev.maidsoulkitchen.mixin.compat.tea_aroma.KettleItemAccessor;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;

public class TeaBrewingFoamHelper {
    public static Ingredient createNeedBoilingWaterKettle() {
        return TeaBrewingFoamHelper.createNeedBoilingWaterKettle(TeaBrewingFoamHelper::getNeedBoilingWaterKettle);
    }

    public static Ingredient createNeedBoilingMilkKettle() {
        return TeaBrewingFoamHelper.createNeedBoilingWaterKettle(TeaBrewingFoamHelper::getNeedBoilingMilkKettle);
    }

    private static Ingredient createNeedBoilingWaterKettle(Supplier<ItemStack> kettle) {
        int minBoil = TeaBrewingFoamHelper.getBoil();
        Stream<ItemStack> kettlesStream = IntStream.range(0, minBoil).boxed().map(progress -> {
            ItemStack defaultInstance = (ItemStack)kettle.get();
            TeaBrewingFoamHelper.setStackBoilProgress(defaultInstance, progress);
            return defaultInstance;
        });
        return Ingredient.m_43921_(kettlesStream);
    }

    public static Ingredient getWaters() {
        Stream<ItemStack> modTagsWaterStream = Arrays.stream(Ingredient.m_204132_((TagKey)ModTags.WATER).m_43908_());
        ItemStack waterPotion = Items.f_42589_.m_7968_();
        PotionUtils.m_43549_((ItemStack)waterPotion, (Potion)Potions.f_43599_);
        Stream<ItemStack> allWaters = Stream.concat(modTagsWaterStream, Stream.of(waterPotion));
        return Ingredient.m_43921_(allWaters);
    }

    public static LiquidType forLiquidType(String liquidType) {
        return LiquidType.valueOf(liquidType.toUpperCase(Locale.ENGLISH));
    }

    public static Ingredient forLiquidIngredient(String liquidType) {
        return TeaBrewingFoamHelper.forLiquidType(liquidType).getIngredient();
    }

    public static Ingredient waterLiquidIngredient() {
        return LiquidType.BOILING_WATER.getIngredient();
    }

    public static Ingredient milkLiquidIngredient() {
        return LiquidType.BOILING_MILK.getIngredient();
    }

    public static ItemStack leftTeaFluidBase(ItemStack teaBase) {
        int amount = KettleItem.getStackAmount((ItemStack)teaBase);
        amount = Math.max(0, amount - 1);
        KettleItem.setStackAmount((ItemStack)teaBase, (int)amount);
        if (amount == 0) {
            KettleItem.setStackLiquid((ItemStack)teaBase, (String)KettleLiquid.NONE.toString());
        }
        return teaBase;
    }

    public static void setStackBoilProgress(ItemStack stack, int boilProgress) {
        KettleItemAccessor.msk$setStackBoilProgress(stack, boilProgress);
    }

    public static int getStackBoilProgress(ItemStack stack) {
        return KettleItemAccessor.msk$getStackBoilProgress(stack);
    }

    public static ItemStack getNeedBoilingMilkKettle() {
        ItemStack boilingMilkKettle = KettleItem.getBoilingMilkKettle();
        TeaBrewingFoamHelper.setStackBoilProgress(boilingMilkKettle, 0);
        KettleItem.setStackLiquid((ItemStack)boilingMilkKettle, (String)KettleLiquid.MILK.toString());
        return boilingMilkKettle;
    }

    public static ItemStack getNeedBoilingWaterKettle() {
        ItemStack boilingWaterKettle = KettleItem.getBoilingWaterKettle();
        TeaBrewingFoamHelper.setStackBoilProgress(boilingWaterKettle, 0);
        KettleItem.setStackLiquid((ItemStack)boilingWaterKettle, (String)KettleLiquid.WATER.toString());
        return boilingWaterKettle;
    }

    public static ItemStack getEmptyBoilingKettle() {
        return KettleItem.getEmptyKettle();
    }

    public static int getBoil() {
        return KettleItemAccessor.msk$getBoil();
    }

    public static int getMaxProgress() {
        return KettleItemAccessor.msk$getMaxProgress();
    }

    public static enum LiquidType {
        BOILING_WATER,
        BOILING_MILK;


        public Ingredient getIngredient() {
            Stream kettlesStream = IntStream.range(1, 4).boxed().flatMap(i -> {
                int min = TeaBrewingFoamHelper.getBoil();
                int max = TeaBrewingFoamHelper.getMaxProgress();
                return IntStream.range(min, max + 1).boxed().map(progress -> {
                    ItemStack defaultInstance = KettleItem.getBoilingWaterKettle();
                    KettleItem.setStackLiquid((ItemStack)defaultInstance, (String)this.toString());
                    KettleItem.setStackAmount((ItemStack)defaultInstance, (int)i);
                    TeaBrewingFoamHelper.setStackBoilProgress(defaultInstance, progress);
                    return defaultInstance;
                });
            });
            return Ingredient.m_43921_(kettlesStream);
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

