/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.modclazzchecker.core.util;

import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.jetbrains.annotations.Nullable;

public class ModUtil {
    public static boolean isInstalled(String modId) {
        ModList modList = ModList.get();
        if (modList != null) {
            return modList.isLoaded(modId);
        }
        return LoadingModList.get().getModFileById(modId) != null;
    }

    public static boolean isInstalled(String modId, String spec) {
        try {
            String modVersion = ModUtil.getModVersion(modId);
            if (modVersion.isEmpty()) {
                return false;
            }
            DefaultArtifactVersion version = new DefaultArtifactVersion(modVersion);
            VersionRange versionRange = VersionRange.createFromVersionSpec((String)spec);
            return versionRange.containsVersion((ArtifactVersion)version);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getModName(String modId) {
        IModInfo modInfo = ModUtil.getModInfo(modId);
        return modInfo != null ? modInfo.getDisplayName() : "";
    }

    @Nullable
    public static IModInfo getModInfo(String modId) {
        ModList modList = ModList.get();
        if (modList != null) {
            ModContainer modContainer = modList.getModContainerById(modId).orElse(null);
            if (modContainer != null) {
                return modContainer.getModInfo();
            }
        } else {
            ModFileInfo modFileById = LoadingModList.get().getModFileById(modId);
            if (modFileById != null) {
                return (IModInfo)modFileById.getMods().get(0);
            }
        }
        return null;
    }

    public static String getModVersion(String modId) {
        ArtifactVersion version = null;
        ModList modList = ModList.get();
        if (modList != null) {
            ModContainer modContainer = modList.getModContainerById(modId).orElse(null);
            if (modContainer == null) {
                return "";
            }
            version = modContainer.getModInfo().getVersion();
        } else {
            ModFileInfo modFileById = LoadingModList.get().getModFileById(modId);
            if (modFileById != null) {
                version = ((IModInfo)modFileById.getMods().get(0)).getVersion();
            }
        }
        if (version == null) {
            return "";
        }
        if (version.getQualifier() != null) {
            version = new DefaultArtifactVersion(version.getQualifier());
        }
        return version.toString();
    }
}

