/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.barbequesdelight.basin;

import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskClassAnalyzer;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskInfo;
import com.github.wallev.maidsoulkitchen.task.cook.common.cook.be.CookBeBase;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.item.ItemDefinition;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.item.ItemInventory;
import com.github.wallev.maidsoulkitchen.task.cook.common.manager.MaidCookManager;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.cook.TickCookRule;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.MaidItem;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.MaidRec;
import com.mao.barbequesdelight.content.block.BasinBlockEntity;
import com.mao.barbequesdelight.content.recipe.SkeweringRecipe;
import com.mao.barbequesdelight.init.registrate.BBQDRecipes;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

@TaskClassAnalyzer(value=TaskInfo.BD_BASIN)
public class BasinCookRule
extends TickCookRule<BasinBlockEntity, SkeweringRecipe<?>> {
    private static final BasinCookRule INSTANCE = new BasinCookRule();
    private ItemStack container = ItemStack.f_41583_;
    private ItemStack tool = ItemStack.f_41583_;
    private ItemStack side = ItemStack.f_41583_;

    public static BasinCookRule getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean canMoveTo(CookBeBase<BasinBlockEntity> cookBeBase, MaidCookManager<SkeweringRecipe<?>> cm) {
        return cm.hasMaidRecs(cookBeBase);
    }

    @Override
    public void cookMake(CookBeBase<BasinBlockEntity> cookBeBase, MaidCookManager<SkeweringRecipe<?>> cm) {
        this.init(cookBeBase, cm);
        IItemHandlerModifiable inputInv = cm.getInputInv();
        BasinBlockEntity be = cookBeBase.getBe();
        MaidRec maidRec = cm.pollMaidRec(cookBeBase);
        Map<ItemDefinition, LinkedList<ItemStack>> invIngredients = cm.getInvIngredients();
        List<MaidItem> maidItems = maidRec.maidItems();
        MaidItem container = maidItems.get(1);
        ItemDefinition containerItem = container.item();
        int containerAmount = container.count();
        for (ItemStack itemStack : invIngredients.get(containerItem)) {
            ItemStack leftInsertedStack;
            ItemStack copy;
            if (itemStack.m_41619_()) continue;
            int count = itemStack.m_41613_();
            if (count >= containerAmount) {
                copy = itemStack.m_255036_(containerAmount);
                leftInsertedStack = be.items.m_19173_(copy);
                itemStack.m_41774_(containerAmount - leftInsertedStack.m_41613_());
                break;
            }
            copy = itemStack.m_41777_();
            leftInsertedStack = be.items.m_19173_(copy);
            itemStack.m_41774_(containerAmount - leftInsertedStack.m_41613_());
            if ((containerAmount -= count) > 0) continue;
            break;
        }
        this.container = be.items.m_8020_(0);
        ItemInventory itemInventory = cm.getItemInventory();
        MaidItem tool = maidItems.get(0);
        ItemStack toolItem = this.contItemStack(tool, itemInventory);
        this.swapItem(InteractionHand.MAIN_HAND, toolItem, this.maid, (IItemHandler)inputInv);
        this.tool = this.maid.m_21120_(InteractionHand.MAIN_HAND);
        if (maidItems.size() > 2) {
            MaidItem side = maidItems.get(2);
            ItemStack sideItem = this.contItemStack(side, itemInventory);
            this.swapItem(InteractionHand.OFF_HAND, sideItem, this.maid, (IItemHandler)inputInv);
            this.side = this.maid.m_21120_(InteractionHand.OFF_HAND);
        }
        cm.getItemInventory().markDirty();
    }

    @Override
    public void tickCookMake(CookBeBase<BasinBlockEntity> cookBeBase, MaidCookManager<SkeweringRecipe<?>> cm) {
        if (this.tick++ % 5 != 0) {
            return;
        }
        Level worldIn = ((BasinBlockEntity)this.be).m_58904_();
        IItemHandlerModifiable outputInv = cm.getOutputInv();
        SimpleContainer cont = new SimpleContainer(new ItemStack[]{this.tool, this.container, this.side});
        Optional optional = worldIn.m_7465_().m_44015_((RecipeType)BBQDRecipes.RT_SKR.get(), (Container)cont, worldIn);
        if (optional.isEmpty()) {
            this.stop();
            return;
        }
        SkeweringRecipe recipe = (SkeweringRecipe)optional.get();
        ItemStack ret = recipe.m_5874_((Container)cont, worldIn.m_9598_());
        ItemHandlerHelper.insertItemStacked((IItemHandler)outputInv, (ItemStack)ret, (boolean)false);
        this.maid.m_6674_(InteractionHand.MAIN_HAND);
    }

    @Override
    public void tickStop(CookBeBase<BasinBlockEntity> cookBeBase, MaidCookManager<SkeweringRecipe<?>> cm) {
        super.tickStop(cookBeBase, cm);
        this.tool = ItemStack.f_41583_;
        this.container = ItemStack.f_41583_;
        this.side = ItemStack.f_41583_;
    }

    @Override
    protected TickCookRule<BasinBlockEntity, SkeweringRecipe<?>> create() {
        return new BasinCookRule();
    }
}

