/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.common.inv.maid;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.maidsoulkitchen.inventory.container.item.BagType;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.maid.IMaidCookInventory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class MaidInventory
extends IMaidCookInventory {
    private final Map<Item, Integer> inventoryItem = new HashMap<Item, Integer>();
    private final Map<Item, List<ItemStack>> inventoryStack = new HashMap<Item, List<ItemStack>>();
    private final List<ItemStack> lastInvStack = new ArrayList<ItemStack>();
    private CombinedInvWrapper inv;

    public MaidInventory(EntityMaid maid) {
        super(maid);
        this.initInvData();
    }

    @Override
    protected void initInvData() {
        this.inv = this.maid.getAvailableInv(true);
    }

    @Override
    public void refreshInv() {
        this.clearCacheStackInfo();
        this.initInvData();
        for (int i = 0; i < this.inv.getSlots(); ++i) {
            ItemStack stack = this.inv.getStackInSlot(i);
            this.proseLastInvStack(i, stack);
            if (stack.m_41619_()) continue;
            this.add(stack);
            this.itemInventory.add(stack);
        }
    }

    @Override
    protected void proseLastInvStack(int index, ItemStack invStack) {
        ItemStack cacheStack;
        if (index < this.lastInvStack.size() && (cacheStack = this.lastInvStack.get(index)).m_150930_(invStack.m_41720_()) && cacheStack != invStack) {
            cacheStack.m_41764_(invStack.m_41613_());
            return;
        }
        this.lastInvStack.add(invStack.m_41777_());
    }

    @Override
    protected void clearCacheStackInfo() {
        this.itemInventory.clear();
        this.inventoryItem.clear();
        this.inventoryStack.clear();
        this.lastInvStack.clear();
    }

    @Override
    protected void add(ItemStack stack) {
        if (!stack.m_41619_()) {
            Item item = stack.m_41720_();
            if (this.inventoryStack.get(item) == null) {
                ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
                stackList.add(stack);
                this.inventoryStack.put(item, stackList);
            } else {
                this.inventoryStack.get(item).add(stack);
            }
            this.inventoryItem.merge(item, stack.m_41613_(), (a, b) -> a + b);
        }
    }

    @Override
    public Map<Item, List<ItemStack>> getInventoryStack() {
        return this.inventoryStack;
    }

    @Override
    public Map<Item, Integer> getInventoryItem() {
        return this.inventoryItem;
    }

    @Override
    public List<ItemStack> getLastInvStack() {
        return this.lastInvStack;
    }

    @Override
    public IItemHandlerModifiable getAvailableInv(BagType bagType) {
        return this.inv;
    }

    @Override
    public IItemHandlerModifiable getInputInv() {
        return this.inv;
    }

    @Override
    public IItemHandlerModifiable getOutputInv() {
        return this.inv;
    }

    @Override
    public void syncInv() {
        this.calcAvailableSlots();
    }
}

