/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.common.rule.cook;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.maidsoulkitchen.task.cook.common.cook.be.CookBeBase;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.item.ItemDefinition;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.item.ItemInventory;
import com.github.wallev.maidsoulkitchen.task.cook.common.manager.MaidCookManager;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.cook.AbstractCookRule;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.MaidItem;
import com.github.wallev.maidsoulkitchen.util.fakeplayer.WrappedMaidFakePlayer;
import java.util.LinkedList;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class TickCookRule<B extends BlockEntity, R extends Recipe<? extends Container>>
extends AbstractCookRule<B, R> {
    protected EntityMaid maid;
    protected WrappedMaidFakePlayer player;
    protected B be;
    protected BlockPos pos;
    protected ItemStack kitchenToolInHand = ItemStack.f_41583_;
    protected final ItemStack kitchenTool;
    protected final Item kitchenToolItem;
    private boolean end = false;
    protected int tick = 0;

    protected TickCookRule(ItemStack kitchenTool) {
        this.kitchenTool = kitchenTool;
        this.kitchenToolItem = kitchenTool.m_41720_();
    }

    protected TickCookRule(Item kitchenTool) {
        this(kitchenTool.m_7968_());
    }

    protected TickCookRule() {
        this(ItemStack.f_41583_);
    }

    @Override
    public boolean tickCan(CookBeBase<B> cookBeBase, MaidCookManager<R> cm) {
        return this.be != null && !this.end;
    }

    @Override
    public void tickStop(CookBeBase<B> cookBeBase, MaidCookManager<R> cm) {
        this.clear(cookBeBase, cm);
    }

    @Override
    public final TickCookRule<B, R> getOrCreate() {
        return this.create();
    }

    protected abstract TickCookRule<B, R> create();

    public ItemStack swapItem(InteractionHand hand, ItemStack itemStack, EntityMaid maid, IItemHandler inv) {
        ItemStack itemInHand = maid.m_21120_(hand);
        if (itemInHand.m_150930_(itemStack.m_41720_())) {
            return itemInHand;
        }
        ItemStack swapItemCopy = itemStack.m_278832_();
        maid.m_21008_(hand, swapItemCopy);
        ItemStack leftStack = ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)itemInHand, (boolean)false);
        if (!leftStack.m_41619_()) {
            maid.f_19853_.m_7967_((Entity)new ItemEntity(maid.f_19853_, maid.m_20185_(), maid.m_20186_(), maid.m_20189_(), leftStack));
        }
        return swapItemCopy;
    }

    public void swapTool(ItemStack tool, ItemInventory itemInventory, EntityMaid maid, IItemHandler inv) {
        ItemStack copyAndClear = tool.m_278832_();
        ItemStack leftStack = ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)copyAndClear, (boolean)false);
        if (leftStack.m_41619_()) {
            itemInventory.getStacks().merge(ItemDefinition.of(tool), 1L, (a, b) -> a - b);
            itemInventory.add(copyAndClear);
        } else {
            maid.f_19853_.m_7967_((Entity)new ItemEntity(maid.f_19853_, maid.m_20185_(), maid.m_20186_(), maid.m_20189_(), leftStack));
        }
    }

    public void backpackTool(CookBeBase<B> cookBeBase, MaidCookManager<R> cm) {
        if (!this.kitchenToolInHand.m_150930_(this.kitchenTool.m_41720_())) {
            return;
        }
        this.swapTool(this.kitchenToolInHand, cm.getItemInventory(), cm.getMaid(), (IItemHandler)cm.getInputInv());
    }

    public ItemStack swapTool(ItemStack toolItemStack, ItemInventory itemInventory, EntityMaid maid, InteractionHand hand, IItemHandler inv) {
        ItemStack itemInHand = maid.m_21120_(hand);
        if (itemInHand.m_150930_(toolItemStack.m_41720_())) {
            return itemInHand;
        }
        LinkedList<ItemStack> toolStacks = itemInventory.getItemStacks(toolItemStack);
        LinkedList<ItemStack> toolStacks0 = itemInventory.getItemStacks(ItemDefinition.of(toolItemStack));
        if (toolStacks.isEmpty()) {
            return ItemStack.f_41583_;
        }
        while (toolStacks0.peek().m_41619_()) {
            toolStacks0.poll();
        }
        while (toolStacks.peek().m_41619_()) {
            toolStacks.poll();
        }
        ItemStack swapItemCopy = toolStacks.peek().m_278832_();
        maid.m_21008_(hand, swapItemCopy);
        ItemStack leftStack = ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)itemInHand, (boolean)false);
        if (!leftStack.m_41619_()) {
            maid.f_19853_.m_7967_((Entity)new ItemEntity(maid.f_19853_, maid.m_20185_(), maid.m_20186_(), maid.m_20189_(), leftStack));
        }
        toolStacks.set(0, swapItemCopy);
        toolStacks0.set(0, swapItemCopy);
        this.kitchenToolInHand = swapItemCopy;
        return swapItemCopy;
    }

    public ItemStack getItem(ItemDefinition definition, ItemInventory itemInventory) {
        LinkedList<ItemStack> itemStacks = itemInventory.getItemStacks(definition);
        return itemStacks.isEmpty() ? ItemStack.f_41583_ : itemStacks.peek();
    }

    public ItemStack getItem(Item item, ItemInventory itemInventory) {
        LinkedList<ItemStack> itemStacks = itemInventory.getItemStacks(item);
        return itemStacks.isEmpty() ? ItemStack.f_41583_ : itemStacks.peek();
    }

    public ItemStack contItemStack(Item item, int count, ItemInventory itemInventory) {
        return this.contItemStack(count, itemInventory.getItemStacks(item));
    }

    public ItemStack contItemStack(MaidItem maidItem, ItemInventory itemInventory) {
        return this.contItemStack(maidItem.item(), maidItem.count(), itemInventory);
    }

    public ItemStack contItemStack(ItemDefinition definition, int containerAmount, ItemInventory itemInventory) {
        LinkedList<ItemStack> stackList = itemInventory.getItemStacks(definition);
        return this.contItemStack(containerAmount, stackList);
    }

    public ItemStack contItemStack(int containerAmount, LinkedList<ItemStack> stackList) {
        ItemStack peek;
        if (stackList == null || stackList.isEmpty()) {
            return ItemStack.f_41583_;
        }
        ItemStack result = peek = stackList.peek();
        while (containerAmount > 0) {
            if (peek == null) {
                return result;
            }
            int count = peek.m_41613_();
            if (count >= containerAmount) {
                result = peek.m_41620_(containerAmount);
                break;
            }
            stackList.poll();
            result.m_41769_(count);
            if ((containerAmount -= count) <= 0) break;
            peek = stackList.peek();
        }
        return result;
    }

    protected void init(CookBeBase<B> cookBeBase, MaidCookManager<R> rm) {
        this.maid = cookBeBase.getMaid();
        this.player = WrappedMaidFakePlayer.get(this.maid);
        this.be = cookBeBase.getBe();
        this.pos = this.be.m_58899_();
    }

    protected void clear(CookBeBase<B> cookBeBase, MaidCookManager<R> rm) {
        this.maid = null;
        this.player = null;
        this.be = null;
        this.pos = null;
        this.end = false;
        this.tick = 0;
    }

    protected void stop() {
        this.end = true;
    }
}

