/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.farm.handler.berry;

import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.Mods;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskInfo;
import com.github.wallev.maidsoulkitchen.task.farm.handler.IFarmHandlerManager;
import com.github.wallev.maidsoulkitchen.task.farm.handler.berry.BerryHandler;
import com.github.wallev.maidsoulkitchen.task.farm.handler.berry.CompatBerryHandler;
import com.github.wallev.maidsoulkitchen.task.farm.handler.berry.L2BerryHandler;
import com.github.wallev.maidsoulkitchen.task.farm.handler.berry.SimpleFarmingBerryHandler;
import com.github.wallev.maidsoulkitchen.task.farm.handler.berry.VanillaBerryHandler;
import com.github.wallev.maidsoulkitchen.task.farm.handler.berry.farmersrespite.FarmersRespiteBlackTeaBerryHandler;
import com.github.wallev.maidsoulkitchen.task.farm.handler.berry.farmersrespite.FarmersRespiteGreenTeaBerryHandler;
import com.github.wallev.maidsoulkitchen.task.farm.handler.berry.farmersrespite.FarmersRespiteYellowTeaBerryHandler;
import com.github.wallev.maidsoulkitchen.vhelper.client.resources.VResourceLocation;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;

public enum BerryHandlerManager implements IFarmHandlerManager<BerryHandler>
{
    MINECRAFT(TaskInfo.BERRY_MINECRAFT, VanillaBerryHandler::new),
    L2_HARVESTER(TaskInfo.BERRY_L2_HARVESTER, L2BerryHandler::new),
    FARMERS_RESPITE_GREEN_TEA(TaskInfo.BERRY_FARMERS_RESPITE_GREEN_TEA, FarmersRespiteGreenTeaBerryHandler::new),
    FARMERS_RESPITE_YELLOW_TEA(TaskInfo.BERRY_FARMERS_RESPITE_YELLOW_TEA, FarmersRespiteYellowTeaBerryHandler::new),
    FARMERS_RESPITE_BLACK_TEA(TaskInfo.BERRY_FARMERS_RESPITE_BLACK_TEA, FarmersRespiteBlackTeaBerryHandler::new),
    SIMPLE_FARMING(TaskInfo.BERRY_SIMPLE_FARMING, SimpleFarmingBerryHandler::new),
    COMPAT(TaskInfo.BERRY_COMPAT, CompatBerryHandler::new);

    public static final BerryHandlerManager[] VALUES;
    private final ResourceLocation uid;
    private final Mods bindMod;
    private final Supplier<BerryHandler> berryHandler;

    private BerryHandlerManager(TaskInfo taskInfo, Supplier<BerryHandler> berryHandler) {
        this(taskInfo.getUid(), taskInfo.getBindMod(), berryHandler);
    }

    private BerryHandlerManager(ResourceLocation uid, Mods bindMod, Supplier<BerryHandler> berryHandler) {
        this.uid = uid;
        this.bindMod = bindMod;
        this.berryHandler = berryHandler;
    }

    private BerryHandlerManager(String uid, Mods bindMod, Supplier<BerryHandler> berryHandler) {
        this(BerryHandlerManager.create(uid), bindMod, berryHandler);
    }

    static ResourceLocation create(String uid) {
        return VResourceLocation.create("maidsoulkitchen", uid);
    }

    @Override
    public BerryHandler getFarmHandler() {
        return this.berryHandler.get();
    }

    public ResourceLocation getUid() {
        return this.uid;
    }

    public Mods getBindMod() {
        return this.bindMod;
    }

    static {
        VALUES = BerryHandlerManager.values();
    }
}

