/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.client.event;

import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.RenderHelper;
import com.github.wallev.maidsoulkitchen.api.task.cook.ICookTask;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="maidsoulkitchen", value={Dist.CLIENT})
public class DisplayHubWithMaidRangeEvent {
    private static final Cache<Integer, Integer> CACHE = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build();

    @SubscribeEvent
    public static void onRender(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_BLOCK_ENTITIES) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ == null || mc.f_91073_ == null) {
                return;
            }
            Vec3 camera = event.getCamera().m_90583_().m_82548_();
            PoseStack poseStack = event.getPoseStack();
            Iterator iterator = CACHE.asMap().keySet().iterator();
            while (iterator.hasNext()) {
                int id = (Integer)iterator.next();
                Entity entity = mc.f_91073_.m_6815_(id);
                if (!(entity instanceof EntityMaid)) {
                    return;
                }
                EntityMaid maid = (EntityMaid)entity;
                DisplayHubWithMaidRangeEvent.renderPos(camera, poseStack, mc, maid);
            }
        }
    }

    private static void renderPos(Vec3 camera, PoseStack poseStack, Minecraft mc, EntityMaid maid) {
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 1.0f, 0.0f);
        BlockPos restrictPos = ICookTask.getSearchPos(maid);
        Vec3 restrictCam = camera.m_82520_((double)restrictPos.m_123341_() + 0.5, (double)restrictPos.m_123342_() + 0.5, (double)restrictPos.m_123343_() + 0.5);
        Vec3 maidPos = camera.m_82549_(maid.m_20182_());
        RenderHelper.renderLine((PoseStack)poseStack, (VertexConsumer)mc.m_91269_().m_110104_().m_6299_((RenderType)RenderType.f_110371_), (Vec3)restrictCam, (Vec3)maidPos, (float)1.0f, (float)0.2f, (float)0.2f);
        AABB aabb = maid.m_20191_().m_82386_(0.0, -1.0, 0.0).m_82383_(camera);
        DebugRenderer.m_269311_((PoseStack)poseStack, (MultiBufferSource)mc.m_91269_().m_110104_(), (AABB)aabb, (float)0.8f, (float)0.8f, (float)0.2f, (float)0.75f);
        Vec3 restrictCenter = restrictPos.m_252807_();
        Vec3 centerPos = camera.m_82520_(restrictCenter.m_7096_() + 0.5, restrictCenter.m_7098_() + 0.5, restrictCenter.m_7094_() + 0.5);
        double radius = (double)((float)((Integer)MaidConfig.MAID_WORK_RANGE.get()).intValue() * 2.5f) + 0.1;
        VertexConsumer buffer = mc.m_91269_().m_110104_().m_6299_((RenderType)RenderType.f_110371_);
        RenderHelper.renderCylinder((PoseStack)poseStack, (VertexConsumer)buffer, (Vec3)centerPos, (double)radius, (int)16, (float)1.0f, (float)0.0f, (float)0.0f);
        Vec3 textPos = new Vec3(restrictCenter.m_7096_() + 0.5, restrictCenter.m_7098_() + 2.0, restrictCenter.m_7094_() + 0.5);
        String text = I18n.m_118938_((String)"message.touhou_little_maid.kappa_compass.work_area", (Object[])new Object[0]);
        RenderHelper.renderFloatingText((PoseStack)poseStack, (String)text, (double)textPos.f_82479_, (double)textPos.f_82480_, (double)textPos.f_82481_, (int)0xFF1111, (float)0.15f, (boolean)true, (float)-5.0f, (boolean)false);
        RenderHelper.renderFloatingText((PoseStack)poseStack, (String)"\u25bc", (double)textPos.f_82479_, (double)textPos.f_82480_, (double)textPos.f_82481_, (int)0xFF1111, (float)0.15f, (boolean)true, (float)5.0f, (boolean)false);
        poseStack.m_85849_();
    }

    public static void add(int id) {
        CACHE.put((Object)id, (Object)0);
    }
}

