/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.client.renderer.entity.layer.banner;

import com.github.wallev.maidsoulkitchen.client.renderer.entity.layer.banner.IBannerRenderer;
import com.github.wallev.maidsoulkitchen.client.renderer.entity.layer.banner.bakery.LayerBakeryBannerRender;
import com.github.wallev.maidsoulkitchen.client.renderer.entity.layer.banner.beachparty.LayerBeachpartyBannerRender;
import com.github.wallev.maidsoulkitchen.client.renderer.entity.layer.banner.bloomingnature.LayerBloomingnatureBannerRender;
import com.github.wallev.maidsoulkitchen.client.renderer.entity.layer.banner.brewery.LayerBreweryBannerRender;
import com.github.wallev.maidsoulkitchen.client.renderer.entity.layer.banner.candlelight.LayerCandlelightBannerRender;
import com.github.wallev.maidsoulkitchen.client.renderer.entity.layer.banner.herbalbrews.LayerHerbalbrewsBannerRender;
import com.github.wallev.maidsoulkitchen.client.renderer.entity.layer.banner.meadow.LayerMeadowBannerRender;
import com.github.wallev.maidsoulkitchen.client.renderer.entity.layer.banner.vinery.LayerVineryBannerRender;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskInfo;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LayerRendererManager {
    private static LayerRendererManager INSTANCE = new LayerRendererManager();
    private List<IBannerRenderer> bannerRenderers = new ArrayList<IBannerRenderer>();

    private LayerRendererManager() {
        this.addBannerRenderer(TaskInfo.LAYER_BAKERY, LayerBakeryBannerRender::new);
        this.addBannerRenderer(TaskInfo.LAYER_BEACHPARTY, LayerBeachpartyBannerRender::new);
        this.addBannerRenderer(TaskInfo.LAYER_BLOOMINGNATURE, LayerBloomingnatureBannerRender::new);
        this.addBannerRenderer(TaskInfo.LAYER_BREWERY, LayerBreweryBannerRender::new);
        this.addBannerRenderer(TaskInfo.LAYER_CANDLELIGHT, LayerCandlelightBannerRender::new);
        this.addBannerRenderer(TaskInfo.LAYER_HERBALBREWS, LayerHerbalbrewsBannerRender::new);
        this.addBannerRenderer(TaskInfo.LAYER_MEADOW, LayerMeadowBannerRender::new);
        this.addBannerRenderer(TaskInfo.LAYER_VINERY, LayerVineryBannerRender::new);
        this.bannerRenderers = ImmutableList.copyOf(this.bannerRenderers);
    }

    public static void init() {
        INSTANCE = new LayerRendererManager();
    }

    private void addBannerRenderer(TaskInfo taskInfo, Supplier<IBannerRenderer> renderer) {
        if (taskInfo.canLoad()) {
            this.bannerRenderers.add(renderer.get());
        }
    }

    public static List<IBannerRenderer> getBannerRenderers() {
        return LayerRendererManager.INSTANCE.bannerRenderers;
    }
}

