/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.client.tooltip;

import com.github.wallev.maidsoulkitchen.client.tooltip.ClientAmountTooltip;
import com.github.wallev.maidsoulkitchen.entity.data.inner.task.cook.v0.CookData;
import com.github.wallev.maidsoulkitchen.util.MathUtil;
import com.github.wallev.maidsoulkitchen.util.TextContactUtil;
import com.github.wallev.maidsoulkitchen.vhelper.client.chat.VComponent;
import com.github.wallev.maidsoulkitchen.vhelper.client.resources.VResourceLocation;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.joml.Matrix4f;

public class RecipeDataTooltip
implements ClientAmountTooltip {
    private static final ResourceLocation TEXTURE = VResourceLocation.create("maidsoulkitchen", "textures/gui/cook_guide.png");
    private final CookData cookData;
    private final String recipeId;
    private final List<RecIngredient> ingres;
    private final RecIngredient result;
    private final boolean isBlacklist;

    public RecipeDataTooltip(TooltipRecipeData tooltipRecipeData) {
        this.cookData = tooltipRecipeData.cookData();
        this.recipeId = tooltipRecipeData.recipeId();
        this.ingres = RecIngredient.warp(tooltipRecipeData.ingres());
        this.isBlacklist = tooltipRecipeData.isBlacklist();
        this.result = RecIngredient.warpResult(tooltipRecipeData.result);
    }

    private MutableComponent getAmountComponent() {
        return VComponent.translatable("tooltips.maidsoulkitchen.amount.title");
    }

    private MutableComponent getCancookComponent() {
        return VComponent.translatable("gui.maidsoulkitchen.btn.cook_guide.can_cook").m_7220_((Component)VComponent.translatable(String.format("gui.maidsoulkitchen.btn.cook_guide.can_cook.%s", this.canCook() ? "true" : "false")));
    }

    private MutableComponent getModeComponent() {
        return VComponent.translatable("gui.maidsoulkitchen.btn.cook_guide.warn.now_type").m_7220_((Component)VComponent.translatable(String.format("gui.maidsoulkitchen.btn.cook_guide.type.%s", this.isBlacklist ? "blacklist" : "whitelist")));
    }

    private boolean canCook() {
        if (this.isBlacklist) {
            return !this.cookData.blacklistRecs().contains(this.recipeId);
        }
        return this.cookData.whitelistRecs().contains(this.recipeId);
    }

    private int getTooltipHeight(Font font) {
        return 30 + this.ingres.stream().mapToInt(rec -> rec.getHeight(font)).sum() + 2 * (this.ingres.size() - 1) + 1 + 10 + this.result.getHeight(font);
    }

    private int getTooltipWidth(Font font) {
        return MathUtil.max(font.m_92852_((FormattedText)this.getAmountComponent()), font.m_92852_((FormattedText)this.getModeComponent()), font.m_92852_((FormattedText)this.getCancookComponent()), this.ingres.stream().mapToInt(rec -> rec.getWidth(font)).max().orElse(0), this.result.getWidth(font));
    }

    private ItemStack getItem(Ingredient ingredient) {
        int item = (int)(System.currentTimeMillis() / 1000L % (long)ingredient.m_43908_().length);
        return ingredient.m_43908_()[item];
    }

    public int m_142103_() {
        return this.getTooltipHeight(Minecraft.m_91087_().f_91062_);
    }

    public int m_142069_(Font font) {
        return this.getTooltipWidth(font);
    }

    public void m_142440_(Font font, int mouseX, int pMouseY, Matrix4f matrix, MultiBufferSource.BufferSource bufferSource) {
    }

    public void m_183452_(Font font, int pX, int pY, GuiGraphics guiGraphics) {
        guiGraphics.m_280430_(font, (Component)this.getModeComponent(), pX, pY, ChatFormatting.GOLD.m_126665_().intValue());
        guiGraphics.m_280430_(font, (Component)this.getCancookComponent(), pX, pY += 10, (this.canCook() ? ChatFormatting.DARK_GREEN.m_126665_() : ChatFormatting.DARK_RED.m_126665_()).intValue());
        pY += 10;
        pY = this.drawLine(font, pX, pY, guiGraphics);
        guiGraphics.m_280430_(font, (Component)this.getAmountComponent(), pX, pY, ChatFormatting.GRAY.m_126665_().intValue());
        pY += 10;
        for (RecIngredient recIngredient : this.ingres) {
            pY = this.renderRecipeIngredientData(font, pX, pY, guiGraphics, recIngredient);
        }
        pY = this.drawLine(font, pX, pY, guiGraphics);
        pY = this.renderRecipeIngredientData(font, pX, pY, guiGraphics, this.result);
        pY = this.drawLine(font, pX, pY, guiGraphics);
    }

    private int drawLine(Font font, int pX, int pY, GuiGraphics guiGraphics) {
        for (int i = 0; i < this.m_142069_(font) / 2; i += 2) {
            guiGraphics.m_280024_(pX + i * 2, pY, pX + i * 2 + 2, pY + 1, Color.WHITE.getRGB(), Color.DARK_GRAY.getRGB());
        }
        return pY += 2;
    }

    private int renderRecipeIngredientData(Font font, int pX, int pY, GuiGraphics guiGraphics, RecIngredient recIngredient) {
        int height = recIngredient.getHeight(font);
        guiGraphics.m_280024_(pX, pY, pX + 2, pY + height, Color.GRAY.getRGB(), Color.DARK_GRAY.getRGB());
        int i = 0;
        int widgetOffsetX = pX + 4;
        List<Ingredient> ingredients = recIngredient.ingredients();
        for (Ingredient ingre : ingredients) {
            ItemStack[] stackItems = ingre.m_43908_();
            if (stackItems.length == 0) continue;
            int xOffset = widgetOffsetX + i++ * 20;
            ItemStack itemStack = this.getItem(ingre);
            guiGraphics.m_280480_(itemStack, xOffset, pY);
            if (itemStack.m_41613_() > 1) {
                guiGraphics.m_280370_(font, itemStack, xOffset, pY);
            }
            if (stackItems.length <= 1) continue;
            guiGraphics.m_280218_(TEXTURE, xOffset, pY + 13, 0, 253, 3, 3);
        }
        Component typeComponent = recIngredient.type().getComponent();
        guiGraphics.m_280430_(font, typeComponent, widgetOffsetX + ingredients.size() * 20 + 2, pY + 7, recIngredient.type().getColorFormatting().m_126665_().intValue());
        guiGraphics.m_280024_(widgetOffsetX, pY + 16, widgetOffsetX + ingredients.size() * 20 + 2 + font.m_92852_((FormattedText)typeComponent), pY + 16 + 1, Color.GRAY.getRGB(), Color.DARK_GRAY.getRGB());
        pY += 18;
        for (Component sourceTip : recIngredient.sourceTips) {
            guiGraphics.m_280430_(font, sourceTip, widgetOffsetX, pY, ChatFormatting.GRAY.m_126665_().intValue());
            Objects.requireNonNull(font);
            pY += 9 + 1;
        }
        return pY += 2;
    }

    public record TooltipRecipeData(CookData cookData, String recipeId, List<TooltipRecIngredient> ingres, TooltipRecIngredient result, boolean isBlacklist, boolean isOverSize) implements TooltipComponent
    {
    }

    public record RecIngredient(List<Ingredient> ingredients, List<Component> sourceTips, IngredientType type) {
        public static RecIngredient warpResult(TooltipRecIngredient tooltipRecIngredient) {
            return RecIngredient.warp(tooltipRecIngredient, "gui.maidsoulkitchen.btn.cook_guide.output_to");
        }

        public static RecIngredient warp(TooltipRecIngredient tooltipRecIngredient) {
            return RecIngredient.warp(tooltipRecIngredient, "gui.maidsoulkitchen.btn.cook_guide.ingredient_source_type");
        }

        private static RecIngredient warp(TooltipRecIngredient tooltipRecIngredient, String key) {
            List<List<IngredientSourceType>> sourceTypes = tooltipRecIngredient.sourceTypes;
            int i = 0;
            ArrayList<Component> sourceTips = new ArrayList<Component>();
            for (List<IngredientSourceType> sourceType : sourceTypes) {
                MutableComponent component = TextContactUtil.contact(sourceType, VComponent.translatable(key, i), IngredientSourceType::getComponent);
                if (i == tooltipRecIngredient.ruleMatchIndex()) {
                    component.m_130940_(ChatFormatting.DARK_GREEN);
                }
                sourceTips.add((Component)component);
                ++i;
            }
            return new RecIngredient(tooltipRecIngredient.ingredients(), sourceTips, tooltipRecIngredient.type());
        }

        public static List<RecIngredient> warp(List<TooltipRecIngredient> tooltipRecIngredients) {
            return tooltipRecIngredients.stream().map(RecIngredient::warp).toList();
        }

        public int getWidth(Font font) {
            return 4 + Math.max(this.ingredients.size() * 20 + font.m_92852_((FormattedText)this.type.getComponent()), this.sourceTips.stream().mapToInt(arg_0 -> ((Font)font).m_92852_(arg_0)).max().orElse(0));
        }

        public int getHeight(Font font) {
            Objects.requireNonNull(font);
            return 18 + (9 + 1) * this.sourceTips.size();
        }
    }

    public record TooltipRecIngredient(List<Ingredient> ingredients, List<List<IngredientSourceType>> sourceTypes, IngredientType type, int ruleMatchIndex) {
    }

    public static enum IngredientType {
        MANDATORY(ChatFormatting.GOLD),
        MAYBE(ChatFormatting.GRAY),
        OUTPUT(ChatFormatting.DARK_GREEN);

        private final ChatFormatting colorFormatting;

        private IngredientType(ChatFormatting colorFormatting) {
            this.colorFormatting = colorFormatting;
        }

        public Component getComponent() {
            return VComponent.translatable("gui.maidsoulkitchen.btn.cook_guide.ingredient_type." + this.name().toLowerCase(Locale.ENGLISH));
        }

        public ChatFormatting getColorFormatting() {
            return this.colorFormatting;
        }
    }

    public static enum IngredientSourceType {
        MAIN_HAND,
        OFF_HAND,
        MAID_BACKPACK,
        HUB_START_ADDITION,
        HUB_INGREDIENT,
        HUB_INGREDIENT_ADDITION,
        HUB_OUTPUT_ADDITION,
        HUB_OUTPUT,
        PICKUP;


        public MutableComponent getComponent() {
            return VComponent.translatable("gui.maidsoulkitchen.btn.cook_guide.ingredient_source_type." + this.name().toLowerCase(Locale.ENGLISH));
        }
    }
}

