/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.compat.msm.common.craft.base;

import com.github.tartaricacid.touhoulittlemaid.capability.PowerCapabilityProvider;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.maidsoulkitchen.compat.msm.common.craft.util.IFailGuideUseActionContext;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskClassAnalyzer;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskInfo;
import com.github.wallev.maidsoulkitchen.vhelper.client.resources.VResourceLocation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.craft.action.ActionOption;
import studio.fantasyit.maid_storage_manager.craft.context.AbstractCraftActionContext;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonUseAction;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayer;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.InvUtil;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;
import studio.fantasyit.maid_storage_manager.util.MathUtil;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;
import studio.fantasyit.maid_storage_manager.util.MoveUtil;
import studio.fantasyit.maid_storage_manager.util.WrappedMaidFakePlayer;

@TaskClassAnalyzer(value=TaskInfo.MSM_CORE)
public class EnchantCommonUseAction
extends CommonUseAction
implements IFailGuideUseActionContext {
    public static final ResourceLocation TYPE = VResourceLocation.createMod("enchant_use");
    public static final ActionOption<Boolean> SNEAK = new ActionOption(VResourceLocation.createMod("sneak"), new Component[]{Component.m_237115_((String)"gui.maid_storage_manager.craft_guide.common.required"), Component.m_237115_((String)"gui.maid_storage_manager.craft_guide.common.optional")}, new ResourceLocation[]{new ResourceLocation("maid_storage_manager:textures/gui/craft/option/required.png"), new ResourceLocation("maid_storage_manager:textures/gui/craft/option/optional.png")}, "", new ActionOption.BiConverter(value -> value == 1, value -> value != false ? 1 : 0), ActionOption.ValuePredicatorOrGetter.getter(value -> value != false ? Component.m_237115_((String)"gui.maid_storage_manager.craft_guide.common.optional") : Component.m_237115_((String)"gui.maid_storage_manager.craft_guide.common.required")));
    protected WrappedMaidFakePlayer fakePlayer;
    int storedSlotMainHand = -1;
    int storedSlotOffHand = -1;
    int failCount = 0;
    float powerPointAtStart = 0.0f;
    boolean hasStartUsing = false;

    public EnchantCommonUseAction(EntityMaid maid, CraftGuideData craftGuideData, CraftGuideStepData craftGuideStepData, CraftLayer layer) {
        super(maid, craftGuideData, craftGuideStepData, layer);
    }

    public AbstractCraftActionContext.Result start() {
        AbstractCraftActionContext.Result result = this.thisStart();
        if (result == AbstractCraftActionContext.Result.FAIL && this.toFailSteps(this.craftGuideStepData, this.craftGuideData, this.craftLayer)) {
            return AbstractCraftActionContext.Result.SUCCESS;
        }
        return result;
    }

    public AbstractCraftActionContext.Result tick() {
        AbstractCraftActionContext.Result result = this.thisTick();
        if (result == AbstractCraftActionContext.Result.FAIL && this.toFailSteps(this.craftGuideStepData, this.craftGuideData, this.craftLayer)) {
            return AbstractCraftActionContext.Result.SUCCESS;
        }
        return result;
    }

    public void stop() {
        this.resetSneak();
        this.thisStop();
    }

    public void makeSneak(AbstractCraftActionContext.Result result) {
        if (result != AbstractCraftActionContext.Result.FAIL) {
            this.craftGuideStepData.getOptionSelection(SNEAK).ifPresent(sneak -> {
                if (sneak.booleanValue()) {
                    this.fakePlayer.m_20260_(true);
                }
            });
        }
    }

    public void resetSneak() {
        this.fakePlayer.m_20260_(false);
    }

    public void loadEnv(CompoundTag env) {
        this.failCount = env.m_128441_("failCount") ? env.m_128451_("failCount") : 0;
    }

    public CompoundTag saveEnv(CompoundTag env) {
        env.m_128405_("failCount", this.failCount);
        return super.saveEnv(env);
    }

    public AbstractCraftActionContext.Result thisStart() {
        this.fakePlayer = WrappedMaidFakePlayer.get((EntityMaid)this.maid);
        this.fakePlayer.getCapability(PowerCapabilityProvider.POWER_CAP).ifPresent(powerCapability -> {
            powerCapability.set((float)(this.maid.getExperience() * 4));
            this.powerPointAtStart = powerCapability.get();
        });
        if (this.fakePlayer.m_6117_()) {
            this.fakePlayer.m_5810_();
        }
        this.maid.m_21573_().m_26573_();
        ItemStack targetItem = (ItemStack)this.craftGuideStepData.getInput().get(0);
        ItemStack targetItem2 = (ItemStack)this.craftGuideStepData.getInput().get(1);
        this.storedSlotMainHand = InvUtil.getTargetIndexInCrafting((EntityMaid)this.maid, (ItemStack)targetItem, (int)1);
        if (this.storedSlotMainHand == -1) {
            return AbstractCraftActionContext.Result.FAIL;
        }
        this.storedSlotOffHand = InvUtil.getTargetIndexInCrafting((EntityMaid)this.maid, (ItemStack)targetItem2, (int)2, (int)this.storedSlotMainHand);
        if (this.storedSlotOffHand == -1) {
            return AbstractCraftActionContext.Result.FAIL;
        }
        InvUtil.swapHandAndSlot((EntityMaid)this.maid, (InteractionHand)InteractionHand.MAIN_HAND, (int)this.storedSlotMainHand);
        InvUtil.swapHandAndSlot((EntityMaid)this.maid, (InteractionHand)InteractionHand.OFF_HAND, (int)this.storedSlotOffHand);
        MemoryUtil.getCrafting((EntityMaid)this.maid).setSwappingHandWhenCrafting(true);
        this.failCount = 0;
        return AbstractCraftActionContext.Result.CONTINUE;
    }

    public AbstractCraftActionContext.Result thisTick() {
        if (!MoveUtil.setMovementIfColliedTarget((ServerLevel)((ServerLevel)this.maid.m_9236_()), (EntityMaid)this.maid, (Target)this.craftGuideStepData.storage)) {
            return AbstractCraftActionContext.Result.CONTINUE;
        }
        return switch (this.craftGuideStepData.getOptionSelection(OPTION_USE_METHOD).orElse(CommonUseAction.USE_TYPE.SINGLE)) {
            default -> throw new IncompatibleClassChangeError();
            case CommonUseAction.USE_TYPE.SINGLE -> this.workForSingleUse();
            case CommonUseAction.USE_TYPE.LONG -> this.workForLongUse();
        };
    }

    @NotNull
    private AbstractCraftActionContext.Result workForSingleUse() {
        this.maid.m_6674_(InteractionHand.MAIN_HAND);
        @Nullable List<ItemStack> ret = this.interactWithItemAndGetReturn();
        if (ret == null) {
            if (++this.failCount > 10) {
                if (this.craftGuideStepData.isOptional()) {
                    return AbstractCraftActionContext.Result.SUCCESS;
                }
                return AbstractCraftActionContext.Result.FAIL;
            }
            MoveUtil.setMovementTowardsTargetSlowly((EntityMaid)this.maid);
            return AbstractCraftActionContext.Result.CONTINUE_INTERRUPTABLE;
        }
        return this.checkAndGetResult(ret);
    }

    @NotNull
    public AbstractCraftActionContext.Result workForLongUse() {
        if (this.hasStartUsing) {
            this.fakePlayer.m_21329_();
            if (this.fakePlayer.m_21211_().m_41619_()) {
                List<ItemStack> inventoryReturn = this.getAndClearFakePlayerInventory();
                return this.checkAndGetResult(inventoryReturn);
            }
            if (this.fakePlayer.m_21212_() < 0) {
                this.fakePlayer.m_21253_();
            }
            return AbstractCraftActionContext.Result.CONTINUE;
        }
        this.maid.m_6674_(InteractionHand.MAIN_HAND);
        Target storage = this.craftGuideStepData.getStorage();
        BlockPos target = this.craftGuideStepData.getStorage().getPos();
        ServerLevel level = (ServerLevel)this.maid.m_9236_();
        BlockHitResult blockHitResult = this.getBlockHitResult(target, level, storage);
        if (blockHitResult != null) {
            this.maid.m_6672_(InteractionHand.MAIN_HAND);
            this.useItemSingle(target, blockHitResult, level);
            if (!this.fakePlayer.m_21211_().m_41619_()) {
                this.hasStartUsing = true;
            }
        }
        if (blockHitResult == null || !this.hasStartUsing) {
            if (++this.failCount > 10) {
                if (this.craftGuideStepData.isOptional()) {
                    return AbstractCraftActionContext.Result.SUCCESS;
                }
                return AbstractCraftActionContext.Result.FAIL;
            }
            MoveUtil.setMovementTowardsTargetSlowly((EntityMaid)this.maid);
            return AbstractCraftActionContext.Result.CONTINUE_INTERRUPTABLE;
        }
        return AbstractCraftActionContext.Result.CONTINUE;
    }

    @NotNull
    private AbstractCraftActionContext.Result checkAndGetResult(@NotNull List<ItemStack> ret) {
        int resultPlaced = 0;
        for (ItemStack itemStack : ret) {
            ItemStack itemStack1 = InvUtil.tryPlace((IItemHandler)this.maid.getAvailableInv(false), (ItemStack)itemStack);
            int realPlaced = itemStack.m_41613_() - itemStack1.m_41613_();
            if (!itemStack1.m_41619_()) {
                InvUtil.throwItem((EntityMaid)this.maid, (ItemStack)itemStack1);
            }
            if (!ItemStackUtil.isSameInCrafting((ItemStack)itemStack, (ItemStack)((ItemStack)this.craftGuideStepData.getOutput().get(0)))) continue;
            resultPlaced += realPlaced;
        }
        if (ItemStackUtil.isSameInCrafting((ItemStack)((ItemStack)this.craftGuideStepData.getOutput().get(0)), (ItemStack)this.fakePlayer.m_21205_())) {
            resultPlaced += this.fakePlayer.m_21205_().m_41613_();
        }
        if (ItemStackUtil.isSameInCrafting((ItemStack)((ItemStack)this.craftGuideStepData.getOutput().get(0)), (ItemStack)this.fakePlayer.m_21206_())) {
            resultPlaced += this.fakePlayer.m_21206_().m_41613_();
        }
        if (resultPlaced >= ((ItemStack)this.craftGuideStepData.getOutput().get(0)).m_41613_()) {
            return AbstractCraftActionContext.Result.SUCCESS;
        }
        if (this.craftGuideStepData.isOptional()) {
            return AbstractCraftActionContext.Result.SUCCESS;
        }
        return AbstractCraftActionContext.Result.FAIL;
    }

    @Nullable
    private List<ItemStack> interactWithItemAndGetReturn() {
        ServerLevel level;
        Target storage = this.craftGuideStepData.getStorage();
        BlockPos target = this.craftGuideStepData.getStorage().getPos();
        BlockHitResult result = this.getBlockHitResult(target, level = (ServerLevel)this.maid.m_9236_(), storage);
        if (result == null) {
            return null;
        }
        this.useItemSingle(target, result, level);
        this.fakePlayer.overrideXYRot(null, null);
        return this.getAndClearFakePlayerInventory();
    }

    @NotNull
    private List<ItemStack> getAndClearFakePlayerInventory() {
        Inventory inventory = this.fakePlayer.m_150109_();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            if (inventory.m_8020_(i).m_41619_()) continue;
            ItemStackUtil.addToList(items, (ItemStack)inventory.m_8020_(i), (boolean)true);
            inventory.m_6836_(i, ItemStack.f_41583_);
        }
        return items;
    }

    private void useItemSingle(BlockPos target, BlockHitResult result, ServerLevel level) {
        InteractionResult use;
        InteractionResult cancelResult = ForgeHooks.onItemRightClick((Player)this.fakePlayer, (InteractionHand)InteractionHand.MAIN_HAND);
        if (cancelResult != null && cancelResult.m_19077_()) {
            return;
        }
        PlayerInteractEvent.RightClickBlock event = ForgeHooks.onRightClickBlock((Player)this.fakePlayer, (InteractionHand)InteractionHand.MAIN_HAND, (BlockPos)target, (BlockHitResult)result);
        BlockState targetState = level.m_8055_(target);
        if (event.getUseBlock() != Event.Result.DENY && !(use = targetState.m_60664_((Level)level, (Player)this.fakePlayer, InteractionHand.MAIN_HAND, result)).m_19077_()) {
            InteractionResult interactionResult;
            UseOnContext useContext = new UseOnContext((Player)this.fakePlayer, InteractionHand.MAIN_HAND, result);
            InteractionResult actionresult = this.fakePlayer.m_21120_(InteractionHand.MAIN_HAND).onItemUseFirst(useContext);
            if (actionresult == InteractionResult.PASS && !(interactionResult = this.fakePlayer.m_21120_(InteractionHand.MAIN_HAND).m_41661_(useContext)).m_19077_()) {
                InteractionResultHolder use1 = this.fakePlayer.m_21120_(InteractionHand.MAIN_HAND).m_41682_((Level)level, (Player)this.fakePlayer, InteractionHand.MAIN_HAND);
                this.fakePlayer.m_21008_(InteractionHand.MAIN_HAND, (ItemStack)use1.m_19095_());
            }
        }
    }

    @Nullable
    private BlockHitResult getBlockHitResult(BlockPos target, ServerLevel level, Target storage) {
        Vec3 eyePos = this.maid.m_20318_(0.0f).m_82520_(0.0, (double)this.maid.m_20192_(), 0.0);
        Vec3 viewVec = null;
        BlockHitResult result = null;
        for (float disToSize = 0.5f; disToSize > 0.0f; disToSize -= 0.1f) {
            for (Direction direction : Direction.values()) {
                if (this.craftGuideStepData.getStorage().side != null && this.craftGuideStepData.getStorage().side != direction) continue;
                ClipContext rayTraceContext = new ClipContext(eyePos, target.m_252807_().m_231075_(direction, (double)disToSize), ClipContext.Block.COLLIDER, this.shouldUseFluidClip(level, target) ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE, (Entity)this.fakePlayer);
                viewVec = target.m_252807_().m_231075_(direction, (double)disToSize).m_82546_(eyePos);
                result = level.m_45547_(rayTraceContext);
                if (result.m_82425_().equals((Object)target) && (storage.side == null || result.m_82434_() == storage.side)) break;
                result = null;
            }
            if (result != null) break;
        }
        if (result == null) {
            return null;
        }
        this.fakePlayer.overrideXYRot(Float.valueOf(MathUtil.vec2RotX(viewVec)), Float.valueOf(MathUtil.vec2RotY(viewVec)));
        return result;
    }

    private boolean shouldUseFluidClip(ServerLevel level, BlockPos target) {
        if (level.m_6425_(target).m_76170_()) {
            return true;
        }
        return this.craftGuideStepData.getInput().stream().anyMatch(t -> t.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent());
    }

    public void thisStop() {
        if (this.storedSlotOffHand != -1) {
            InvUtil.swapHandAndSlot((EntityMaid)this.maid, (InteractionHand)InteractionHand.OFF_HAND, (int)this.storedSlotOffHand);
        }
        if (this.storedSlotMainHand != -1) {
            InvUtil.swapHandAndSlot((EntityMaid)this.maid, (InteractionHand)InteractionHand.MAIN_HAND, (int)this.storedSlotMainHand);
        }
        this.fakePlayer.getCapability(PowerCapabilityProvider.POWER_CAP).ifPresent(powerCapability -> {
            if (powerCapability.get() != this.powerPointAtStart) {
                float deltaPP = powerCapability.get() - this.powerPointAtStart;
                this.maid.setExperience(this.maid.getExperience() - (int)Math.ceil(deltaPP / 4.0f));
            }
        });
        if (this.fakePlayer.m_6117_()) {
            this.fakePlayer.m_5810_();
        }
        MemoryUtil.getCrafting((EntityMaid)this.maid).setSwappingHandWhenCrafting(false);
    }

    public boolean skipNextBreath() {
        return this.hasStartUsing;
    }

    void heldResultItem() {
        ItemStack offhandItem;
        List outputs = this.craftGuideStepData.getOutput();
        if (outputs.isEmpty()) {
            return;
        }
        ItemStack result = (ItemStack)outputs.get(0);
        if (ItemStack.m_150942_((ItemStack)result, (ItemStack)(offhandItem = this.maid.m_21206_()))) {
            return;
        }
        int resultIndex = EnchantCommonUseAction.getTargetIndexInCrafting(this.maid, result, 0);
        if (resultIndex == -1) {
            return;
        }
        InvUtil.swapHandAndSlot((EntityMaid)this.maid, (InteractionHand)InteractionHand.OFF_HAND, (int)resultIndex);
    }

    public static int getTargetIndexInCrafting(EntityMaid maid, ItemStack itemStack, int skip) {
        return EnchantCommonUseAction.getTargetIndexInCrafting(maid, itemStack, skip, -1);
    }

    public static int getTargetIndexInCrafting(EntityMaid maid, ItemStack itemStack, int skip, int except) {
        CombinedInvWrapper inv = maid.getAvailableInv(true);
        for (int i = skip; i < inv.getSlots(); ++i) {
            if (i == except) continue;
            if (itemStack.m_41619_() && inv.getStackInSlot(i).m_41619_()) {
                return i;
            }
            if (itemStack.m_41619_() || !ItemStackUtil.isSameInCrafting((ItemStack)inv.getStackInSlot(i), (ItemStack)itemStack)) continue;
            return i;
        }
        return -1;
    }
}

