/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.compat.msm.common.craft.custom;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.maidsoulkitchen.compat.msm.common.craft.util.IFailGuideUseActionContext;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskClassAnalyzer;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskInfo;
import com.github.wallev.maidsoulkitchen.vhelper.client.resources.VResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.StringUtils;
import studio.fantasyit.maid_storage_manager.craft.action.ActionOption;
import studio.fantasyit.maid_storage_manager.craft.context.AbstractCraftActionContext;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayer;

@TaskClassAnalyzer(value=TaskInfo.MSM_CORE)
public class JumpAction
extends AbstractCraftActionContext
implements IFailGuideUseActionContext {
    public static final ResourceLocation TYPE = VResourceLocation.createMod("jump");
    public static final ActionOption<Boolean> JUMP_COUNT = new ActionOption(VResourceLocation.createMod("jump_mode"), new Component[]{Component.m_237115_((String)"gui.maid_storage_manager.craft_guide.common.idle_second"), Component.m_237115_((String)"gui.maid_storage_manager.craft_guide.common.idle_tick")}, new ResourceLocation[]{new ResourceLocation("maid_storage_manager:textures/gui/craft/option/wait_second.png"), new ResourceLocation("maid_storage_manager:textures/gui/craft/option/wait_tick.png")}, "", new ActionOption.BiConverter(i -> i != 0, b -> b != false ? 1 : 0), ActionOption.ValuePredicatorOrGetter.predicator(t -> t.isBlank() || StringUtils.isNumeric((CharSequence)t) && Integer.parseInt(t) <= 999));
    private Vec3 center;
    private int leftJumpCount = 0;

    public JumpAction(EntityMaid maid, CraftGuideData craftGuideData, CraftGuideStepData craftGuideStepData, CraftLayer layer) {
        super(maid, craftGuideData, craftGuideStepData, layer);
    }

    public void loadEnv(CompoundTag env) {
        this.leftJumpCount = env.m_128441_("leftJumpCount") ? env.m_128451_("leftJumpCount") : 0;
    }

    public CompoundTag saveEnv(CompoundTag env) {
        env.m_128405_("leftJumpCount", this.leftJumpCount);
        return super.saveEnv(env);
    }

    public AbstractCraftActionContext.Result start() {
        int time;
        BlockPos target = this.craftGuideStepData.getStorage().getPos();
        this.center = target.m_252807_();
        String jumpCountStr = this.craftGuideStepData.getOptionValue(JUMP_COUNT);
        if (jumpCountStr.isBlank()) {
            jumpCountStr = "0";
        }
        this.leftJumpCount = time = Integer.parseInt(jumpCountStr);
        return AbstractCraftActionContext.Result.NOT_DONE;
    }

    public AbstractCraftActionContext.Result tick() {
        if (!this.maid.m_20096_()) {
            return AbstractCraftActionContext.Result.NOT_DONE;
        }
        if (this.leftJumpCount <= 0) {
            return AbstractCraftActionContext.Result.SUCCESS;
        }
        this.dump();
        return AbstractCraftActionContext.Result.NOT_DONE;
    }

    public void stop() {
        this.center = null;
        this.leftJumpCount = 0;
    }

    public void dump() {
        --this.leftJumpCount;
        Vec3 deltaMovement = this.maid.m_20184_();
        this.maid.m_20334_(0.0, deltaMovement.m_7098_(), 0.0);
        this.maid.m_20334_((this.center.f_82479_ - this.maid.m_20182_().f_82479_) * (double)0.2f, 0.3, (this.center.f_82481_ - this.maid.m_20182_().f_82481_) * (double)0.2f);
        Vec3 deltaMovement1 = this.maid.m_20184_();
        this.maid.m_20334_(deltaMovement1.f_82479_ * (double)0.3f, this.maid.m_20184_().m_7098_(), deltaMovement1.f_82481_ * (double)0.3f);
    }
}

