/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.compat.msm.common.craft.custom.menu;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.maidsoulkitchen.compat.msm.common.craft.util.IFailGuideUseActionContext;
import com.github.wallev.maidsoulkitchen.vhelper.client.resources.VResourceLocation;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.craft.context.AbstractCraftActionContext;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayer;
import studio.fantasyit.maid_storage_manager.util.InvUtil;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;
import studio.fantasyit.maid_storage_manager.util.WrappedMaidFakePlayer;

public abstract class AbstractMenuActionContext
extends AbstractCraftActionContext
implements IFailGuideUseActionContext {
    protected WrappedMaidFakePlayer fakePlayer;
    int storedSlotMainHand = -1;
    int storedSlotOffHand = -1;
    int slot = 0;
    int ingredientIndex = 0;
    ResourceLocation menuType;
    @Nullable
    Direction side;

    public AbstractMenuActionContext(EntityMaid maid, CraftGuideData craftGuideData, CraftGuideStepData craftGuideStepData, CraftLayer layer) {
        super(maid, craftGuideData, craftGuideStepData, layer);
    }

    public AbstractCraftActionContext.Result start() {
        return this.thisStart();
    }

    public AbstractCraftActionContext.Result thisStart() {
        this.fakePlayer = WrappedMaidFakePlayer.get((EntityMaid)this.maid);
        if (this.fakePlayer.m_6117_()) {
            this.fakePlayer.m_5810_();
        }
        this.maid.m_21573_().m_26573_();
        ItemStack targetItem = (ItemStack)this.craftGuideStepData.getInput().get(0);
        ItemStack targetItem2 = (ItemStack)this.craftGuideStepData.getInput().get(1);
        this.storedSlotMainHand = InvUtil.getTargetIndexInCrafting((EntityMaid)this.maid, (ItemStack)targetItem, (int)1);
        if (this.storedSlotMainHand == -1) {
            return AbstractCraftActionContext.Result.FAIL;
        }
        this.storedSlotOffHand = InvUtil.getTargetIndexInCrafting((EntityMaid)this.maid, (ItemStack)targetItem2, (int)2, (int)this.storedSlotMainHand);
        if (this.storedSlotOffHand == -1) {
            return AbstractCraftActionContext.Result.FAIL;
        }
        InvUtil.swapHandAndSlot((EntityMaid)this.maid, (InteractionHand)InteractionHand.MAIN_HAND, (int)this.storedSlotMainHand);
        InvUtil.swapHandAndSlot((EntityMaid)this.maid, (InteractionHand)InteractionHand.OFF_HAND, (int)this.storedSlotOffHand);
        MemoryUtil.getCrafting((EntityMaid)this.maid).setSwappingHandWhenCrafting(true);
        Context context = Context.from(this.craftGuideStepData.getExtraData());
        this.menuType = context.menuType();
        this.side = context.side();
        return AbstractCraftActionContext.Result.CONTINUE;
    }

    public AbstractCraftActionContext.Result tick() {
        return this.thisTick();
    }

    public abstract AbstractCraftActionContext.Result thisTick();

    public void stop() {
        this.thisStp();
    }

    public void thisStp() {
        if (this.storedSlotOffHand != -1) {
            InvUtil.swapHandAndSlot((EntityMaid)this.maid, (InteractionHand)InteractionHand.OFF_HAND, (int)this.storedSlotOffHand);
        }
        if (this.storedSlotMainHand != -1) {
            InvUtil.swapHandAndSlot((EntityMaid)this.maid, (InteractionHand)InteractionHand.MAIN_HAND, (int)this.storedSlotMainHand);
        }
        if (this.fakePlayer.m_6117_()) {
            this.fakePlayer.m_5810_();
        }
        MemoryUtil.getCrafting((EntityMaid)this.maid).setSwappingHandWhenCrafting(false);
    }

    boolean allDone() {
        if (this.craftGuideStepData == null) {
            return false;
        }
        List items = this.craftGuideStepData.getOutput();
        for (int i = 0; i < items.size(); ++i) {
            if (this.craftLayer.getCurrentStepCount(i) >= ((ItemStack)items.get(i)).m_41613_()) continue;
            return false;
        }
        return true;
    }

    private List<ItemStack> getAndClearFakePlayerInventory() {
        Inventory inventory = this.fakePlayer.m_150109_();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            if (inventory.m_8020_(i).m_41619_()) continue;
            ItemStackUtil.addToList(items, (ItemStack)inventory.m_8020_(i), (boolean)true);
            inventory.m_6836_(i, ItemStack.f_41583_);
        }
        return items;
    }

    AbstractCraftActionContext.Result checkAndGetResult() {
        List<ItemStack> ret = this.getAndClearFakePlayerInventory();
        int resultPlaced = 0;
        for (ItemStack itemStack : ret) {
            ItemStack itemStack1 = InvUtil.tryPlace((IItemHandler)this.maid.getAvailableInv(false), (ItemStack)itemStack);
            int realPlaced = itemStack.m_41613_() - itemStack1.m_41613_();
            if (!itemStack1.m_41619_()) {
                InvUtil.throwItem((EntityMaid)this.maid, (ItemStack)itemStack1);
            }
            if (!ItemStackUtil.isSameInCrafting((ItemStack)itemStack, (ItemStack)((ItemStack)this.craftGuideStepData.getOutput().get(0)))) continue;
            resultPlaced += realPlaced;
        }
        if (ItemStackUtil.isSameInCrafting((ItemStack)((ItemStack)this.craftGuideStepData.getOutput().get(0)), (ItemStack)this.fakePlayer.m_21205_())) {
            resultPlaced += this.fakePlayer.m_21205_().m_41613_();
        }
        if (ItemStackUtil.isSameInCrafting((ItemStack)((ItemStack)this.craftGuideStepData.getOutput().get(0)), (ItemStack)this.fakePlayer.m_21206_())) {
            resultPlaced += this.fakePlayer.m_21206_().m_41613_();
        }
        if (resultPlaced >= ((ItemStack)this.craftGuideStepData.getOutput().get(0)).m_41613_()) {
            return AbstractCraftActionContext.Result.SUCCESS;
        }
        if (this.craftGuideStepData.isOptional()) {
            return AbstractCraftActionContext.Result.SUCCESS;
        }
        return AbstractCraftActionContext.Result.FAIL;
    }

    public record Context(ResourceLocation menuType, @Nullable Direction side) {
        public static final ResourceLocation UNKNOWN = VResourceLocation.createMod("unknown");
        public static final Codec<Context> CODEC = RecordCodecBuilder.create(ins -> ins.group((App)ResourceLocation.f_135803_.fieldOf("menuType").forGetter(Context::menuType), (App)Direction.f_175356_.optionalFieldOf("side", null).forGetter(Context::side)).apply((Applicative)ins, Context::new));

        public static CompoundTag to(Context context) {
            return CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)context).result().map(tag -> (CompoundTag)tag).orElseGet(CompoundTag::new);
        }

        public static CompoundTag to(ResourceLocation menuType, @Nullable Direction side) {
            return CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)new Context(menuType, side)).result().map(tag -> (CompoundTag)tag).orElseGet(CompoundTag::new);
        }

        public static CompoundTag to(ResourceLocation menuType) {
            return Context.to(menuType, null);
        }

        public static Context from(CompoundTag compoundTag) {
            return CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)compoundTag).result().orElse(new Context(UNKNOWN, null));
        }
    }
}

