/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.compat.msm.common.util;

import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskClassAnalyzer;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskInfo;
import java.util.function.IntUnaryOperator;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@TaskClassAnalyzer(value=TaskInfo.MSM_CORE)
public class SlotLimitInvWrapper
implements IItemHandlerModifiable {
    protected final Container inv;
    private final IntUnaryOperator slotLimit;
    private final InsertLimit newStackInsertLimit;
    private final int[] limitSlots;

    public SlotLimitInvWrapper(Container inv, int ... limitSlots) {
        this.inv = inv;
        this.limitSlots = limitSlots;
        this.slotLimit = wrapperSlot -> inv.m_6893_();
        this.newStackInsertLimit = inv instanceof AbstractFurnaceBlockEntity ? (wrapperSlot, invSlot, stack) -> invSlot == 1 && stack.m_150930_(Items.f_42446_) ? 1 : Math.min(stack.m_41741_(), this.getSlotLimit(wrapperSlot)) : (wrapperSlot, invSlot, stack) -> Math.min(stack.m_41741_(), this.getSlotLimit(wrapperSlot));
    }

    public static int getSlot(WorldlyContainer inv, int slot, @Nullable Direction side) {
        int[] slots = inv.m_7071_(side);
        if (slot < slots.length) {
            return slots[slot];
        }
        return -1;
    }

    public int getSlot(Container inv, int slot) {
        for (int i : this.limitSlots) {
            if (i != slot) continue;
            return slot;
        }
        return -1;
    }

    public int[] getSlotsForFace() {
        return this.limitSlots;
    }

    public boolean canPlaceItemThroughFace(int pIndex, ItemStack pItemStack) {
        int slot = this.getSlot(this.inv, pIndex);
        if (slot == -1) {
            return false;
        }
        return this.inv.m_7013_(slot, pItemStack);
    }

    public boolean canTakeItemThroughFace(int pIndex, ItemStack pStack) {
        int slot = this.getSlot(this.inv, pIndex);
        if (slot == -1) {
            return false;
        }
        return this.inv.m_271862_(this.inv, slot, pStack);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlotLimitInvWrapper that = (SlotLimitInvWrapper)o;
        return this.inv.equals(that.inv);
    }

    public int hashCode() {
        int result = this.inv.hashCode();
        result = 31 * result;
        return result;
    }

    public int getSlots() {
        return this.inv.m_6643_();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        int i = this.getSlot(this.inv, slot);
        return i == -1 ? ItemStack.f_41583_ : this.inv.m_8020_(i);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        int slot1 = this.getSlot(this.inv, slot);
        if (slot1 == -1) {
            return stack;
        }
        ItemStack stackInSlot = this.inv.m_8020_(slot1);
        if (!stackInSlot.m_41619_()) {
            if (stackInSlot.m_41613_() >= Math.min(stackInSlot.m_41741_(), this.getSlotLimit(slot))) {
                return stack;
            }
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)stackInSlot)) {
                return stack;
            }
            if (!this.canPlaceItemThroughFace(slot1, stack) || !this.inv.m_7013_(slot1, stack)) {
                return stack;
            }
            int m = Math.min(stack.m_41741_(), this.getSlotLimit(slot)) - stackInSlot.m_41613_();
            if (stack.m_41613_() <= m) {
                if (!simulate) {
                    ItemStack copy = stack.m_41777_();
                    copy.m_41769_(stackInSlot.m_41613_());
                    this.setInventorySlotContents(slot1, copy);
                }
                return ItemStack.f_41583_;
            }
            stack = stack.m_41777_();
            if (!simulate) {
                ItemStack copy = stack.m_41620_(m);
                copy.m_41769_(stackInSlot.m_41613_());
                this.setInventorySlotContents(slot1, copy);
                return stack;
            }
            stack.m_41774_(m);
            return stack;
        }
        if (!this.canPlaceItemThroughFace(slot1, stack) || !this.inv.m_7013_(slot1, stack)) {
            return stack;
        }
        int m = this.newStackInsertLimit.limitInsert(slot, slot1, stack);
        if (m < stack.m_41613_()) {
            stack = stack.m_41777_();
            if (!simulate) {
                this.setInventorySlotContents(slot1, stack.m_41620_(m));
                return stack;
            }
            stack.m_41774_(m);
            return stack;
        }
        if (!simulate) {
            this.setInventorySlotContents(slot1, stack);
        }
        return ItemStack.f_41583_;
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        int slot1 = this.getSlot(this.inv, slot);
        if (slot1 != -1) {
            this.setInventorySlotContents(slot1, stack);
        }
    }

    private void setInventorySlotContents(int slot, ItemStack stack) {
        this.inv.m_6596_();
        this.inv.m_6836_(slot, stack);
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.f_41583_;
        }
        int slot1 = this.getSlot(this.inv, slot);
        if (slot1 == -1) {
            return ItemStack.f_41583_;
        }
        ItemStack stackInSlot = this.inv.m_8020_(slot1);
        if (stackInSlot.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (!this.canTakeItemThroughFace(slot1, stackInSlot)) {
            return ItemStack.f_41583_;
        }
        if (simulate) {
            if (stackInSlot.m_41613_() < amount) {
                return stackInSlot.m_41777_();
            }
            ItemStack copy = stackInSlot.m_41777_();
            copy.m_41764_(amount);
            return copy;
        }
        int m = Math.min(stackInSlot.m_41613_(), amount);
        ItemStack ret = this.inv.m_7407_(slot1, m);
        this.inv.m_6596_();
        return ret;
    }

    public int getSlotLimit(int slot) {
        return this.slotLimit.applyAsInt(slot);
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        int slot1 = this.getSlot(this.inv, slot);
        return slot1 == -1 ? false : this.inv.m_7013_(slot1, stack);
    }

    private static interface InsertLimit {
        public int limitInsert(int var1, int var2, ItemStack var3);
    }
}

