/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.compat.msm.kaleidoscopecookery.cookery;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.maidsoulkitchen.compat.msm.common.craft.base.EnchantCommonUseAction;
import com.github.wallev.maidsoulkitchen.compat.msm.common.craft.util.IFailGuideUseActionContext;
import com.github.wallev.maidsoulkitchen.vhelper.client.resources.VResourceLocation;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceLocation;
import studio.fantasyit.maid_storage_manager.craft.context.AbstractCraftActionContext;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayer;

public class CookerAction
extends AbstractCraftActionContext
implements IFailGuideUseActionContext {
    public static final ResourceLocation TYPE = VResourceLocation.createMod("cooker");
    int endTick = 0;
    int startTickCount = 0;
    List<Integer> stirFryTimes = Lists.newArrayList();
    final EnchantCommonUseAction useAction;

    public CookerAction(EntityMaid maid, CraftGuideData craftGuideData, CraftGuideStepData craftGuideStepData, CraftLayer layer) {
        super(maid, craftGuideData, craftGuideStepData, layer);
        this.useAction = new EnchantCommonUseAction(maid, craftGuideData, craftGuideStepData, layer);
    }

    public AbstractCraftActionContext.Result start() {
        AbstractCraftActionContext.Result useStart = this.useAction.start();
        if (useStart != AbstractCraftActionContext.Result.FAIL) {
            CompoundTag extraData = this.craftGuideStepData.getExtraData();
            CookerTimeInfo cookerTimeInfo = CookerTime.toCookerTime(extraData).cookerTime();
            int time = cookerTimeInfo.time + 10;
            int stirFryMinCount = cookerTimeInfo.stirFryCount;
            if (this.endTick == 0) {
                int tickCount;
                this.startTickCount = tickCount = Objects.requireNonNull(this.maid.f_19853_.m_7654_()).m_129921_();
                this.endTick = tickCount + time;
            }
            this.initCookerInfo(time, stirFryMinCount);
        }
        return useStart;
    }

    void initCookerInfo(int time, int stirFryMinCount) {
        Random random = new Random();
        int stirFrySpace = (time - 20) / stirFryMinCount;
        for (int tick = 0; tick < time + 20; ++tick) {
            int nextInt;
            if (tick % stirFrySpace == 0) {
                this.stirFryTimes.add(tick);
                continue;
            }
            if (tick % 5 != 0 || tick % (nextInt = random.nextInt(1, 10)) != 0) continue;
            this.stirFryTimes.add(tick);
        }
    }

    public AbstractCraftActionContext.Result tick() {
        int tickCount = Objects.requireNonNull(this.maid.f_19853_.m_7654_()).m_129921_();
        if (tickCount < this.endTick) {
            int tickSpace = tickCount - this.startTickCount;
            if (this.stirFryTimes.contains(tickSpace)) {
                this.useAction.tick();
            }
            return AbstractCraftActionContext.Result.CONTINUE;
        }
        return AbstractCraftActionContext.Result.SUCCESS;
    }

    public void stop() {
        this.useAction.stop();
        this.endTick = 0;
    }

    public record CookerTime(CookerTimeInfo cookerTime) {
        public static final Codec<CookerTime> CODEC = RecordCodecBuilder.create(ins -> ins.group((App)CookerTimeInfo.CODEC.fieldOf("cookerTime").forGetter(CookerTime::cookerTime)).apply((Applicative)ins, CookerTime::new));

        public CompoundTag toCompoundTag() {
            return CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this).result().map(tag -> (CompoundTag)tag).orElseGet(CompoundTag::new);
        }

        public static CompoundTag toCompoundTag(int time, int stirFryCount) {
            CookerTimeInfo cookerTimeInfo = new CookerTimeInfo(time, stirFryCount);
            return new CookerTime(cookerTimeInfo).toCompoundTag();
        }

        public static CookerTime toCookerTime(CompoundTag compoundTag) {
            return CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)compoundTag).result().orElse(new CookerTime(new CookerTimeInfo(0, 0)));
        }
    }

    private record CookerTimeInfo(int time, int stirFryCount) {
        public static final Codec<CookerTimeInfo> CODEC = RecordCodecBuilder.create(ins -> ins.group((App)Codec.INT.fieldOf("time").forGetter(CookerTimeInfo::time), (App)Codec.INT.fieldOf("stirFryCount").forGetter(CookerTimeInfo::stirFryCount)).apply((Applicative)ins, CookerTimeInfo::new));
    }
}

