/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.compat.msm.tea_aroma.foam;

import cn.foggyhillside.tea_aroma.recipe.FoamRecipe;
import cn.foggyhillside.tea_aroma.registry.ModItems;
import cn.foggyhillside.tea_aroma.registry.ModRecipeTypes;
import com.github.wallev.maidsoulkitchen.compat.msm.common.autocraftguide.base.AutoCraftGuideGeneratorRegister;
import com.github.wallev.maidsoulkitchen.compat.msm.common.autocraftguide.tea.ITeaGuideGenerator;
import com.github.wallev.maidsoulkitchen.compat.msm.common.craft.base.EnchantCommonUseAction;
import com.github.wallev.maidsoulkitchen.compat.msm.common.craft.custom.SneakCommonUseAction;
import com.github.wallev.maidsoulkitchen.compat.msm.common.craft.util.FailCraftGuideStepData;
import com.github.wallev.maidsoulkitchen.compat.msm.common.util.CraftGuideOperator2;
import com.github.wallev.maidsoulkitchen.compat.msm.common.util.action.TargetUtil;
import com.github.wallev.maidsoulkitchen.compat.msm.tea_aroma.util.TeaBrewingFoamHelper;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskInfo;
import com.github.wallev.maidsoulkitchen.vhelper.client.resources.VResourceLocation;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import studio.fantasyit.maid_storage_manager.craft.action.ActionOption;
import studio.fantasyit.maid_storage_manager.craft.action.ActionOptionSet;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;

@AutoCraftGuideGeneratorRegister(value=TaskInfo.MSM_TA_FOAM)
public class GeneratorTaFoamGuide
implements ITeaGuideGenerator<FoamRecipe> {
    @Override
    public void generateSteps(BlockPos pos, Level level, FoamRecipe recipe, CraftGuideOperator2 craftGuide, List<ItemStack> realItems, boolean needContainer, List<ItemStack> containers, List<ItemStack> outputs, List<ItemStack> remains) {
        ItemStack cup = realItems.remove(0);
        ItemStack liquid = realItems.remove(realItems.size() - 1);
        craftGuide.addStep(new CraftGuideStepData(TargetUtil.makeTargetVirtualNoSide(pos), List.of(cup), List.of(), SneakCommonUseAction.TYPE));
        CraftGuideOperator2.forEachSingleItem(realItems, itemStack -> craftGuide.addItemUse(pos.m_7494_(), (ItemStack)itemStack));
        ItemStack leftFluidTeaBase = this.leftFluidTeaBase(liquid.m_255036_(1));
        CraftGuideStepData data = new CraftGuideStepData(TargetUtil.makeTargetVirtualNoSide(pos.m_7494_()), List.of(), List.of(liquid), EnchantCommonUseAction.TYPE, ActionOptionSet.with((ActionOption)ActionOption.OPTIONAL, (Object)true));
        CompoundTag compoundTag = FailCraftGuideStepData.toCompoundTag(data);
        CraftGuideStepData resultStepData = new CraftGuideStepData(TargetUtil.makeTargetVirtualNoSide(pos.m_7494_()), List.of(liquid), List.of(leftFluidTeaBase), EnchantCommonUseAction.TYPE, compoundTag);
        craftGuide.addStep(resultStepData);
        craftGuide.addEmptyUse(pos.m_7494_(), outputs);
    }

    @Override
    public ItemStack leftFluidTeaBase(ItemStack itemStack) {
        return TeaBrewingFoamHelper.leftTeaFluidBase(itemStack);
    }

    @Override
    public List<Ingredient> getCups(FoamRecipe recipe) {
        return List.of(Ingredient.m_43927_((ItemStack[])new ItemStack[]{recipe.getTea()}));
    }

    @Override
    public List<Ingredient> getTeaLeaves(FoamRecipe recipe) {
        return List.of();
    }

    @Override
    public List<Ingredient> getFluidTeaBase(FoamRecipe recipe) {
        return List.of(TeaBrewingFoamHelper.milkLiquidIngredient());
    }

    @Override
    public List<ItemStack> getTea(FoamRecipe recipe, RegistryAccess registryAccess) {
        return List.of(recipe.m_8043_(registryAccess));
    }

    @Override
    @NotNull
    public ResourceLocation getType() {
        assert (ModRecipeTypes.FOAM_RECIPE.getId() != null);
        return VResourceLocation.createTypeMod(ModRecipeTypes.FOAM_RECIPE.getId());
    }

    @Override
    public <T extends Container> T convert2InputsInv(List<ItemStack> allInputs) {
        return (T)this.simpleContainer(allInputs);
    }

    @Override
    public String getRecipeTranslateKeyFromJei() {
        return ITeaGuideGenerator.super.getRecipeTranslateKeyFromJei();
    }

    @Override
    public Item getBlockItemForTranslate() {
        return ((Item)ModItems.CUP.get()).m_5456_();
    }

    @Override
    public RecipeType<FoamRecipe> getRecipeType() {
        return FoamRecipe.Type.INSTANCE;
    }
}

