/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.modclazzchecker.core.classana.clazz;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class SignatureConverter {
    public static String toASMString(Constructor<?> constructor) {
        String className = constructor.getDeclaringClass().getName().replace('.', '/');
        StringBuilder descriptor = new StringBuilder("(");
        for (Class<?> paramType : constructor.getParameterTypes()) {
            descriptor.append(SignatureConverter.typeToDescriptor(paramType));
        }
        descriptor.append(")V");
        return className + "#<init>" + descriptor.toString();
    }

    public static String toASMStringWithoutClazz(Constructor<?> constructor) {
        StringBuilder descriptor = new StringBuilder("(");
        for (Class<?> paramType : constructor.getParameterTypes()) {
            descriptor.append(SignatureConverter.typeToDescriptor(paramType));
        }
        descriptor.append(")V");
        return "<init>" + descriptor.toString();
    }

    public static String toASMString(Method method) {
        String className = method.getDeclaringClass().getName().replace('.', '/');
        String descriptor = SignatureConverter.descriptorToASM(method);
        return className + "#" + method.getName() + descriptor;
    }

    public static String toASMStringWithoutClazz(Method method) {
        String descriptor = SignatureConverter.descriptorToASM(method);
        return method.getName() + descriptor;
    }

    public static String descriptorToASM(Method method) {
        StringBuilder sb = new StringBuilder("(");
        for (Class<?> paramType : method.getParameterTypes()) {
            sb.append(SignatureConverter.typeToDescriptor(paramType));
        }
        sb.append(")");
        sb.append(SignatureConverter.typeToDescriptor(method.getReturnType()));
        return sb.toString();
    }

    public static String typeToDescriptor(Class<?> type) {
        if (type == Void.TYPE) {
            return "V";
        }
        if (type == Boolean.TYPE) {
            return "Z";
        }
        if (type == Byte.TYPE) {
            return "B";
        }
        if (type == Character.TYPE) {
            return "C";
        }
        if (type == Short.TYPE) {
            return "S";
        }
        if (type == Integer.TYPE) {
            return "I";
        }
        if (type == Long.TYPE) {
            return "J";
        }
        if (type == Float.TYPE) {
            return "F";
        }
        if (type == Double.TYPE) {
            return "D";
        }
        if (type.isArray()) {
            return "[" + SignatureConverter.typeToDescriptor(type.getComponentType());
        }
        return "L" + type.getName().replace('.', '/') + ";";
    }
}

