/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.modclazzchecker.core.classana.clazz;

import com.github.wallev.maidsoulkitchen.modclazzchecker.core.classana.IMods;
import com.github.wallev.maidsoulkitchen.modclazzchecker.core.classana.ITaskInfo;
import com.github.wallev.maidsoulkitchen.modclazzchecker.core.classana.ModTaskMixinMap;
import com.github.wallev.maidsoulkitchen.modclazzchecker.core.classana.TaskMixinAnalyzer;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public class TaskClazzInfo {
    public static final Function<Codec<IMods>, Codec<TaskClazzInfo>> CODEC = mc -> RecordCodecBuilder.create(ins -> ins.group((App)Codec.unboundedMap((Codec)Codec.STRING, ClazzTaskInfo.CODEC).fieldOf("clazzInfoMap").forGetter(TaskClazzInfo::clazzInfoMap), (App)Codec.STRING.listOf().fieldOf("allClazzs").forGetter(TaskClazzInfo::allClazzs), (App)TaskMixinAnalyzer.MOD_TASK_MIXIN_MAP_CODEC.apply((Codec<IMods>)mc).optionalFieldOf("mixinInfo").forGetter(TaskClazzInfo::optionalTaskMixinMap)).apply((Applicative)ins, TaskClazzInfo::new));
    private final Map<String, ClazzTaskInfo> clazzInfoMap;
    private final List<String> allClazzs;
    private ModTaskMixinMap taskMixinMap;

    public TaskClazzInfo(Map<String, ClazzTaskInfo> clazzInfoMap, List<String> allClazzs) {
        this.clazzInfoMap = clazzInfoMap;
        this.allClazzs = allClazzs.stream().sorted().toList();
    }

    public TaskClazzInfo(Map<String, ClazzTaskInfo> clazzInfoMap, ModTaskMixinMap taskMixinMap) {
        this(clazzInfoMap, TaskClazzInfo.createAllClazzs(clazzInfoMap), taskMixinMap);
    }

    public TaskClazzInfo(Map<String, ClazzTaskInfo> clazzInfoMap, List<String> allClazzs, ModTaskMixinMap taskMixinMap) {
        this.clazzInfoMap = clazzInfoMap;
        this.allClazzs = allClazzs.stream().sorted().toList();
        this.taskMixinMap = taskMixinMap;
    }

    public TaskClazzInfo(Map<String, ClazzTaskInfo> stringClazzTaskInfoMap, List<String> list, Optional<ModTaskMixinMap> modTaskMixinMap) {
        this.clazzInfoMap = stringClazzTaskInfoMap;
        this.allClazzs = list.stream().sorted().toList();
        this.taskMixinMap = modTaskMixinMap.orElse(null);
    }

    public Map<String, ClazzTaskInfo> clazzInfoMap() {
        return this.clazzInfoMap;
    }

    private Optional<ModTaskMixinMap> optionalTaskMixinMap() {
        return Optional.ofNullable(this.taskMixinMap);
    }

    public List<String> allClazzs() {
        return this.allClazzs;
    }

    public void setTaskMixinMap(ModTaskMixinMap taskMixinMap) {
        this.taskMixinMap = taskMixinMap;
    }

    public ModTaskMixinMap taskMixinMap() {
        return this.taskMixinMap;
    }

    private static List<String> createAllClazzs(Map<String, ClazzTaskInfo> clazzInfoMap) {
        HashSet<String> clazzs = new HashSet<String>();
        for (ClazzInfo value : clazzInfoMap.values().stream().map(clazzTaskInfo -> clazzTaskInfo.clazzInfo).toList()) {
            clazzs.addAll(value.classes);
        }
        return Lists.newArrayList(clazzs);
    }

    public record ClazzInfo(List<String> classes, List<String> methods, List<String> fields) {
        public static final Codec<ClazzInfo> CODEC = RecordCodecBuilder.create(ins -> ins.group((App)Codec.STRING.listOf().fieldOf("classes").forGetter(ClazzInfo::classes), (App)Codec.STRING.listOf().fieldOf("methods").forGetter(ClazzInfo::methods), (App)Codec.STRING.listOf().fieldOf("fields").forGetter(ClazzInfo::fields)).apply((Applicative)ins, ClazzInfo::new));
    }

    public record ClazzTaskInfo(String bindMod, ClazzInfo clazzInfo) {
        public static final Codec<ClazzTaskInfo> CODEC = RecordCodecBuilder.create(ins -> ins.group((App)Codec.STRING.fieldOf("bindMod").forGetter(ClazzTaskInfo::bindMod), (App)ClazzInfo.CODEC.fieldOf("clazzInfo").forGetter(ClazzTaskInfo::clazzInfo)).apply((Applicative)ins, ClazzTaskInfo::new));

        public static ClazzTaskInfo create(ITaskInfo<?> taskInfo, ClazzInfo clazzInfo) {
            return new ClazzTaskInfo(taskInfo.getBindMod().name(), clazzInfo);
        }
    }
}

