/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.recipe.itemuse;

import com.github.wallev.maidsoulkitchen.init.ModRecipes;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.ParametersAreNullableByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonUseAction;

@ParametersAreNonnullByDefault
@ParametersAreNullableByDefault
public class ItemUseRecipe
implements Recipe<Container> {
    public final ResourceLocation id;
    public final List<ItemStack> inputs;
    public final List<ItemStack> results;
    public final Condition condition;

    public ItemUseRecipe(ResourceLocation id, List<ItemStack> inputs, List<ItemStack> results, Condition condition) {
        this.id = id;
        this.inputs = inputs;
        this.results = results;
        this.condition = condition;
    }

    public boolean m_5818_(Container pContainer, Level pLevel) {
        return false;
    }

    public ItemStack m_5874_(Container pContainer, RegistryAccess pRegistryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return false;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList ingredients = NonNullList.m_182647_((int)this.inputs.size());
        this.inputs.forEach(input -> ingredients.add((Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{input})));
        return ingredients;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return this.results.get(0);
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.ITEM_USE_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return ModRecipes.ITEM_USE_RECIPE;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Condition {
        SINGLE{

            @Override
            public CommonUseAction.USE_TYPE toUseType() {
                return CommonUseAction.USE_TYPE.SINGLE;
            }
        }
        ,
        LONG{

            @Override
            public CommonUseAction.USE_TYPE toUseType() {
                return CommonUseAction.USE_TYPE.LONG;
            }
        };


        public abstract CommonUseAction.USE_TYPE toUseType();

        public String toString() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        public static Condition of(String name) {
            return Condition.valueOf(name.toUpperCase(Locale.ENGLISH));
        }
    }

    public static class Serializer
    implements RecipeSerializer<ItemUseRecipe> {
        public ItemUseRecipe fromJson(ResourceLocation pRecipeId, JsonObject jsonObject) {
            ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
            JsonArray inputsJson = jsonObject.getAsJsonArray("inputs");
            inputsJson.forEach(inputElement -> {
                ItemStack itemStack = ShapedRecipe.m_151274_((JsonObject)((JsonObject)inputElement));
                inputs.add(itemStack);
            });
            ArrayList<ItemStack> results = new ArrayList<ItemStack>();
            JsonArray resultJson = jsonObject.getAsJsonArray("results");
            resultJson.forEach(inputElement -> {
                ItemStack itemStack = ShapedRecipe.m_151274_((JsonObject)((JsonObject)inputElement));
                results.add(itemStack);
            });
            Condition condition = Condition.of(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"condition"));
            return new ItemUseRecipe(pRecipeId, inputs, results, condition);
        }

        @Nullable
        public ItemUseRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            byte inputSize = pBuffer.readByte();
            ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
            for (byte i = 0; i < inputSize; i = (byte)(i + 1)) {
                inputs.add(pBuffer.m_130267_());
            }
            byte resultSize = pBuffer.readByte();
            ArrayList<ItemStack> results = new ArrayList<ItemStack>();
            for (byte i = 0; i < resultSize; i = (byte)(i + 1)) {
                results.add(pBuffer.m_130267_());
            }
            Condition condition = Condition.of(pBuffer.m_130277_());
            return new ItemUseRecipe(pRecipeId, inputs, results, condition);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, ItemUseRecipe pRecipe) {
            List<ItemStack> inputs = pRecipe.inputs;
            pBuffer.writeByte(inputs.size());
            inputs.forEach(arg_0 -> ((FriendlyByteBuf)pBuffer).m_130055_(arg_0));
            List<ItemStack> results = pRecipe.results;
            pBuffer.writeByte(results.size());
            results.forEach(arg_0 -> ((FriendlyByteBuf)pBuffer).m_130055_(arg_0));
            pBuffer.m_130070_(pRecipe.condition.toString());
        }
    }
}

