/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.common.ai;

import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.IChatBubbleData;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.implement.TextChatBubbleData;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.maidsoulkitchen.debug.annotation.SafeRun;
import com.github.wallev.maidsoulkitchen.debug.annotation.TimeRecord;
import com.github.wallev.maidsoulkitchen.task.cook.common.manager.MaidCookManager;
import com.github.wallev.maidsoulkitchen.util.MemoryUtil;
import com.github.wallev.maidsoulkitchen.vhelper.client.chat.VComponent;
import com.github.wallev.maidsoulkitchen.vhelper.server.ai.VBehaviorControl;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.item.crafting.Recipe;

public class CollectChestIngredientsTask<R extends Recipe<? extends Container>>
extends Behavior<EntityMaid>
implements VBehaviorControl {
    private final MaidCookManager<R> rm;

    public CollectChestIngredientsTask(MaidCookManager<R> rm) {
        super((Map)ImmutableMap.of());
        this.rm = rm;
    }

    protected boolean checkExtraStartConditions(ServerLevel pLevel, EntityMaid pOwner) {
        return this.rm.getRunState() == 1;
    }

    @TimeRecord
    @SafeRun
    protected void start(ServerLevel pLevel, EntityMaid pEntity, long pGameTime) {
        MutableComponent append = VComponent.translatable("chat_bubble.maidsoulkitchen.cook.collect_ingredients");
        TextChatBubbleData textChatBubbleData = TextChatBubbleData.type2((Component)append);
        pEntity.getChatBubbleManager().addChatBubble((IChatBubbleData)textChatBubbleData);
    }

    protected boolean canStillUse(ServerLevel pLevel, EntityMaid pEntity, long pGameTime) {
        return !this.rm.getChestInputInventory().done();
    }

    @TimeRecord
    @SafeRun
    protected void tick(ServerLevel pLevel, EntityMaid pOwner, long pGameTime) {
        this.rm.getChestInputInventory().tickScan();
    }

    protected void stop(ServerLevel pLevel, EntityMaid pEntity, long pGameTime) {
        MemoryUtil.eraseCollectChestItemHandler(pEntity);
        this.rm.startGenerateRecs();
    }

    protected boolean m_7773_(long pGameTime) {
        return false;
    }
}

