/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.common.inv.chest;

import com.github.wallev.maidsoulkitchen.task.cook.common.inv.chest.ChestInvsData;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.item.ItemDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class ChestInventory {
    public static final int TICK_SCAN_LIMIT = 10;
    private final List<IItemHandler> chestItemHandlers = new ArrayList<IItemHandler>();
    private final Map<ItemDefinition, ChestItemDef> itemDefinitions = new HashMap<ItemDefinition, ChestItemDef>();
    private int lastItemHandlerSlotIndex = 0;
    private int lastItemHandlerIndex = 0;

    public void init(ChestInvsData data) {
        this.initData(data);
    }

    public boolean needReUpdate() {
        return true;
    }

    public boolean tickScan() {
        boolean thisHandlerEnd;
        if (this.lastItemHandlerIndex >= this.chestItemHandlers.size()) {
            return true;
        }
        int scanItemHandlerSlotMax = this.lastItemHandlerSlotIndex + 10;
        IItemHandler scanItemHandler = this.chestItemHandlers.get(this.lastItemHandlerIndex);
        boolean bl = thisHandlerEnd = scanItemHandlerSlotMax >= scanItemHandler.getSlots();
        if (thisHandlerEnd) {
            scanItemHandlerSlotMax = scanItemHandler.getSlots();
        }
        for (int i = this.lastItemHandlerSlotIndex; i < scanItemHandlerSlotMax; ++i) {
            ++this.lastItemHandlerSlotIndex;
            ItemStack stackInSlot = scanItemHandler.getStackInSlot(i);
            if (stackInSlot.m_41619_()) continue;
            ItemDefinition itemDef = ItemDefinition.of(stackInSlot);
            ChestItemDef handlerMap = this.itemDefinitions.computeIfAbsent(itemDef, k -> new ChestItemDef());
            handlerMap.add(i, scanItemHandler);
        }
        if (thisHandlerEnd) {
            ++this.lastItemHandlerIndex;
            this.lastItemHandlerSlotIndex = 0;
        }
        return false;
    }

    public void update() {
    }

    protected void reset() {
        this.chestItemHandlers.clear();
        this.itemDefinitions.clear();
        this.lastItemHandlerIndex = 0;
        this.lastItemHandlerSlotIndex = 0;
    }

    public void clear() {
        this.reset();
    }

    public boolean done() {
        return this.lastItemHandlerIndex >= this.chestItemHandlers.size();
    }

    protected void clearAndInitData(ChestInvsData data) {
        this.clear();
        this.initData(data);
    }

    protected void initData(ChestInvsData data) {
        this.chestItemHandlers.addAll(data.chestItemHandlers());
    }

    public Map<ItemDefinition, ChestItemDef> getItemDefinitions() {
        return this.itemDefinitions;
    }

    public Map<ItemDefinition, Long> getAvailable() {
        return this.itemDefinitions.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((ChestItemDef)entry.getValue()).getCount()));
    }

    public static class ChestItemDef {
        private int count;
        private final Map<IItemHandler, List<Integer>> valueMap = new HashMap<IItemHandler, List<Integer>>();

        public int getCount() {
            return this.count;
        }

        public Map<IItemHandler, List<Integer>> getValueMap() {
            return this.valueMap;
        }

        public void add(int slot, IItemHandler itemHandler) {
            ItemStack stackInSlot = itemHandler.getStackInSlot(slot);
            this.count += stackInSlot.m_41613_();
            this.valueMap.computeIfAbsent(itemHandler, k -> new ArrayList()).add(slot);
        }
    }
}

