/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.common.inv.maid;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.maidsoulkitchen.inventory.container.item.BagType;
import com.github.wallev.maidsoulkitchen.item.ItemCulinaryHub;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.maid.IMaidCookInventory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class MaidCookBagInventory
extends IMaidCookInventory {
    private final ItemStack stack;
    private final Map<Item, Integer> inventoryItem = new HashMap<Item, Integer>();
    private final Map<Item, List<ItemStack>> inventoryStack = new HashMap<Item, List<ItemStack>>();
    private final List<ItemStack> lastInvStack = new ArrayList<ItemStack>();
    private Map<BagType, ItemStackHandler> containers;
    private Map<BagType, IItemHandlerModifiable> itemStackHandlers;
    private IItemHandlerModifiable inputInv;
    private IItemHandlerModifiable outputInv;

    public MaidCookBagInventory(EntityMaid maid, ItemStack stack) {
        super(maid);
        this.stack = stack;
        this.initInvData();
    }

    @Override
    protected void initInvData() {
        this.containers = ItemCulinaryHub.getContainers(this.stack);
        int i = 0;
        ItemStackHandler[] handlers = new ItemStackHandler[ItemCulinaryHub.INPUT_BAG_TYPES.length];
        for (BagType inputBagType : ItemCulinaryHub.INPUT_BAG_TYPES) {
            handlers[i++] = this.containers.get((Object)inputBagType);
        }
        CombinedInvWrapper inputInv = new CombinedInvWrapper((IItemHandlerModifiable[])handlers);
        HashMap<BagType, IItemHandlerModifiable> itemStackHandlers = new HashMap<BagType, IItemHandlerModifiable>();
        for (BagType inputBagType : ItemCulinaryHub.INPUT_BAG_TYPES) {
            itemStackHandlers.put(inputBagType, (IItemHandlerModifiable)inputInv);
        }
        ItemStackHandler outputInv = this.containers.get((Object)BagType.OUTPUT);
        itemStackHandlers.put(BagType.OUTPUT, (IItemHandlerModifiable)outputInv);
        itemStackHandlers.put(BagType.INPUT, (IItemHandlerModifiable)inputInv);
        this.itemStackHandlers = itemStackHandlers;
        this.inputInv = inputInv;
        this.outputInv = outputInv;
    }

    @Override
    public void refreshInv() {
        this.clearCacheStackInfo();
        this.initInvData();
        IItemHandlerModifiable availableInv = this.itemStackHandlers.get((Object)BagType.INGREDIENT);
        for (int i = 0; i < availableInv.getSlots(); ++i) {
            ItemStack stack = availableInv.getStackInSlot(i);
            this.proseLastInvStack(i, stack);
            if (stack.m_41619_()) continue;
            this.add(stack);
            this.itemInventory.add(stack);
        }
    }

    @Override
    protected void proseLastInvStack(int index, ItemStack invStack) {
        ItemStack cacheStack;
        if (index < this.lastInvStack.size() && (cacheStack = this.lastInvStack.get(index)).m_150930_(invStack.m_41720_()) && cacheStack != invStack) {
            cacheStack.m_41764_(invStack.m_41613_());
            return;
        }
        this.lastInvStack.add(invStack.m_41777_());
    }

    @Override
    protected void clearCacheStackInfo() {
        this.itemInventory.clear();
        this.inventoryItem.clear();
        this.inventoryStack.clear();
        this.lastInvStack.clear();
    }

    @Override
    protected void add(ItemStack stack) {
        if (!stack.m_41619_()) {
            Item item = stack.m_41720_();
            if (this.inventoryStack.get(item) == null) {
                ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
                stackList.add(stack);
                this.inventoryStack.put(item, stackList);
            } else {
                this.inventoryStack.get(item).add(stack);
            }
            this.inventoryItem.merge(item, stack.m_41613_(), (a, b) -> a + b);
        }
    }

    @Override
    public Map<Item, List<ItemStack>> getInventoryStack() {
        return this.inventoryStack;
    }

    @Override
    public Map<Item, Integer> getInventoryItem() {
        return this.inventoryItem;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    public List<ItemStack> getLastInvStack() {
        return this.lastInvStack;
    }

    @Override
    public IItemHandlerModifiable getAvailableInv(BagType bagType) {
        return this.itemStackHandlers.get((Object)bagType);
    }

    @Override
    public IItemHandlerModifiable getInputInv() {
        return this.inputInv;
    }

    @Override
    public IItemHandlerModifiable getOutputInv() {
        return this.outputInv;
    }

    @Override
    public void syncInv() {
        this.calcAvailableSlots();
        ItemCulinaryHub.setContainer(this.stack, this.containers);
    }
}

