/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.common.rule.cook;

import com.github.wallev.maidsoulkitchen.task.cook.common.cook.be.CookBeBase;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.item.ItemInventory;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.maid.IMaidCookInventory;
import com.github.wallev.maidsoulkitchen.task.cook.common.manager.GatherResult;
import com.github.wallev.maidsoulkitchen.task.cook.common.manager.MaidCookManager;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.cook.AbstractCookRule;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.MaidRec;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class FluidPotCookRule1<B extends BlockEntity, R extends Recipe<? extends Container>>
extends AbstractCookRule<B, R> {
    private static final FluidPotCookRule1 INSTANCE = new FluidPotCookRule1();

    public static <B extends BlockEntity, R extends Recipe<? extends Container>> FluidPotCookRule1<B, R> getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean canMoveTo(CookBeBase<B> cookBeBase, MaidCookManager<R> cm) {
        IMaidCookInventory cookInv = cm.getCookInv();
        boolean hasInputAvailableSlot = cookInv.hasInputAvailableSlot();
        boolean hasOutputAvailableSlot = cookInv.hasOutputAvailableSlot();
        boolean canTakeResult = cookBeBase.canTakeResult();
        boolean hasResult = cookBeBase.hasResult();
        if (canTakeResult && hasResult && hasOutputAvailableSlot) {
            return true;
        }
        ItemStack nowContainer = cookBeBase.getNowContainer();
        boolean hasContainer = !nowContainer.m_41619_();
        boolean matchCookState = cookBeBase.cookStateMatch();
        boolean recMatch = cookBeBase.recMatch();
        boolean hasFluid = cookBeBase.hasFluid();
        if (hasFluid && hasOutputAvailableSlot && !recMatch && (hasContainer ? hasInputAvailableSlot && this.hasFluidContainers(cookBeBase.getFluid(), cm) : this.hasFluidContainers(cookBeBase.getFluid(), cm))) {
            return true;
        }
        boolean hasInputs = cookBeBase.hasInputs();
        if (hasInputs && hasInputAvailableSlot && !recMatch) {
            return true;
        }
        if (hasContainer && hasInputAvailableSlot && !hasInputs) {
            return true;
        }
        return matchCookState && !recMatch && !hasInputs && !hasFluid && cm.hasMaidRecs(cookBeBase);
    }

    @Override
    public void cookMake(CookBeBase<B> cookBeBase, MaidCookManager<R> cm) {
        FluidStack fluidStack;
        boolean hasFluid;
        IItemHandlerModifiable inputInv = cm.getInputInv();
        IItemHandlerModifiable outputInv = cm.getOutputInv();
        IMaidCookInventory cookInv = cm.getCookInv();
        boolean hasInputAvailableSlot = cookInv.hasInputAvailableSlot();
        boolean hasOutputAvailableSlot = cookInv.hasOutputAvailableSlot();
        ItemStack meal = cookBeBase.getMeal();
        ItemStack nowContainer = cookBeBase.getNowContainer();
        if (!meal.m_41619_() && hasInputAvailableSlot) {
            ItemStack needContainer;
            GatherResult outputAdditionItemResult;
            if (!nowContainer.m_41619_()) {
                cookBeBase.takeItem(nowContainer, (IItemHandler)inputInv);
            }
            if (!(outputAdditionItemResult = cm.getItem(needContainer = cookBeBase.getNeedContainer())).isFail()) {
                ItemStack container = outputAdditionItemResult.queryItemStack();
                cookBeBase.insertContainer(container);
                cookBeBase.markChanged();
                outputAdditionItemResult.backItemStack(container);
            }
        }
        boolean canTakeResult = cookBeBase.canTakeResult();
        ItemStack result = cookBeBase.getResult();
        if (canTakeResult && !result.m_41619_() && hasOutputAvailableSlot) {
            cookBeBase.takeItem(result, (IItemHandler)outputInv);
            cookBeBase.awardExp();
            cookBeBase.markChanged();
        }
        boolean matchCookState = cookBeBase.cookStateMatch();
        boolean recMatch = cookBeBase.recMatch();
        boolean hasInputs = cookBeBase.hasInputs();
        if (!recMatch && hasInputs && hasInputAvailableSlot) {
            cookBeBase.takeInputs((IItemHandler)inputInv);
            cookBeBase.markChanged();
        }
        if (!recMatch && !nowContainer.m_41619_() && hasInputAvailableSlot) {
            cookBeBase.takeItem(nowContainer, (IItemHandler)inputInv);
            cookBeBase.markChanged();
        }
        boolean bl = hasFluid = !(fluidStack = cookBeBase.getFluidStack()).isEmpty();
        if (matchCookState && !recMatch && !hasInputs && !hasFluid && cm.hasMaidRecs(cookBeBase)) {
            ItemInventory itemInventory = cm.getItemInventory();
            MaidRec maidRec = cm.pollMaidRec(cookBeBase);
            cookBeBase.insertFluidItems(maidRec.fluidItem(), itemInventory, inputInv);
            cookBeBase.insertInputs(maidRec, itemInventory);
            cookBeBase.markChanged();
            recMatch = true;
        }
        if (!recMatch && hasFluid && hasOutputAvailableSlot) {
            Fluid fluid = fluidStack.getFluid();
            GatherResult fluidContainerResult = this.getFluidContainers(fluid, cm);
            ItemStack itemStack = fluidContainerResult.queryItemStack();
            cookBeBase.useItem(itemStack, () -> !fluidStack.isEmpty(), outputInv);
            fluidContainerResult.backItemStack(itemStack);
        }
    }
}

