/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.common.rule.cook;

import com.github.wallev.maidsoulkitchen.task.cook.common.cook.be.CookBeBase;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.item.ItemInventory;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.maid.IMaidCookInventory;
import com.github.wallev.maidsoulkitchen.task.cook.common.manager.GatherResult;
import com.github.wallev.maidsoulkitchen.task.cook.common.manager.MaidCookManager;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.cook.AbstractCookRule;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.MaidRec;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class FluidPotCookRule2<B extends BlockEntity, R extends Recipe<? extends Container>>
extends AbstractCookRule<B, R> {
    private static final FluidPotCookRule2 INSTANCE = new FluidPotCookRule2();

    public static <B extends BlockEntity, R extends Recipe<? extends Container>> FluidPotCookRule2<B, R> getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean canMoveTo(CookBeBase<B> cookBeBase, MaidCookManager<R> cm) {
        IMaidCookInventory cookInv = cm.getCookInv();
        boolean hasInputAvailableSlot = cookInv.hasInputAvailableSlot();
        boolean hasOutputAvailableSlot = cookInv.hasOutputAvailableSlot();
        boolean matchCookState = cookBeBase.cookStateMatch();
        boolean recMatch = cookBeBase.recMatch();
        boolean hasInputs = cookBeBase.hasInputs();
        boolean hasFluid = cookBeBase.hasFluid();
        if (!recMatch && hasFluid && hasOutputAvailableSlot && this.hasFluidContainers(cookBeBase.getFluid(), cm)) {
            return true;
        }
        if (matchCookState && !hasInputs && !recMatch && !hasFluid && cm.hasMaidRecs(cookBeBase)) {
            return true;
        }
        return hasInputs && hasInputAvailableSlot && !recMatch;
    }

    @Override
    public void cookMake(CookBeBase<B> cookBeBase, MaidCookManager<R> cm) {
        Fluid fluid;
        GatherResult fluidContainerResult;
        IItemHandlerModifiable inputInv = cm.getInputInv();
        IItemHandlerModifiable outputInv = cm.getOutputInv();
        IMaidCookInventory cookInv = cm.getCookInv();
        boolean hasInputAvailableSlot = cookInv.hasInputAvailableSlot();
        boolean hasOutputAvailableSlot = cookInv.hasOutputAvailableSlot();
        boolean matchCookState = cookBeBase.cookStateMatch();
        boolean recMatch = cookBeBase.recMatch();
        boolean hasInputs = cookBeBase.hasInputs();
        FluidStack fluidStack = cookBeBase.getFluidStack();
        if (!recMatch && hasInputs && hasInputAvailableSlot) {
            cookBeBase.takeInputs((IItemHandler)inputInv);
            cookBeBase.markChanged();
        }
        if (matchCookState && !recMatch && fluidStack.isEmpty() && !hasInputs && cm.hasMaidRecs(cookBeBase)) {
            ItemInventory itemInventory = cm.getItemInventory();
            MaidRec maidRec = cm.pollMaidRec(cookBeBase);
            cookBeBase.insertFluidItems(maidRec.fluidItem(), itemInventory, inputInv);
            cookBeBase.insertInputs(maidRec, itemInventory);
            cookBeBase.markChanged();
            recMatch = true;
        }
        if (!recMatch && !fluidStack.isEmpty() && hasOutputAvailableSlot && !(fluidContainerResult = this.getFluidContainers(fluid = fluidStack.getFluid(), cm)).isFail()) {
            ItemStack itemStack = fluidContainerResult.queryItemStack();
            cookBeBase.useItem(itemStack, () -> !fluidStack.isEmpty(), outputInv);
            fluidContainerResult.backItemStack(itemStack);
        }
    }
}

