/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.cuisine.cuisine;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.maidsoulkitchen.mixin.compat.cuisinedelight.CookingDataAccessor;
import com.github.wallev.maidsoulkitchen.mixin.compat.cuisinedelight.CookingEntryAccessor;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskClassAnalyzer;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskInfo;
import com.github.wallev.maidsoulkitchen.task.cook.common.cook.be.CookBeBase;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.item.ItemInventory;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.maid.IMaidCookInventory;
import com.github.wallev.maidsoulkitchen.task.cook.common.manager.MaidCookManager;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.cook.TickCookRule;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.MaidItem;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.MaidRec;
import com.github.wallev.maidsoulkitchen.util.InvUtil;
import com.github.wallev.maidsoulkitchen.util.fakeplayer.WrappedMaidFakePlayer;
import com.mojang.datafixers.util.Pair;
import dev.xkmc.cuisinedelight.content.block.CuisineSkilletBlockEntity;
import dev.xkmc.cuisinedelight.content.logic.CookedFoodData;
import dev.xkmc.cuisinedelight.content.logic.CookingData;
import dev.xkmc.cuisinedelight.content.logic.IngredientConfig;
import dev.xkmc.cuisinedelight.content.logic.transform.Stage;
import dev.xkmc.cuisinedelight.content.recipe.BaseCuisineRecipe;
import dev.xkmc.cuisinedelight.init.registrate.CDItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import vectorwing.farmersdelight.common.registry.ModSounds;

@TaskClassAnalyzer(value=TaskInfo.CD_CUISINE_SKILLET)
public class CuisineCookRule
extends TickCookRule<CuisineSkilletBlockEntity, BaseCuisineRecipe<?>> {
    private static final CuisineCookRule INSTANCE = new CuisineCookRule();
    private int tickAll = 0;
    private int tickMax = 0;
    private int tickSpace = Integer.MAX_VALUE;
    private List<Pair<Integer, ItemStack>> processTickStacks = new ArrayList<Pair<Integer, ItemStack>>();
    private ItemStack plateItem = ItemStack.f_41583_;
    private boolean end = false;

    public CuisineCookRule() {
        super((Item)CDItems.SPATULA.get());
    }

    public static CuisineCookRule getInstance() {
        return INSTANCE;
    }

    private static int getReduction(ItemStack stack) {
        return stack.getEnchantmentLevel(Enchantments.f_44985_) > 0 ? 20 : 0;
    }

    public static void playSound(EntityMaid maid, Level level, SoundEvent event) {
        Vec3 pos = maid.m_20182_();
        double x = pos.m_7096_() + 0.5;
        double y = pos.m_7098_();
        double z = pos.m_7094_() + 0.5;
        level.m_7785_(x, y, z, event, SoundSource.BLOCKS, 0.4f, level.f_46441_.m_188501_() * 0.2f + 0.9f, false);
    }

    private static void processV1(Level worldIn, EntityMaid maid, CuisineSkilletBlockEntity cuisineSkilletBlockEntity) {
        if (!cuisineSkilletBlockEntity.cookingData.contents.isEmpty()) {
            if (!worldIn.m_5776_()) {
                cuisineSkilletBlockEntity.stir(worldIn.m_46467_(), CuisineCookRule.getReduction(maid.m_21205_()));
                maid.m_6674_(InteractionHand.MAIN_HAND);
            } else {
                CuisineCookRule.playSound(maid, worldIn, (SoundEvent)ModSounds.BLOCK_SKILLET_SIZZLE.get());
                maid.m_6674_(InteractionHand.MAIN_HAND);
            }
        }
    }

    @Override
    public boolean canMoveTo(CookBeBase<CuisineSkilletBlockEntity> cookBeBase, MaidCookManager<BaseCuisineRecipe<?>> cm) {
        IMaidCookInventory cookInv = cm.getCookInv();
        boolean hasOutputAvailableSlot = cookInv.hasOutputAvailableSlot();
        CuisineSkilletBlockEntity blockEntity = cookBeBase.getBe();
        return !blockEntity.isCooking() && blockEntity.canCook() && hasOutputAvailableSlot && cm.hasMaidRecs(cookBeBase);
    }

    @Override
    public void cookMake(CookBeBase<CuisineSkilletBlockEntity> cookBeBase, MaidCookManager<BaseCuisineRecipe<?>> cm) {
        this.init(cookBeBase, cm);
        CuisineSkilletBlockEntity cuisineSkilletBlockEntity = cookBeBase.getBe();
        ItemStack mainHandItem = this.maid.m_21205_();
        if (!mainHandItem.m_150930_(this.kitchenToolItem)) {
            IItemHandlerModifiable inputInv = cm.getInputInv();
            ItemStack shovel = InvUtil.getStack((IItemHandler)inputInv, this.kitchenToolItem);
            if (shovel.m_41619_()) {
                this.stop();
                return;
            }
            this.swapTool(shovel, cm.getItemInventory(), this.maid, InteractionHand.MAIN_HAND, (IItemHandler)inputInv);
        }
        MaidRec maidRec = cm.pollMaidRec(cookBeBase);
        ItemInventory itemInventory = cm.getItemInventory();
        if (maidRec == null) {
            this.tickStop(cookBeBase, cm);
            cuisineSkilletBlockEntity.sync();
            return;
        }
        for (MaidItem maidItem : maidRec.maidItems()) {
            IngredientConfig.IngredientEntry entry;
            ItemStack itemStack = this.contItemStack(maidItem, itemInventory);
            if (itemStack.m_41619_() || (entry = IngredientConfig.get().getEntry(itemStack)) == null) continue;
            this.tickMax = Math.max(this.tickMax, entry.min_time);
            this.tickSpace = Math.min(this.tickSpace, entry.stir_time);
            this.processTickStacks.add((Pair<Integer, ItemStack>)Pair.of((Object)entry.min_time, (Object)itemStack));
        }
        this.processTickStacks.sort((a, b) -> (Integer)a.getFirst() == 0 ? -1 : Integer.compare((Integer)b.getFirst(), (Integer)a.getFirst()));
        WrappedMaidFakePlayer fakePlayer = WrappedMaidFakePlayer.get(this.maid);
        Integer time = (Integer)this.processTickStacks.get(0).getFirst();
        List<Pair> list = this.processTickStacks.stream().filter(pair -> pair.getFirst() == time || (Integer)pair.getFirst() == this.tickMax).toList();
        this.processTickStacks.removeAll(list);
        BlockPos blockPos = cuisineSkilletBlockEntity.m_58899_();
        for (Pair integerItemStackPair : list) {
            fakePlayer.useOnByItem(blockPos, (ItemStack)integerItemStackPair.getSecond(), cm.getInputInv());
        }
    }

    @Override
    public boolean tickCan(CookBeBase<CuisineSkilletBlockEntity> cookBeBase, MaidCookManager<BaseCuisineRecipe<?>> cm) {
        return super.tickCan(cookBeBase, cm) && !this.end;
    }

    @Override
    public void tickCookMake(CookBeBase<CuisineSkilletBlockEntity> cookBeBase, MaidCookManager<BaseCuisineRecipe<?>> cm) {
        Pair<Integer, ItemStack> pair;
        ++this.tickAll;
        CuisineSkilletBlockEntity cuisineSkilletBlockEntity = cookBeBase.getBe();
        Level worldIn = cuisineSkilletBlockEntity.m_58904_();
        if ((this.tickAll + 10) % this.tickSpace == 0) {
            CuisineCookRule.processV1(worldIn, this.maid, cuisineSkilletBlockEntity);
        }
        if (!this.processTickStacks.isEmpty() && this.tickAll + 10 == this.tickMax - (Integer)(pair = this.processTickStacks.get(0)).getFirst()) {
            IItemHandlerModifiable inputInv = cm.getInputInv();
            WrappedMaidFakePlayer fakePlayer = WrappedMaidFakePlayer.get(this.maid);
            Integer time = (Integer)this.processTickStacks.get(0).getFirst();
            List<Pair> list = this.processTickStacks.stream().filter(pair0 -> pair0.getFirst() == time || (Integer)pair0.getFirst() == this.tickMax).toList();
            this.processTickStacks.removeAll(list);
            BlockPos blockPos = cuisineSkilletBlockEntity.m_58899_();
            for (Pair integerItemStackPair : list) {
                fakePlayer.useOnByItem(blockPos, (ItemStack)integerItemStackPair.getSecond(), inputInv);
            }
        }
        if (this.tickAll - 10 >= this.tickMax) {
            CookingData data = cuisineSkilletBlockEntity.cookingData;
            data.stir(worldIn.m_46467_(), 0);
            CookedFoodData food = new CookedFoodData(data);
            ItemStack foodStack = BaseCuisineRecipe.findBestMatch((Level)worldIn, (CookedFoodData)food);
            this.plateItem.m_41774_(1);
            ItemHandlerHelper.insertItemStacked((IItemHandler)cm.getOutputInv(), (ItemStack)foodStack, (boolean)false);
            cuisineSkilletBlockEntity.cookingData = new CookingData();
            cuisineSkilletBlockEntity.sync();
            this.maid.m_6674_(InteractionHand.MAIN_HAND);
            this.end = true;
        }
    }

    @Override
    public void tickStop(CookBeBase<CuisineSkilletBlockEntity> cookBeBase, MaidCookManager<BaseCuisineRecipe<?>> cm) {
        this.backpackTool(cookBeBase, cm);
        super.tickStop(cookBeBase, cm);
        cm.getItemInventory().markDirty();
        cm.setNextCheckTickCount(0);
        this.tickAll = 0;
        this.tickMax = 0;
        this.tickSpace = Integer.MAX_VALUE;
        this.processTickStacks.clear();
        this.plateItem = ItemStack.f_41583_;
        this.end = false;
    }

    private boolean foodExistAndTake(CookBeBase<CuisineSkilletBlockEntity> cookBeBase, MaidCookManager<BaseCuisineRecipe<?>> rm) {
        CuisineSkilletBlockEntity cuisineSkilletBlockEntity = cookBeBase.getBe();
        CookingData cookingData = cuisineSkilletBlockEntity.cookingData;
        ArrayList contents = cookingData.contents;
        if (!contents.isEmpty()) {
            for (CookingData.CookingEntry entry : contents) {
                float cook_needle;
                ItemStack food = entry.getItem();
                IngredientConfig.IngredientEntry config = IngredientConfig.get().getEntry(food);
                if (config == null || !((cook_needle = Mth.m_14036_((float)(this.getDuration(cookingData, entry, this.maid) / 400.0f), (float)0.0f, (float)1.0f)) < 1.0f)) continue;
                return false;
            }
            CookedFoodData food = new CookedFoodData(cookingData);
            ItemStack foodStack = BaseCuisineRecipe.findBestMatch((Level)cuisineSkilletBlockEntity.m_58904_(), (CookedFoodData)food);
            this.plateItem.m_41774_(1);
            ItemHandlerHelper.insertItemStacked((IItemHandler)rm.getOutputInv(), (ItemStack)foodStack, (boolean)false);
            cuisineSkilletBlockEntity.cookingData = new CookingData();
            cuisineSkilletBlockEntity.sync();
            this.maid.m_6674_(InteractionHand.MAIN_HAND);
            return true;
        }
        return true;
    }

    public boolean canExtractFood(CookBeBase<CuisineSkilletBlockEntity> cookBeBase, MaidCookManager<BaseCuisineRecipe<?>> cm) {
        CuisineSkilletBlockEntity blockEntity = cookBeBase.getBe();
        EntityMaid maid = cm.getMaid();
        CookingData cookingData = blockEntity.cookingData;
        ArrayList contents = cookingData.contents;
        if (!contents.isEmpty() && cm.hasItem(CDItems.PLATE.m_5456_())) {
            for (CookingData.CookingEntry content : contents) {
                Stage stage = content.getStage(cookingData);
                if (stage != Stage.COOKED) continue;
            }
            boolean isCook = false;
            for (CookingData.CookingEntry entry : contents) {
                float cook_needle;
                ItemStack food = entry.getItem();
                IngredientConfig.IngredientEntry config = IngredientConfig.get().getEntry(food);
                if (config == null || !((cook_needle = Mth.m_14036_((float)(this.getDuration(cookingData, entry, maid) / 400.0f), (float)0.0f, (float)1.0f)) < 1.0f)) continue;
                isCook = true;
                break;
            }
            return !isCook;
        }
        return false;
    }

    public float getDuration(CookingData data, CookingData.CookingEntry cookingEntry, EntityMaid maid) {
        return (float)(maid.f_19853_.m_46467_() - ((CookingEntryAccessor)cookingEntry).tlmk$getStartTime()) * ((CookingDataAccessor)data).tlmk$getSpeed();
    }

    @Override
    protected TickCookRule<CuisineSkilletBlockEntity, BaseCuisineRecipe<?>> create() {
        return new CuisineCookRule();
    }
}

