/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.farm.handler.berry;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.maidsoulkitchen.api.task.farm.ICompatFarmHandler;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskClassAnalyzer;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskInfo;
import com.github.wallev.maidsoulkitchen.task.farm.handler.berry.BerryHandler;
import com.github.wallev.maidsoulkitchen.util.InvUtil;
import dev.xkmc.l2harvester.api.HarvestResult;
import dev.xkmc.l2harvester.api.HarvestableBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

@TaskClassAnalyzer(value=TaskInfo.BERRY_L2_HARVESTER)
public class L2BerryHandler
extends BerryHandler {
    @Override
    protected ICompatFarmHandler.Result processCanHarvest(EntityMaid maid, BlockPos cropPos, BlockState cropState) {
        Block block = cropState.m_60734_();
        if (block instanceof HarvestableBlock) {
            HarvestableBlock harvestableBlock = (HarvestableBlock)block;
            return harvestableBlock.getHarvestResult(maid.m_9236_(), cropState, cropPos) != null ? ICompatFarmHandler.Result.ALLOW : ICompatFarmHandler.Result.DENY;
        }
        return ICompatFarmHandler.Result.DEFAULT;
    }

    @Override
    protected boolean processHarvest(EntityMaid maid, BlockPos cropPos, BlockState cropState) {
        Block block = cropState.m_60734_();
        if (block instanceof HarvestableBlock) {
            HarvestableBlock harvestableBlock = (HarvestableBlock)block;
            HarvestResult result = harvestableBlock.getHarvestResult(maid.m_9236_(), cropState, cropPos);
            if (result != null) {
                result.updateState(maid.m_9236_(), cropPos);
                InvUtil.insertAndPop(maid, result.drops());
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isFarmBlock(Block block) {
        return block instanceof HarvestableBlock;
    }

    @Override
    public ItemStack getIcon() {
        return Items.f_42780_.m_7968_();
    }

    @Override
    public ResourceLocation getUid() {
        return TaskInfo.BERRY_L2_HARVESTER.getUid();
    }
}

