/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.network.packet.c2s;

import com.github.tartaricacid.touhoulittlemaid.api.entity.data.TaskDataKey;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskManager;
import com.github.wallev.maidsoulkitchen.api.task.farm.ICompatFarmTask;
import com.github.wallev.maidsoulkitchen.entity.data.inner.task.berryfruit.v1.BerryFruitData;
import com.github.wallev.maidsoulkitchen.util.ByteBufUtil;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public record SyncBerryFruitDataMessage(int maidId, ResourceLocation taskId, BerryFruitData berryFruitData) {
    public static void encode(SyncBerryFruitDataMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.maidId());
        buf.m_130085_(message.taskId());
        BerryFruitData berryFruitDataV2 = message.berryFruitData();
        ByteBufUtil.writeMapSB(berryFruitDataV2.rules(), buf);
        buf.writeInt(berryFruitDataV2.searchYOffset());
    }

    public static SyncBerryFruitDataMessage decode(FriendlyByteBuf buf) {
        int maidId = buf.readInt();
        ResourceLocation taskId = buf.m_130281_();
        Map<String, Boolean> rules = ByteBufUtil.readMapSB(buf);
        int searchYOffset = buf.readInt();
        return new SyncBerryFruitDataMessage(maidId, taskId, new BerryFruitData(rules, searchYOffset));
    }

    public static void handle(SyncBerryFruitDataMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> {
                ServerPlayer sender = context.getSender();
                if (sender == null) {
                    return;
                }
                Entity patt2130$temp = sender.f_19853_.m_6815_(message.maidId);
                if (patt2130$temp instanceof EntityMaid) {
                    EntityMaid maid = (EntityMaid)patt2130$temp;
                    TaskManager.findTask((ResourceLocation)message.taskId).ifPresent(task -> {
                        TaskDataKey cookDataKey = ((ICompatFarmTask)task).getCookDataKey();
                        maid.setAndSyncData(cookDataKey, (Object)message.berryFruitData);
                    });
                }
            });
        }
        context.setPacketHandled(true);
    }
}

