/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.youkaishomecoming.ferment;

import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskClassAnalyzer;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskInfo;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.ingredient.RecIngredient;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.FluidRecSerializerManager;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.RecSerializerManager;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.mkrec.MKRecipe;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import dev.xkmc.youkaishomecoming.content.item.fluid.IYHFluidHolder;
import dev.xkmc.youkaishomecoming.content.item.fluid.SakeBottleItem;
import dev.xkmc.youkaishomecoming.content.item.fluid.YHFluid;
import dev.xkmc.youkaishomecoming.content.pot.ferment.FermentationRecipe;
import dev.xkmc.youkaishomecoming.content.pot.ferment.SimpleFermentationRecipe;
import dev.xkmc.youkaishomecoming.init.registrate.YHBlocks;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.EmptyFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import net.minecraftforge.registries.ForgeRegistries;

@TaskClassAnalyzer(value=TaskInfo.YHC_FERMENTATION_TANK)
public class FermentationRecSerializerManager
extends FluidRecSerializerManager<FermentationRecipe<?>> {
    private static final FermentationRecSerializerManager INSTANCE = new FermentationRecSerializerManager();

    protected FermentationRecSerializerManager() {
        super((RecipeType)YHBlocks.FERMENT_RT.get());
    }

    public static FermentationRecSerializerManager getInstance() {
        return INSTANCE;
    }

    @Override
    protected FluidRecSerializerManager.FluidRecipeInfoProvider<FermentationRecipe<?>> createRecipeInfoProvider() {
        return new FermentationRecipeMKRecipe();
    }

    @Override
    public String getRecipeTypeId() {
        return YHBlocks.FERMENT_RT.getId().toString();
    }

    @Override
    protected void initFluidRecs(Level level) {
        List recipes = this.getRecsFromRm(level);
        HashMap<Fluid, List> fluidItems1 = new HashMap<Fluid, List>();
        HashMap fluidContainers1 = new HashMap();
        for (Fluid fluid2 : ForgeRegistries.FLUIDS.getValues()) {
            ItemStack container;
            if (fluid2 instanceof EmptyFluid || (container = fluid2.m_6859_().m_7968_().getCraftingRemainingItem()).m_41619_()) continue;
            if (fluidContainers1.containsKey(fluid2)) {
                List itemStacks2 = fluidContainers1.getOrDefault(fluid2, Collections.emptyList());
                if (!itemStacks2.stream().noneMatch(itemStack1 -> itemStack1.m_150930_(container.m_41720_()))) continue;
                itemStacks2.add(container);
                continue;
            }
            fluidContainers1.put(fluid2, Lists.newArrayList((Object[])new ItemStack[]{container}));
        }
        for (Item item : ForgeRegistries.ITEMS.getValues()) {
            ItemStack container;
            if (item instanceof SakeBottleItem) {
                ItemStack container2;
                SakeBottleItem sakeBottleItem = (SakeBottleItem)item;
                YHFluid fluid3 = sakeBottleItem.getFluid();
                IYHFluidHolder iyhSake = fluid3.type;
                Fluid rawFluid = fluid3.m_5613_();
                if (fluidItems1.containsKey(rawFluid)) {
                    List fluidItems2 = fluidItems1.getOrDefault(rawFluid, Collections.emptyList());
                    if (fluidItems2.stream().noneMatch(pair1 -> ((ItemStack)pair1.getFirst()).m_150930_(item))) {
                        ((List)fluidItems1.get(rawFluid)).add(Pair.of((Object)item.m_7968_(), (Object)iyhSake.amount()));
                    }
                } else {
                    fluidItems1.put(rawFluid, Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)item.m_7968_(), (Object)iyhSake.amount())}));
                }
                if ((container2 = iyhSake.getContainer().m_7968_()).m_41619_()) continue;
                if (fluidContainers1.containsKey(rawFluid)) {
                    List itemStacks3 = fluidContainers1.getOrDefault(rawFluid, Collections.emptyList());
                    if (!itemStacks3.stream().noneMatch(itemStack1 -> itemStack1.m_150930_(container2.m_41720_()))) continue;
                    itemStacks3.add(container2);
                    continue;
                }
                fluidContainers1.put(rawFluid, Lists.newArrayList((Object[])new ItemStack[]{container2}));
                continue;
            }
            ItemStack defaultInstance = item.m_7968_().m_41777_();
            IFluidHandlerItem iFluidHandlerItem = (IFluidHandlerItem)defaultInstance.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse(null);
            if (iFluidHandlerItem == null || !(iFluidHandlerItem instanceof FluidBucketWrapper)) continue;
            FluidBucketWrapper fluidBucketWrapper = (FluidBucketWrapper)iFluidHandlerItem;
            FluidStack fluidStack = fluidBucketWrapper.getFluid();
            Fluid rawFluid = fluidStack.getRawFluid();
            if (fluidStack.isEmpty() || rawFluid instanceof EmptyFluid) continue;
            if (fluidItems1.containsKey(rawFluid)) {
                List fluidItems2 = fluidItems1.getOrDefault(rawFluid, Collections.emptyList());
                if (fluidItems2.stream().noneMatch(pair1 -> ((ItemStack)pair1.getFirst()).m_150930_(defaultInstance.m_41720_()))) {
                    ((List)fluidItems1.get(rawFluid)).add(Pair.of((Object)defaultInstance, (Object)fluidStack.getAmount()));
                }
            } else {
                fluidItems1.put(rawFluid, Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)defaultInstance, (Object)fluidStack.getAmount())}));
            }
            if ((container = fluidBucketWrapper.getContainer().getCraftingRemainingItem()).m_41619_()) continue;
            if (fluidContainers1.containsKey(rawFluid)) {
                List itemStacks4 = fluidContainers1.getOrDefault(rawFluid, Collections.emptyList());
                if (!itemStacks4.stream().noneMatch(itemStack1 -> itemStack1.m_150930_(container.m_41720_()))) continue;
                itemStacks4.add(container);
                continue;
            }
            fluidContainers1.put(rawFluid, Lists.newArrayList((Object[])new ItemStack[]{container}));
        }
        this.fluidContainers = fluidContainers1;
        ArrayList<MKRecipe<FermentationRecipe>> mkRecipes = new ArrayList<MKRecipe<FermentationRecipe>>();
        for (FermentationRecipe recipe : recipes) {
            SimpleFermentationRecipe fermentationRecipe = (SimpleFermentationRecipe)recipe;
            FluidStack fluidIn = fermentationRecipe.inputFluid;
            if (fluidIn != null && !fluidIn.isEmpty()) {
                ArrayList<ItemStack> fluidItems = new ArrayList<ItemStack>();
                if (fluidItems1.keySet().stream().anyMatch(fluid -> fluid.m_6212_(fluidIn.getFluid()))) {
                    fluidItems1.forEach((fluid, itemStacks) -> {
                        if (fluid.m_6212_(fluidIn.getFluid())) {
                            for (Pair fluidStackPair : itemStacks) {
                                ItemStack outputFluidItem = ((ItemStack)fluidStackPair.getFirst()).m_41777_();
                                int amount = (Integer)fluidStackPair.getSecond();
                                int amountTotal = fluidIn.getAmount();
                                outputFluidItem.m_41764_(Math.max(1, amountTotal / amount));
                                if (!fluidItems.stream().noneMatch(itemStack -> itemStack.m_150930_(outputFluidItem.m_41720_()) && itemStack.m_41613_() == outputFluidItem.m_41613_())) continue;
                                fluidItems.add(outputFluidItem);
                            }
                        }
                    });
                }
                mkRecipes.add(this.createMKRecipe(recipe, fluidItems));
                continue;
            }
            mkRecipes.add(this.createMKRecipe(recipe));
        }
        this.recipes = mkRecipes;
    }

    public static class FermentationRecipeMKRecipe
    extends FluidRecSerializerManager.FluidRecipeInfoProvider<FermentationRecipe<?>> {
        @Override
        public List<RecIngredient> getIngredients(RecSerializerManager<FermentationRecipe<?>> rsm, FermentationRecipe<?> rec) {
            SimpleFermentationRecipe sFermentationRecipe = (SimpleFermentationRecipe)rec;
            return RecIngredient.from(sFermentationRecipe.ingredients);
        }

        @Override
        public ItemStack getOutput(RecSerializerManager<FermentationRecipe<?>> rsm, FermentationRecipe<?> rec) {
            SimpleFermentationRecipe sFermentationRecipe = (SimpleFermentationRecipe)rec;
            FluidStack outputFluid = sFermentationRecipe.outputFluid;
            Fluid fluid = outputFluid.getFluid();
            if (fluid instanceof YHFluid) {
                YHFluid sakeFluid = (YHFluid)fluid;
                return sakeFluid.type.asStack(1);
            }
            if (!sFermentationRecipe.defaultContainer.m_41619_() && !sFermentationRecipe.defaultBottle.m_41619_()) {
                return sFermentationRecipe.defaultBottle;
            }
            for (ItemStack result : sFermentationRecipe.results) {
                if (result.m_41619_()) continue;
                return result;
            }
            return rec.m_8043_((RegistryAccess)RegistryAccess.f_243945_);
        }

        @Override
        public Fluid getOutputFluid(RecSerializerManager<FermentationRecipe<?>> rsm, FermentationRecipe<?> rec) {
            SimpleFermentationRecipe sFermentationRecipe = (SimpleFermentationRecipe)rec;
            FluidStack outputFluid = sFermentationRecipe.outputFluid;
            return outputFluid.getFluid();
        }
    }
}

